/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.type.TypeReference;
import io.a2a.spec.Artifact;
import io.a2a.spec.EventKind;
import io.a2a.spec.Message;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskStatus;
import io.a2a.util.Assert;
import java.util.List;
import java.util.Map;

@JsonTypeName(value="task")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class Task
implements EventKind,
StreamingEventKind {
    public static final TypeReference<Task> TYPE_REFERENCE = new TypeReference<Task>(){};
    public static final String TASK = "task";
    private final String id;
    private final String contextId;
    private final TaskStatus status;
    private final List<Artifact> artifacts;
    private final List<Message> history;
    private final Map<String, Object> metadata;
    private final String kind;

    public Task(String id, String contextId, TaskStatus status, List<Artifact> artifacts, List<Message> history, Map<String, Object> metadata) {
        this(id, contextId, status, artifacts, history, metadata, TASK);
    }

    @JsonCreator
    public Task(@JsonProperty(value="id") String id, @JsonProperty(value="contextId") String contextId, @JsonProperty(value="status") TaskStatus status, @JsonProperty(value="artifacts") List<Artifact> artifacts, @JsonProperty(value="history") List<Message> history, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="kind") String kind) {
        Assert.checkNotNullParam("id", id);
        Assert.checkNotNullParam("contextId", contextId);
        Assert.checkNotNullParam("status", status);
        Assert.checkNotNullParam("kind", kind);
        if (!kind.equals(TASK)) {
            throw new IllegalArgumentException("Invalid Task");
        }
        this.id = id;
        this.contextId = contextId;
        this.status = status;
        this.artifacts = artifacts != null ? List.copyOf(artifacts) : List.of();
        this.history = history != null ? List.copyOf(history) : List.of();
        this.metadata = metadata;
        this.kind = kind;
    }

    public String getId() {
        return this.id;
    }

    public String getContextId() {
        return this.contextId;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public List<Message> getHistory() {
        return this.history;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public static class Builder {
        private String id;
        private String contextId;
        private TaskStatus status;
        private List<Artifact> artifacts;
        private List<Message> history;
        private Map<String, Object> metadata;

        public Builder() {
        }

        public Builder(Task task) {
            this.id = task.id;
            this.contextId = task.contextId;
            this.status = task.status;
            this.artifacts = task.artifacts;
            this.history = task.history;
            this.metadata = task.metadata;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder status(TaskStatus status) {
            this.status = status;
            return this;
        }

        public Builder artifacts(List<Artifact> artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public Builder history(List<Message> history) {
            this.history = history;
            return this;
        }

        public Builder history(Message ... history) {
            this.history = List.of(history);
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Task build() {
            return new Task(this.id, this.contextId, this.status, this.artifacts, this.history, this.metadata);
        }
    }
}

