/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.a2ux.client.junie;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.a2ux.client.junie.JunieAuthData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lorg/jetbrains/a2ux/client/junie/JunieAuthUtil;", "", "<init>", "()V", "generateP256", "Lorg/jetbrains/a2ux/client/junie/JunieAuthData;", "issueJwt", "", "authData", "a2ux-client"})
public final class JunieAuthUtil {
    @NotNull
    public static final JunieAuthUtil INSTANCE = new JunieAuthUtil();

    private JunieAuthUtil() {
    }

    @NotNull
    public final JunieAuthData generateP256() {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
        kpg.initialize(256);
        KeyPair kp = kpg.generateKeyPair();
        PublicKey publicKey = kp.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
        PrivateKey privateKey = kp.getPrivate();
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
        return new JunieAuthData(eCPublicKey, (ECPrivateKey)privateKey);
    }

    @NotNull
    public final String issueJwt(@NotNull JunieAuthData authData) {
        Intrinsics.checkNotNullParameter((Object)authData, (String)"authData");
        Instant now = Instant.now();
        JWTClaimsSet claims = new JWTClaimsSet.Builder().issuer("ide").subject("ide-instance-123").audience("your-server").issueTime(Date.from(now)).expirationTime(Date.from(now.plusSeconds(60L))).jwtID(UUID.randomUUID().toString()).build();
        ECKey jwk = new ECKey.Builder(Curve.P_256, authData.getPublicKey()).privateKey(authData.getPrivateKey()).keyID("ide-key-1").build();
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.ES256).keyID(jwk.getKeyID()).type(JOSEObjectType.JWT).build();
        SignedJWT signed = new SignedJWT(header, claims);
        signed.sign(new ECDSASigner(jwk.toECPrivateKey()));
        String string = signed.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
        return string;
    }
}

