/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.agents.ideformer.daemon;

import ai.grazie.code.agents.ideformer.daemon.IdeFormerDaemonConfig;
import ai.grazie.code.agents.ideformer.executable.IdeFormerExecutableIdentifier;
import ai.grazie.code.agents.ideformer.executable.UtilsKt;
import ai.grazie.code.exec.model.DeviceArchitecture;
import ai.grazie.code.exec.model.DeviceOS;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c\u00b2\u0006\n\u0010\u001d\u001a\u00020\fX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u001e\u001a\u00020\fX\u008a\u0084\u0002"}, d2={"Lai/grazie/code/agents/ideformer/daemon/IdeFormerExecutableResolver;", "", "config", "Lai/grazie/code/agents/ideformer/daemon/IdeFormerDaemonConfig;", "resourcesClassLoader", "Ljava/lang/ClassLoader;", "<init>", "(Lai/grazie/code/agents/ideformer/daemon/IdeFormerDaemonConfig;Ljava/lang/ClassLoader;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "searchedLocationsMessages", "", "", "resolve", "Ljava/nio/file/Path;", "tryResolve", "version", "os", "Lai/grazie/code/exec/model/DeviceOS;", "arch", "Lai/grazie/code/exec/model/DeviceArchitecture;", "resolveJarResource", "executableResourcePath", "resourceUri", "Ljava/net/URI;", "isFileLocked", "", "file", "code-agents-ideformer-daemon", "cachedExecutableChecksum", "resourcesExecutableChecksum"})
@SourceDebugExtension(value={"SMAP\nIdeFormerExecutableResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeFormerExecutableResolver.kt\nai/grazie/code/agents/ideformer/daemon/IdeFormerExecutableResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class IdeFormerExecutableResolver {
    @NotNull
    private final IdeFormerDaemonConfig config;
    @NotNull
    private final ClassLoader resourcesClassLoader;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final List<String> searchedLocationsMessages;

    public IdeFormerExecutableResolver(@NotNull IdeFormerDaemonConfig config, @NotNull ClassLoader resourcesClassLoader) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)resourcesClassLoader, (String)"resourcesClassLoader");
        this.config = config;
        this.resourcesClassLoader = resourcesClassLoader;
        this.logger = KotlinLogging.INSTANCE.logger((Function0<Unit>)((Function0)IdeFormerExecutableResolver::logger$lambda$0));
        this.searchedLocationsMessages = new ArrayList();
    }

    @NotNull
    public final Path resolve() {
        Path path;
        this.searchedLocationsMessages.clear();
        Path path2 = this.tryResolve(this.config.getVersion(), IdeFormerDaemonConfig.Companion.getOs(), IdeFormerDaemonConfig.Companion.getArchitecture());
        if (path2 == null) {
            DeviceOS[] deviceOSArray = new DeviceOS[]{DeviceOS.MAC_OS, DeviceOS.WINDOWS};
            if (CollectionsKt.listOf((Object[])deviceOSArray).contains((Object)IdeFormerDaemonConfig.Companion.getOs()) && IdeFormerDaemonConfig.Companion.getArchitecture() == DeviceArchitecture.ARM_64) {
                this.logger.warn((Function0<? extends Object>)((Function0)IdeFormerExecutableResolver::resolve$lambda$1));
                path2 = this.tryResolve(this.config.getVersion(), IdeFormerDaemonConfig.Companion.getOs(), DeviceArchitecture.X86_64);
            } else {
                path2 = null;
            }
        }
        if (!((path = path2) != null)) {
            boolean $i$a$-require-IdeFormerExecutableResolver$resolve$32 = false;
            String $i$a$-require-IdeFormerExecutableResolver$resolve$32 = "Can't find ideformer executable, tried: " + this.searchedLocationsMessages;
            throw new IllegalArgumentException($i$a$-require-IdeFormerExecutableResolver$resolve$32.toString());
        }
        if (!Files.isExecutable(path)) {
            boolean bl = false;
            String string = "ideformer executable is not executable: " + ((Object)path.toAbsolutePath()).toString();
            throw new IllegalArgumentException(string.toString());
        }
        this.logger.info((Function0<? extends Object>)((Function0)() -> IdeFormerExecutableResolver.resolve$lambda$4(path)));
        return path;
    }

    private final Path tryResolve(String version, DeviceOS os, DeviceArchitecture arch) {
        Path path;
        IdeFormerExecutableIdentifier identifier = new IdeFormerExecutableIdentifier(version, os, arch);
        if (this.config.getResourcesDir() != null) {
            Path path2;
            Path it = path2 = this.config.getResourcesDir().resolve(identifier.getResourcePath());
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.searchedLocationsMessages.add("Provided dir: " + ((Object)it.toAbsolutePath()).toString());
            it = path2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            path = Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path2 : null;
        } else {
            this.searchedLocationsMessages.add("Resources: " + identifier.getResourcePath());
            Serializable serializable = this.resourcesClassLoader.getResource(identifier.getResourcePath());
            if (serializable == null || (serializable = ((URL)serializable).toURI()) == null) {
                return null;
            }
            Serializable resourceUri = serializable;
            String scheme = ((URI)resourceUri).getScheme();
            if (Intrinsics.areEqual((Object)scheme, (Object)"file")) {
                Path path3 = Paths.get((URI)resourceUri);
                path = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            } else if (Intrinsics.areEqual((Object)scheme, (Object)"jar")) {
                path = this.resolveJarResource(identifier.getResourcePath(), (URI)resourceUri);
            } else {
                throw new IllegalArgumentException("Unsupported URI scheme " + scheme + " in URI " + (URI)resourceUri);
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path resolveJarResource(String executableResourcePath, URI resourceUri) {
        if (!(this.config.getCacheDir() != null)) {
            boolean $i$a$-require-IdeFormerExecutableResolver$resolveJarResource$22 = false;
            String $i$a$-require-IdeFormerExecutableResolver$resolveJarResource$22 = "cacheDir must be set to extract resources from JAR";
            throw new IllegalArgumentException($i$a$-require-IdeFormerExecutableResolver$resolveJarResource$22.toString());
        }
        Path cachedExecutable = this.config.getCacheDir().resolve(executableResourcePath);
        Intrinsics.checkNotNull((Object)cachedExecutable);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean cachedExists = Files.exists(cachedExecutable, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        boolean cachedLocked = this.isFileLocked(cachedExecutable);
        Lazy cachedExecutableChecksum$delegate = LazyKt.lazy(() -> IdeFormerExecutableResolver.resolveJarResource$lambda$8(cachedExecutable));
        Lazy resourcesExecutableChecksum$delegate = LazyKt.lazy(() -> IdeFormerExecutableResolver.resolveJarResource$lambda$11(resourceUri));
        if (!(cachedLocked || cachedExists && Intrinsics.areEqual((Object)IdeFormerExecutableResolver.resolveJarResource$lambda$9((Lazy<String>)cachedExecutableChecksum$delegate), (Object)IdeFormerExecutableResolver.resolveJarResource$lambda$12((Lazy<String>)resourcesExecutableChecksum$delegate)))) {
            if (cachedExists) {
                this.logger.warn((Function0<? extends Object>)((Function0)() -> IdeFormerExecutableResolver.resolveJarResource$lambda$13(cachedExecutable, executableResourcePath, cachedExecutableChecksum$delegate, resourcesExecutableChecksum$delegate)));
                Files.delete(cachedExecutable);
            }
            PathsKt.createParentDirectories((Path)cachedExecutable, (FileAttribute[])new FileAttribute[0]);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(cachedExecutable, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
            cachedExecutable.toFile().setExecutable(true);
            Closeable closeable = resourceUri.toURL().openStream();
            Throwable throwable = null;
            try {
                long l;
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                OpenOption[] openOptionArray = new OpenOption[]{};
                OutputStream outputStream2 = Files.newOutputStream(cachedExecutable, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"newOutputStream(...)");
                Closeable closeable2 = outputStream2;
                Throwable throwable2 = null;
                try {
                    OutputStream output = (OutputStream)closeable2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)input);
                    l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this.logger.info((Function0<? extends Object>)((Function0)() -> IdeFormerExecutableResolver.resolveJarResource$lambda$16(cachedExecutable)));
        }
        return cachedExecutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFileLocked(Path file) {
        Object object;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        Object object2 = this;
        try {
            Unit unit;
            IdeFormerExecutableResolver $this$isFileLocked_u24lambda_u2418 = object2;
            boolean bl = false;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE};
            Closeable closeable = FileChannel.open(file, openOptionArray);
            Throwable throwable = null;
            try {
                Unit unit2;
                FileChannel it = (FileChannel)closeable;
                boolean bl2 = false;
                FileLock fileLock = it.tryLock();
                if (fileLock != null) {
                    fileLock.close();
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                unit = unit2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        if (Result.isFailure-impl((Object)object2)) {
            return true;
        }
        Object object3 = object2;
        if (object3 != null) return false;
        return true;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object resolve$lambda$1() {
        return "ideformer executable for " + IdeFormerDaemonConfig.Companion.getOs().name() + " " + IdeFormerDaemonConfig.Companion.getArchitecture().name() + " is not found, trying to fall back to X86_64";
    }

    private static final Object resolve$lambda$4(Path $path) {
        return "Resolved ideformer executable: " + ((Object)$path.toAbsolutePath()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String resolveJarResource$lambda$8(Path $cachedExecutable) {
        String string;
        Intrinsics.checkNotNull((Object)$cachedExecutable);
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream2 = Files.newInputStream($cachedExecutable, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(...)");
        Closeable closeable = inputStream2;
        Throwable throwable = null;
        try {
            InputStream p0 = (InputStream)closeable;
            boolean bl = false;
            string = UtilsKt.calculateSHA256Checksum(p0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    private static final String resolveJarResource$lambda$9(Lazy<String> $cachedExecutableChecksum$delegate) {
        Lazy<String> lazy = $cachedExecutableChecksum$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String resolveJarResource$lambda$11(URI $resourceUri) {
        String string;
        Closeable closeable = $resourceUri.toURL().openStream();
        Throwable throwable = null;
        try {
            InputStream p0 = (InputStream)closeable;
            boolean bl = false;
            string = UtilsKt.calculateSHA256Checksum(p0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    private static final String resolveJarResource$lambda$12(Lazy<String> $resourcesExecutableChecksum$delegate) {
        Lazy<String> lazy = $resourcesExecutableChecksum$delegate;
        return (String)lazy.getValue();
    }

    private static final Object resolveJarResource$lambda$13(Path $cachedExecutable, String $executableResourcePath, Lazy $cachedExecutableChecksum$delegate, Lazy $resourcesExecutableChecksum$delegate) {
        Intrinsics.checkNotNull((Object)$cachedExecutable);
        return StringsKt.trimIndent((String)("\n                    Cached IdeFormer executable exists, but SHA256 checksum doesn't match checksum of the resource, will replace cached.\n                    Cached " + ((Object)$cachedExecutable.toAbsolutePath()).toString() + ": " + IdeFormerExecutableResolver.resolveJarResource$lambda$9((Lazy<String>)$cachedExecutableChecksum$delegate) + "\n                    Resource " + $executableResourcePath + ": " + IdeFormerExecutableResolver.resolveJarResource$lambda$12((Lazy<String>)$resourcesExecutableChecksum$delegate) + "\n                    "));
    }

    private static final Object resolveJarResource$lambda$16(Path $cachedExecutable) {
        Intrinsics.checkNotNull((Object)$cachedExecutable);
        return "Extracted executable to cache: " + ((Object)$cachedExecutable.toAbsolutePath()).toString();
    }
}

