/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.llm.services;

import ai.grazie.llm.services.LLMChatService;
import ai.grazie.llm.services.LLMCompletionService;
import ai.grazie.llm.services.LLMProfileProvider;
import ai.grazie.llm.services.LLMServiceProvider;
import ai.grazie.model.cloud.exceptions.ExtensionsKt;
import ai.grazie.model.llm.profile.LLMProfile;
import ai.grazie.model.llm.profile.LLMProfileID;
import ai.grazie.model.llm.utils.LLMProfilesAccessLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\t*\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"getChat", "Lai/grazie/llm/services/LLMChatService;", "Lai/grazie/llm/services/LLMServiceProvider;", "profileID", "Lai/grazie/model/llm/profile/LLMProfileID;", "getCompletion", "Lai/grazie/llm/services/LLMCompletionService;", "getSupportedProfiles", "", "Lai/grazie/model/llm/profile/LLMProfile;", "accessLevel", "Lai/grazie/model/llm/utils/LLMProfilesAccessLevel;", "getProfileOrFail", "Lai/grazie/llm/services/LLMProfileProvider;", "llm-services"})
@SourceDebugExtension(value={"SMAP\nLLMServiceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMServiceProvider.kt\nai/grazie/llm/services/LLMServiceProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n774#2:72\n865#2,2:73\n774#2:75\n865#2,2:76\n*S KotlinDebug\n*F\n+ 1 LLMServiceProvider.kt\nai/grazie/llm/services/LLMServiceProviderKt\n*L\n45#1:72\n45#1:73,2\n46#1:75\n46#1:76,2\n*E\n"})
public final class LLMServiceProviderKt {
    @NotNull
    public static final LLMChatService getChat(@NotNull LLMServiceProvider $this$getChat, @NotNull LLMProfileID profileID) {
        Intrinsics.checkNotNullParameter((Object)$this$getChat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)profileID, (String)"profileID");
        LLMChatService lLMChatService = $this$getChat.getChats(profileID);
        if (lLMChatService == null) {
            ExtensionsKt.badRequest("No profile with ID " + profileID);
            throw new KotlinNothingValueException();
        }
        return lLMChatService;
    }

    @NotNull
    public static final LLMCompletionService getCompletion(@NotNull LLMServiceProvider $this$getCompletion, @NotNull LLMProfileID profileID) {
        Intrinsics.checkNotNullParameter((Object)$this$getCompletion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)profileID, (String)"profileID");
        LLMCompletionService lLMCompletionService = $this$getCompletion.completions(profileID);
        if (lLMCompletionService == null) {
            ExtensionsKt.badRequest("No profile with ID " + profileID);
            throw new KotlinNothingValueException();
        }
        return lLMCompletionService;
    }

    @NotNull
    public static final List<LLMProfile> getSupportedProfiles(@NotNull LLMServiceProvider $this$getSupportedProfiles, @NotNull LLMProfilesAccessLevel accessLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$getSupportedProfiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)accessLevel), (String)"accessLevel");
        return switch (WhenMappings.$EnumSwitchMapping$0[accessLevel.ordinal()]) {
            case 1 -> $this$getSupportedProfiles.getProfiles();
            case 2 -> {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = $this$getSupportedProfiles.getProfiles();
                boolean $i$f$filter = false;
                Iterable var4_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LLMProfile it = (LLMProfile)element$iv$iv;
                    boolean $i$a$-filter-LLMServiceProviderKt$getSupportedProfiles$1 = false;
                    if (!(!it.checkIfDev())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            case 3 -> {
                Iterable $this$filter$iv = $this$getSupportedProfiles.getProfiles();
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LLMProfile it = (LLMProfile)element$iv$iv;
                    boolean $i$a$-filter-LLMServiceProviderKt$getSupportedProfiles$2 = false;
                    if (!it.checkIfStable()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final LLMProfile getProfileOrFail(@NotNull LLMProfileProvider $this$getProfileOrFail, @NotNull LLMProfileID profileID) {
        Intrinsics.checkNotNullParameter((Object)$this$getProfileOrFail, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)profileID, (String)"profileID");
        LLMProfile lLMProfile = $this$getProfileOrFail.profile(profileID);
        if (lLMProfile == null) {
            throw new IllegalStateException(("Failed to get " + profileID).toString());
        }
        return lLMProfile;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LLMProfilesAccessLevel.values().length];
            try {
                nArray[LLMProfilesAccessLevel.Dev.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMProfilesAccessLevel.Experimental.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMProfilesAccessLevel.Stable.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

