/*
 * Decompiled with CFR 0.152.
 */
package ai.jetbrains.code.prompt.concepts.file.prompt;

import ai.jetbrains.code.prompt.concepts.file.prompt.UtilsKt;
import ai.koog.agents.ext.tool.file.model.FileSize;
import ai.koog.agents.ext.tool.file.model.FileSystemEntry;
import ai.koog.prompt.markdown.MarkdownContentBuilder;
import ai.koog.rag.base.files.FileMetadata;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u001a\u001e\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u001a\u001e\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a8\u0006\t"}, d2={"entry", "", "Lai/koog/prompt/markdown/MarkdownContentBuilder;", "Lai/koog/agents/ext/tool/file/model/FileSystemEntry;", "parent", "directory", "Lai/koog/agents/ext/tool/file/model/FileSystemEntry$Folder;", "file", "Lai/koog/agents/ext/tool/file/model/FileSystemEntry$File;", "code-prompt-concepts"})
@SourceDebugExtension(value={"SMAP\nMarkdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Markdown.kt\nai/jetbrains/code/prompt/concepts/file/prompt/MarkdownKt\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,103:1\n140#2:104\n129#2,5:105\n*S KotlinDebug\n*F\n+ 1 Markdown.kt\nai/jetbrains/code/prompt/concepts/file/prompt/MarkdownKt\n*L\n28#1:104\n28#1:105,5\n*E\n"})
public final class MarkdownKt {
    public static final void entry(@NotNull MarkdownContentBuilder $this$entry, @NotNull FileSystemEntry entry2, @Nullable FileSystemEntry parent) {
        Intrinsics.checkNotNullParameter((Object)$this$entry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        FileSystemEntry fileSystemEntry = entry2;
        if (fileSystemEntry instanceof FileSystemEntry.File) {
            MarkdownKt.file($this$entry, (FileSystemEntry.File)entry2, parent);
        } else if (fileSystemEntry instanceof FileSystemEntry.Folder) {
            MarkdownKt.directory($this$entry, (FileSystemEntry.Folder)entry2, parent);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public static /* synthetic */ void entry$default(MarkdownContentBuilder markdownContentBuilder, FileSystemEntry fileSystemEntry, FileSystemEntry fileSystemEntry2, int n, Object object) {
        if ((n & 2) != 0) {
            fileSystemEntry2 = null;
        }
        MarkdownKt.entry(markdownContentBuilder, fileSystemEntry, fileSystemEntry2);
    }

    public static final void directory(@NotNull MarkdownContentBuilder $this$directory, @NotNull FileSystemEntry.Folder directory, @Nullable FileSystemEntry parent) {
        Object object;
        FileSystemEntry single;
        List<FileSystemEntry> entries2;
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        List<FileSystemEntry> list2 = entries2 = directory.getEntries();
        FileSystemEntry fileSystemEntry = single = list2 != null ? (FileSystemEntry)CollectionsKt.singleOrNull(list2) : null;
        if (single != null) {
            MarkdownKt.entry($this$directory, single, parent);
            return;
        }
        if (parent != null) {
            String relativePath = UtilsKt.trimFilePathSeparator(StringsKt.removePrefix((String)directory.getPath(), (CharSequence)parent.getPath()));
            object = ((CharSequence)relativePath).length() == 0 ? directory.getName() : relativePath;
        } else {
            CharSequence charSequence;
            block6: {
                String $this$trimEnd$iv = directory.getPath();
                boolean $i$f$trimEnd = false;
                CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
                boolean $i$f$trimEnd2 = false;
                int n = $this$trimEnd$iv$iv.length() + -1;
                if (0 <= n) {
                    do {
                        int index$iv$iv = n--;
                        char it = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        if (it == '/') continue;
                        charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                        break block6;
                    } while (0 <= n);
                }
                charSequence = "";
            }
            object = ((Object)charSequence).toString() + "/";
        }
        String displayPath = object;
        $this$directory.line((Function1<? super MarkdownContentBuilder.LineContext, Unit>)((Function1)arg_0 -> MarkdownKt.directory$lambda$1(displayPath, parent, directory, arg_0)));
        if (entries2 != null && !((Collection)entries2).isEmpty()) {
            $this$directory.bulleted((Function1<? super MarkdownContentBuilder.ListContext, Unit>)((Function1)arg_0 -> MarkdownKt.directory$lambda$3(entries2, directory, arg_0)));
        }
    }

    public static /* synthetic */ void directory$default(MarkdownContentBuilder markdownContentBuilder, FileSystemEntry.Folder folder, FileSystemEntry fileSystemEntry, int n, Object object) {
        if ((n & 2) != 0) {
            fileSystemEntry = null;
        }
        MarkdownKt.directory(markdownContentBuilder, folder, fileSystemEntry);
    }

    public static final void file(@NotNull MarkdownContentBuilder $this$file, @NotNull FileSystemEntry.File file, @Nullable FileSystemEntry parent) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        $this$file.line((Function1<? super MarkdownContentBuilder.LineContext, Unit>)((Function1)arg_0 -> MarkdownKt.file$lambda$6(parent, file, arg_0)));
        FileSystemEntry.File.Content content2 = file.getContent();
        if (content2 instanceof FileSystemEntry.File.Content.Excerpt) {
            if (((FileSystemEntry.File.Content.Excerpt)content2).getSnippets().isEmpty()) {
                return;
            }
            if (((FileSystemEntry.File.Content.Excerpt)content2).getSnippets().size() == 1) {
                FileSystemEntry.File.Content.Excerpt.Snippet snippet = (FileSystemEntry.File.Content.Excerpt.Snippet)CollectionsKt.single(((FileSystemEntry.File.Content.Excerpt)content2).getSnippets());
                $this$file.line((Function1<? super MarkdownContentBuilder.LineContext, Unit>)((Function1)arg_0 -> MarkdownKt.file$lambda$7(snippet, arg_0)));
                MarkdownContentBuilder.codeblock$default($this$file, ((Object)StringsKt.trim((CharSequence)snippet.getText())).toString(), null, 2, null);
                return;
            }
            $this$file.bulleted((Function1<? super MarkdownContentBuilder.ListContext, Unit>)((Function1)arg_0 -> MarkdownKt.file$lambda$9(content2, arg_0)));
        } else if (content2 instanceof FileSystemEntry.File.Content.Text) {
            $this$file.unaryPlus("Content:");
            $this$file.codeblock(((Object)StringsKt.trim((CharSequence)((FileSystemEntry.File.Content.Text)content2).getText())).toString(), "");
        } else if (!Intrinsics.areEqual((Object)content2, (Object)FileSystemEntry.File.Content.None.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    public static /* synthetic */ void file$default(MarkdownContentBuilder markdownContentBuilder, FileSystemEntry.File file, FileSystemEntry fileSystemEntry, int n, Object object) {
        if ((n & 2) != 0) {
            fileSystemEntry = null;
        }
        MarkdownKt.file(markdownContentBuilder, file, fileSystemEntry);
    }

    private static final Unit directory$lambda$1(String $displayPath, FileSystemEntry $parent, FileSystemEntry.Folder $directory, MarkdownContentBuilder.LineContext $this$line) {
        Intrinsics.checkNotNullParameter((Object)$this$line, (String)"$this$line");
        $this$line.code($displayPath + ($parent != null && !StringsKt.endsWith$default((String)$displayPath, (String)"/", (boolean)false, (int)2, null) ? "/" : ""));
        if ($directory.getHidden()) {
            $this$line.space();
            $this$line.text("(hidden)");
        }
        return Unit.INSTANCE;
    }

    private static final Unit directory$lambda$3$lambda$2(FileSystemEntry $entry, FileSystemEntry.Folder $directory, MarkdownContentBuilder $this$item) {
        Intrinsics.checkNotNullParameter((Object)$this$item, (String)"$this$item");
        FileSystemEntry fileSystemEntry = $entry;
        if (fileSystemEntry instanceof FileSystemEntry.File) {
            MarkdownKt.file($this$item, (FileSystemEntry.File)$entry, $directory);
        } else if (fileSystemEntry instanceof FileSystemEntry.Folder) {
            MarkdownKt.directory($this$item, (FileSystemEntry.Folder)$entry, $directory);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit directory$lambda$3(List $entries, FileSystemEntry.Folder $directory, MarkdownContentBuilder.ListContext $this$bulleted) {
        Intrinsics.checkNotNullParameter((Object)$this$bulleted, (String)"$this$bulleted");
        for (FileSystemEntry entry2 : $entries) {
            $this$bulleted.item((Function1<? super MarkdownContentBuilder, Unit>)((Function1)arg_0 -> MarkdownKt.directory$lambda$3$lambda$2(entry2, $directory, arg_0)));
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence file$lambda$6$lambda$5$lambda$4(FileSize it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.display();
    }

    private static final Unit file$lambda$6(FileSystemEntry $parent, FileSystemEntry.File $file, MarkdownContentBuilder.LineContext $this$line) {
        List list2;
        String relativePath;
        Intrinsics.checkNotNullParameter((Object)$this$line, (String)"$this$line");
        String displayPath = $parent != null ? (((CharSequence)(relativePath = UtilsKt.trimFilePathSeparator(StringsKt.removePrefix((String)$file.getPath(), (CharSequence)$parent.getPath())))).length() == 0 ? $file.getName() : relativePath) : $file.getPath();
        $this$line.code(displayPath);
        List $this$file_u24lambda_u246_u24lambda_u245 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        if ($file.getContentType() != FileMetadata.FileContentType.Text) {
            $this$file_u24lambda_u246_u24lambda_u245.add($file.getContentType().getDisplay());
        }
        $this$file_u24lambda_u246_u24lambda_u245.add(CollectionsKt.joinToString$default((Iterable)$file.getSize(), (CharSequence)", ", null, null, (int)0, null, MarkdownKt::file$lambda$6$lambda$5$lambda$4, (int)30, null));
        if ($file.getHidden()) {
            $this$file_u24lambda_u246_u24lambda_u245.add("hidden");
        }
        List meta = CollectionsKt.build((List)list2);
        if (!((Collection)meta).isEmpty()) {
            $this$line.space();
            $this$line.text(CollectionsKt.joinToString$default((Iterable)meta, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit file$lambda$7(FileSystemEntry.File.Content.Excerpt.Snippet $snippet, MarkdownContentBuilder.LineContext $this$line) {
        Intrinsics.checkNotNullParameter((Object)$this$line, (String)"$this$line");
        $this$line.bold("Lines " + $snippet.getRange().getStart().getLine() + "-" + $snippet.getRange().getEnd().getLine() + ":");
        return Unit.INSTANCE;
    }

    private static final Unit file$lambda$9$lambda$8(FileSystemEntry.File.Content.Excerpt.Snippet $snippet, MarkdownContentBuilder $this$item) {
        Intrinsics.checkNotNullParameter((Object)$this$item, (String)"$this$item");
        $this$item.bold("Lines " + $snippet.getRange().getStart().getLine() + "-" + $snippet.getRange().getEnd().getLine() + ":");
        $this$item.newline();
        MarkdownContentBuilder.codeblock$default($this$item, ((Object)StringsKt.trim((CharSequence)$snippet.getText())).toString(), null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit file$lambda$9(FileSystemEntry.File.Content $content, MarkdownContentBuilder.ListContext $this$bulleted) {
        Intrinsics.checkNotNullParameter((Object)$this$bulleted, (String)"$this$bulleted");
        for (FileSystemEntry.File.Content.Excerpt.Snippet snippet : ((FileSystemEntry.File.Content.Excerpt)$content).getSnippets()) {
            $this$bulleted.item((Function1<? super MarkdownContentBuilder, Unit>)((Function1)arg_0 -> MarkdownKt.file$lambda$9$lambda$8(snippet, arg_0)));
        }
        return Unit.INSTANCE;
    }
}

