/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.agents.ext.tool.file;

import ai.koog.agents.core.tools.Tool;
import ai.koog.agents.core.tools.ToolDescriptor;
import ai.koog.agents.core.tools.ToolExceptionKt;
import ai.koog.agents.core.tools.ToolParameterDescriptor;
import ai.koog.agents.core.tools.ToolParameterType;
import ai.koog.agents.core.tools.ToolResult;
import ai.koog.agents.core.tools.ToolResultUtils;
import ai.koog.agents.ext.tool.file.EditFileTool;
import ai.koog.agents.ext.tool.file.EditFileTool$Args$;
import ai.koog.agents.ext.tool.file.EditFileTool$Result$;
import ai.koog.agents.ext.tool.file.patch.FilePatch;
import ai.koog.agents.ext.tool.file.patch.PatchApplyResult;
import ai.koog.agents.ext.tool.file.patch.TokenNormalizedPatchApplierKt;
import ai.koog.prompt.markdown.MarkdownContentBuilder;
import ai.koog.prompt.markdown.MarkdownKt;
import ai.koog.rag.base.files.ExtensionsKt;
import ai.koog.rag.base.files.FileMetadata;
import ai.koog.rag.base.files.FileSystemProvider;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001f*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002:\u0003\u001d\u001e\u001fB\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0003H\u0094@\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0016\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\n\n\u0002\b\u0019\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lai/koog/agents/ext/tool/file/EditFileTool;", "Path", "Lai/koog/agents/core/tools/Tool;", "Lai/koog/agents/ext/tool/file/EditFileTool$Args;", "Lai/koog/agents/ext/tool/file/EditFileTool$Result;", "fs", "Lai/koog/rag/base/files/FileSystemProvider$ReadWrite;", "<init>", "(Lai/koog/rag/base/files/FileSystemProvider$ReadWrite;)V", "argsSerializer", "Lkotlinx/serialization/KSerializer;", "getArgsSerializer", "()Lkotlinx/serialization/KSerializer;", "resultSerializer", "getResultSerializer", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "descriptor", "Lai/koog/agents/core/tools/ToolDescriptor;", "getDescriptor", "()Lai/koog/agents/core/tools/ToolDescriptor;", "descriptor$1", "execute", "args", "(Lai/koog/agents/ext/tool/file/EditFileTool$Args;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Args", "Result", "Companion", "agents-ext"})
@SourceDebugExtension(value={"SMAP\nEditFileTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditFileTool.kt\nai/koog/agents/ext/tool/file/EditFileTool\n+ 2 ToolResultUtils.kt\nai/koog/agents/core/tools/ToolResultUtils$Companion\n*L\n1#1,260:1\n24#2:261\n*S KotlinDebug\n*F\n+ 1 EditFileTool.kt\nai/koog/agents/ext/tool/file/EditFileTool\n*L\n230#1:261\n*E\n"})
public final class EditFileTool<Path>
extends Tool<Args, Result> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystemProvider.ReadWrite<Path> fs;
    @NotNull
    private final KSerializer<Args> argsSerializer;
    @NotNull
    private final KSerializer<Result> resultSerializer;
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @NotNull
    private final ToolDescriptor descriptor$1;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0<Unit>)((Function0)EditFileTool::logger$lambda$3));
    @NotNull
    private static final String toolName = "edit_file";
    @NotNull
    private static final String toolDescription = MarkdownKt.markdown((Function1<? super MarkdownContentBuilder, Unit>)((Function1)EditFileTool::toolDescription$lambda$7));
    @NotNull
    private static final ToolDescriptor descriptor;

    public EditFileTool(@NotNull FileSystemProvider.ReadWrite<Path> fs) {
        Intrinsics.checkNotNullParameter(fs, (String)"fs");
        this.fs = fs;
        this.argsSerializer = Args.Companion.serializer();
        ToolResultUtils.Companion this_$iv = ToolResultUtils.Companion;
        boolean $i$f$toTextSerializer = false;
        this.resultSerializer = new ToolResult.AsTextSerializer<Result>(Result.Companion.serializer());
        this.name = toolName;
        this.description = toolDescription;
        this.descriptor$1 = descriptor;
    }

    @Override
    @NotNull
    public KSerializer<Args> getArgsSerializer() {
        return this.argsSerializer;
    }

    @Override
    @NotNull
    public KSerializer<Result> getResultSerializer() {
        return this.resultSerializer;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public ToolDescriptor getDescriptor() {
        return this.descriptor$1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected Object execute(@NotNull Args var1_1, @NotNull Continuation<? super Result> $completion) {
        block17: {
            block16: {
                block15: {
                    if (!($completion instanceof execute.1)) ** GOTO lbl-1000
                    var8_3 = $completion;
                    if ((var8_3.label & -2147483648) != 0) {
                        var8_3.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, $completion){
                            Object L$0;
                            Object L$1;
                            /* synthetic */ Object result;
                            final /* synthetic */ EditFileTool<Path> this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return this.this$0.execute(null, (Continuation<Result>)((Continuation)this));
                            }
                        };
                    }
                    $result = $continuation.result;
                    var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            path = this.fs.fromAbsolutePathString(args.getPath());
                            $continuation.L$0 = args;
                            $continuation.L$1 = path;
                            $continuation.label = 1;
                            v0 = this.fs.exists(path, (Continuation<Boolean>)$continuation);
                            if (v0 == var9_5) {
                                return var9_5;
                            }
                            ** GOTO lbl25
                        }
                        case 1: {
                            path = $continuation.L$1;
                            args = (Args)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            if (!((Boolean)v0).booleanValue()) ** GOTO lbl39
                            $continuation.L$0 = args;
                            $continuation.L$1 = path;
                            $continuation.label = 2;
                            v1 = this.fs.getFileContentType(path, (Continuation<FileMetadata.FileContentType>)$continuation);
                            if (v1 == var9_5) {
                                return var9_5;
                            }
                            ** GOTO lbl38
                        }
                        case 2: {
                            path = $continuation.L$1;
                            args = (Args)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl38:
                            // 2 sources

                            ToolExceptionKt.validate((fileContentType = (FileMetadata.FileContentType)v1) == FileMetadata.FileContentType.Text, (Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$0(java.lang.Object ai.koog.rag.base.files.FileMetadata$FileContentType ), ()Ljava/lang/String;)((Object)path, (FileMetadata.FileContentType)fileContentType));
lbl39:
                            // 2 sources

                            $continuation.L$0 = args;
                            $continuation.L$1 = path;
                            $continuation.label = 3;
                            v2 = this.fs.exists(path, (Continuation<Boolean>)$continuation);
                            if (v2 == var9_5) {
                                return var9_5;
                            }
                            ** GOTO lbl51
                        }
                        case 3: {
                            path = $continuation.L$1;
                            args = (Args)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl51:
                            // 2 sources

                            if (!((Boolean)v2).booleanValue()) break;
                            $continuation.L$0 = args;
                            $continuation.L$1 = path;
                            $continuation.label = 4;
                            v3 = ExtensionsKt.readText(this.fs, path, (Continuation<? super String>)$continuation);
                            if (v3 == var9_5) {
                                return var9_5;
                            }
                            ** GOTO lbl64
                        }
                        case 4: {
                            path = $continuation.L$1;
                            args = (Args)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl64:
                            // 2 sources

                            v4 = (String)v3;
                            break block15;
                        }
                    }
                    v4 = "";
                }
                content = v4;
                patch = new FilePatch(args.getOriginal(), args.getReplacement());
                patchApplyResult = TokenNormalizedPatchApplierKt.applyTokenNormalizedPatch(content, patch);
                if (!TokenNormalizedPatchApplierKt.isSuccess(patchApplyResult)) break block16;
                $continuation.L$0 = patchApplyResult;
                $continuation.L$1 = null;
                $continuation.label = 5;
                v5 = ExtensionsKt.writeText(this.fs, path, ((PatchApplyResult.Success)patchApplyResult).getUpdatedContent(), (Continuation<? super Unit>)$continuation);
                if (v5 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl83
                {
                    case 5: {
                        patchApplyResult = (PatchApplyResult)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl83:
                        // 2 sources

                        EditFileTool.logger.info((Function0<? extends Object>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$1(), ()Ljava/lang/Object;)());
                        break block17;
                    }
                }
            }
            EditFileTool.logger.info((Function0<? extends Object>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$2(ai.koog.agents.ext.tool.file.patch.PatchApplyResult ), ()Ljava/lang/Object;)((PatchApplyResult)patchApplyResult));
        }
        return new Result(patchApplyResult);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final String execute$lambda$0(Object $path, FileMetadata.FileContentType $fileContentType) {
        return "Can not edit non-text files, tried editing: " + $path + ", which is a " + $fileContentType;
    }

    private static final Object execute$lambda$1() {
        return "Patch was applied";
    }

    private static final Object execute$lambda$2(PatchApplyResult $patchApplyResult) {
        return "Patch was NOT applied because of: " + ((PatchApplyResult.Failure)$patchApplyResult).getReason();
    }

    private static final Unit logger$lambda$3() {
        return Unit.INSTANCE;
    }

    private static final Unit toolDescription$lambda$7$lambda$4(MarkdownContentBuilder.ListContext $this$bulleted) {
        Intrinsics.checkNotNullParameter((Object)$this$bulleted, (String)"$this$bulleted");
        $this$bulleted.item("The 'original' text must match text in the file, whitespaces and line endings will be fuzzy matched");
        $this$bulleted.item("Only ONE replacement per tool call - for multiple changes, call the tool multiple times");
        $this$bulleted.item("Use empty string (\"\") for 'original' when creating new files or performing complete rewrites");
        $this$bulleted.item("The 'original' text must be kept to absolute minimum to ensure effective editing");
        return Unit.INSTANCE;
    }

    private static final Unit toolDescription$lambda$7$lambda$5(MarkdownContentBuilder.ListContext $this$bulleted) {
        Intrinsics.checkNotNullParameter((Object)$this$bulleted, (String)"$this$bulleted");
        $this$bulleted.item("Perform fuzzy or approximate text matching other than whitespaces");
        $this$bulleted.item("Handle multiple replacements in a single call");
        $this$bulleted.item("Automatically fix formatting or indentation mismatches");
        $this$bulleted.item("Provide file content reading capabilities (use read_file for that)");
        return Unit.INSTANCE;
    }

    private static final Unit toolDescription$lambda$7$lambda$6(MarkdownContentBuilder.ListContext $this$bulleted) {
        Intrinsics.checkNotNullParameter((Object)$this$bulleted, (String)"$this$bulleted");
        $this$bulleted.item("Modifying specific functions or code blocks in existing files");
        $this$bulleted.item("Adding new imports, methods, or classes to source files");
        $this$bulleted.item("Creating new configuration files with complete content");
        $this$bulleted.item("Updating documentation or README files");
        $this$bulleted.item("Fixing bugs by replacing problematic code segments");
        return Unit.INSTANCE;
    }

    private static final Unit toolDescription$lambda$7(MarkdownContentBuilder $this$markdown) {
        Intrinsics.checkNotNullParameter((Object)$this$markdown, (String)"$this$markdown");
        $this$markdown.unaryPlus("Makes an edit to a target file by applying a single text replacement patch.");
        $this$markdown.newline();
        $this$markdown.unaryPlus("This tool performs targeted file modifications by replacing specific text segments with new content. ");
        $this$markdown.unaryPlus("It can handle partial edits, complete file rewrites, or new file creation. ");
        $this$markdown.unaryPlus("The tool uses string matching to locate the original text and replaces it with the provided replacement text.");
        $this$markdown.newline();
        $this$markdown.unaryPlus("The tool should be used when you need to modify existing files, create new files, or make precise text replacements. ");
        $this$markdown.unaryPlus("It handles file operations safely by creating parent directories automatically if they don't exist.");
        $this$markdown.newline();
        $this$markdown.h3("Key Requirements");
        $this$markdown.bulleted((Function1<? super MarkdownContentBuilder.ListContext, Unit>)((Function1)EditFileTool::toolDescription$lambda$7$lambda$4));
        $this$markdown.newline();
        $this$markdown.h3("This tool does NOT");
        $this$markdown.bulleted((Function1<? super MarkdownContentBuilder.ListContext, Unit>)((Function1)EditFileTool::toolDescription$lambda$7$lambda$5));
        $this$markdown.newline();
        $this$markdown.h3("Common use cases");
        $this$markdown.bulleted((Function1<? super MarkdownContentBuilder.ListContext, Unit>)((Function1)EditFileTool::toolDescription$lambda$7$lambda$6));
        return Unit.INSTANCE;
    }

    private static final Unit descriptor$lambda$9$lambda$8(MarkdownContentBuilder.LineContext $this$line) {
        Intrinsics.checkNotNullParameter((Object)$this$line, (String)"$this$line");
        $this$line.bold("Examples:");
        $this$line.space();
        $this$line.code("/home/user/project/src/main.kt");
        $this$line.text(", ");
        $this$line.code("C:\\Users\\user\\project\\main.py");
        $this$line.text(", ");
        $this$line.code("/home/user/project/config/settings.json");
        return Unit.INSTANCE;
    }

    private static final Unit descriptor$lambda$9(MarkdownContentBuilder $this$markdown) {
        Intrinsics.checkNotNullParameter((Object)$this$markdown, (String)"$this$markdown");
        $this$markdown.unaryPlus("The absolute path to the target file that will be modified or created.");
        $this$markdown.newline();
        $this$markdown.unaryPlus("Must be a valid file system path. If the file doesn't exist, it will be created along with any necessary parent directories. ");
        $this$markdown.unaryPlus("If the file exists, it will be modified according to the patch operation.");
        $this$markdown.newline();
        $this$markdown.line((Function1<? super MarkdownContentBuilder.LineContext, Unit>)((Function1)EditFileTool::descriptor$lambda$9$lambda$8));
        return Unit.INSTANCE;
    }

    private static final Unit descriptor$lambda$13$lambda$10(MarkdownContentBuilder.ListContext $this$bulleted) {
        Intrinsics.checkNotNullParameter((Object)$this$bulleted, (String)"$this$bulleted");
        $this$bulleted.item("Must match the target text character-for-character");
        $this$bulleted.item("Include sufficient surrounding context to ensure unique matching");
        $this$bulleted.item("Include complete lines with proper line endings");
        $this$bulleted.item("Be concise and minimal to execute specific replacement");
        return Unit.INSTANCE;
    }

    private static final Unit descriptor$lambda$13$lambda$12$lambda$11(MarkdownContentBuilder $this$item) {
        Intrinsics.checkNotNullParameter((Object)$this$item, (String)"$this$item");
        $this$item.text("Use empty string: ");
        $this$item.code("\"\"");
        return Unit.INSTANCE;
    }

    private static final Unit descriptor$lambda$13$lambda$12(MarkdownContentBuilder.ListContext $this$bulleted) {
        Intrinsics.checkNotNullParameter((Object)$this$bulleted, (String)"$this$bulleted");
        $this$bulleted.item((Function1<? super MarkdownContentBuilder, Unit>)((Function1)EditFileTool::descriptor$lambda$13$lambda$12$lambda$11));
        return Unit.INSTANCE;
    }

    private static final Unit descriptor$lambda$13(MarkdownContentBuilder $this$markdown) {
        Intrinsics.checkNotNullParameter((Object)$this$markdown, (String)"$this$markdown");
        $this$markdown.unaryPlus("The exact text block that will be located and replaced in the target file.");
        $this$markdown.newline();
        $this$markdown.h4("For existing file modifications");
        $this$markdown.bulleted((Function1<? super MarkdownContentBuilder.ListContext, Unit>)((Function1)EditFileTool::descriptor$lambda$13$lambda$10));
        $this$markdown.newline();
        $this$markdown.h4("For new files or complete rewrites");
        $this$markdown.bulleted((Function1<? super MarkdownContentBuilder.ListContext, Unit>)((Function1)EditFileTool::descriptor$lambda$13$lambda$12));
        return Unit.INSTANCE;
    }

    private static final Unit descriptor$lambda$17$lambda$14(MarkdownContentBuilder.ListContext $this$bulleted) {
        Intrinsics.checkNotNullParameter((Object)$this$bulleted, (String)"$this$bulleted");
        $this$bulleted.item("Match the indentation style of surrounding code (tabs vs spaces)");
        $this$bulleted.item("Use consistent line endings with the rest of the file");
        $this$bulleted.item("Follow the project's coding style and conventions");
        $this$bulleted.item("Ensure proper syntax for the target file type");
        return Unit.INSTANCE;
    }

    private static final Unit descriptor$lambda$17$lambda$15(MarkdownContentBuilder.ListContext $this$bulleted) {
        Intrinsics.checkNotNullParameter((Object)$this$bulleted, (String)"$this$bulleted");
        $this$bulleted.item("Include all necessary file headers, imports, or boilerplate");
        $this$bulleted.item("Use appropriate file structure for the target language or format");
        $this$bulleted.item("Ensure complete and valid content from start to finish");
        return Unit.INSTANCE;
    }

    private static final Unit descriptor$lambda$17$lambda$16(MarkdownContentBuilder.ListContext $this$bulleted) {
        Intrinsics.checkNotNullParameter((Object)$this$bulleted, (String)"$this$bulleted");
        $this$bulleted.item("Maintain proper syntax and semantic correctness");
        $this$bulleted.item("Include necessary imports if adding new dependencies");
        $this$bulleted.item("Preserve existing code structure and patterns");
        return Unit.INSTANCE;
    }

    private static final Unit descriptor$lambda$17(MarkdownContentBuilder $this$markdown) {
        Intrinsics.checkNotNullParameter((Object)$this$markdown, (String)"$this$markdown");
        $this$markdown.unaryPlus("The new text content that will replace the original text block.");
        $this$markdown.newline();
        $this$markdown.h4("Formatting best practices");
        $this$markdown.bulleted((Function1<? super MarkdownContentBuilder.ListContext, Unit>)((Function1)EditFileTool::descriptor$lambda$17$lambda$14));
        $this$markdown.newline();
        $this$markdown.h4("For new file creation");
        $this$markdown.bulleted((Function1<? super MarkdownContentBuilder.ListContext, Unit>)((Function1)EditFileTool::descriptor$lambda$17$lambda$15));
        $this$markdown.newline();
        $this$markdown.h4("For code modifications");
        $this$markdown.bulleted((Function1<? super MarkdownContentBuilder.ListContext, Unit>)((Function1)EditFileTool::descriptor$lambda$17$lambda$16));
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new ToolParameterDescriptor[]{new ToolParameterDescriptor("path", MarkdownKt.markdown((Function1<? super MarkdownContentBuilder, Unit>)((Function1)EditFileTool::descriptor$lambda$9)), ToolParameterType.String.INSTANCE), new ToolParameterDescriptor("original", MarkdownKt.markdown((Function1<? super MarkdownContentBuilder, Unit>)((Function1)EditFileTool::descriptor$lambda$13)), ToolParameterType.String.INSTANCE), new ToolParameterDescriptor("replacement", MarkdownKt.markdown((Function1<? super MarkdownContentBuilder, Unit>)((Function1)EditFileTool::descriptor$lambda$17)), ToolParameterType.String.INSTANCE)};
        descriptor = new ToolDescriptor(toolName, toolDescription, CollectionsKt.listOf((Object[])objectArray), null, 8, null);
    }

    @Serializable
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B9\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\b!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006$"}, d2={"Lai/koog/agents/ext/tool/file/EditFileTool$Args;", "", "path", "", "original", "replacement", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getPath", "()Ljava/lang/String;", "getOriginal", "getReplacement", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$agents_ext", "$serializer", "Companion", "agents-ext"})
    public static final class Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String path;
        @NotNull
        private final String original;
        @NotNull
        private final String replacement;

        public Args(@NotNull String path, @NotNull String original, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            this.path = path;
            this.original = original;
            this.replacement = replacement;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getOriginal() {
            return this.original;
        }

        @NotNull
        public final String getReplacement() {
            return this.replacement;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.original;
        }

        @NotNull
        public final String component3() {
            return this.replacement;
        }

        @NotNull
        public final Args copy(@NotNull String path, @NotNull String original, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            return new Args(path, original, replacement);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.path;
            }
            if ((n & 2) != 0) {
                string2 = args.original;
            }
            if ((n & 4) != 0) {
                string3 = args.replacement;
            }
            return args.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Args(path=" + this.path + ", original=" + this.original + ", replacement=" + this.replacement + ")";
        }

        public int hashCode() {
            int result2 = this.path.hashCode();
            result2 = result2 * 31 + this.original.hashCode();
            result2 = result2 * 31 + this.replacement.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)args.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.original, (Object)args.original)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.replacement, (Object)args.replacement);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$agents_ext(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.path);
            output.encodeStringElement(serialDesc, 1, self.original);
            output.encodeStringElement(serialDesc, 2, self.replacement);
        }

        public /* synthetic */ Args(int seen0, String path, String original, String replacement, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.path = path;
            this.original = original;
            this.replacement = replacement;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lai/koog/agents/ext/tool/file/EditFileTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lai/koog/agents/ext/tool/file/EditFileTool$Args;", "agents-ext"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lai/koog/agents/ext/tool/file/EditFileTool$Companion;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "toolName", "", "getToolName", "()Ljava/lang/String;", "toolDescription", "getToolDescription", "descriptor", "Lai/koog/agents/core/tools/ToolDescriptor;", "getDescriptor", "()Lai/koog/agents/core/tools/ToolDescriptor;", "agents-ext"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getToolName() {
            return toolName;
        }

        @NotNull
        public final String getToolDescription() {
            return toolDescription;
        }

        @NotNull
        public final ToolDescriptor getDescriptor() {
            return descriptor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B-\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0004\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\b!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lai/koog/agents/ext/tool/file/EditFileTool$Result;", "Lai/koog/agents/core/tools/ToolResult$TextSerializable;", "patchApplyResult", "Lai/koog/agents/ext/tool/file/patch/PatchApplyResult;", "<init>", "(Lai/koog/agents/ext/tool/file/patch/PatchApplyResult;)V", "seen0", "", "applied", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILai/koog/agents/ext/tool/file/patch/PatchApplyResult;ZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getApplied$annotations", "()V", "getApplied", "()Z", "textForLLM", "", "toString", "component1", "copy", "equals", "other", "", "hashCode", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$agents_ext", "$serializer", "Companion", "agents-ext"})
    public static final class Result
    extends ToolResult.TextSerializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final PatchApplyResult patchApplyResult;
        private final boolean applied;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public Result(@NotNull PatchApplyResult patchApplyResult) {
            Intrinsics.checkNotNullParameter((Object)patchApplyResult, (String)"patchApplyResult");
            this.patchApplyResult = patchApplyResult;
            this.applied = TokenNormalizedPatchApplierKt.isSuccess(this.patchApplyResult);
        }

        public final boolean getApplied() {
            return this.applied;
        }

        @Serializable
        public static /* synthetic */ void getApplied$annotations() {
        }

        @Override
        @NotNull
        public String textForLLM() {
            return MarkdownKt.markdown((Function1<? super MarkdownContentBuilder, Unit>)((Function1)arg_0 -> Result.textForLLM$lambda$2(this, arg_0)));
        }

        @NotNull
        public String toString() {
            return this.textForLLM();
        }

        private final PatchApplyResult component1() {
            return this.patchApplyResult;
        }

        @NotNull
        public final Result copy(@NotNull PatchApplyResult patchApplyResult) {
            Intrinsics.checkNotNullParameter((Object)patchApplyResult, (String)"patchApplyResult");
            return new Result(patchApplyResult);
        }

        public static /* synthetic */ Result copy$default(Result result2, PatchApplyResult patchApplyResult, int n, Object object) {
            if ((n & 1) != 0) {
                patchApplyResult = result2.patchApplyResult;
            }
            return result2.copy(patchApplyResult);
        }

        public int hashCode() {
            return this.patchApplyResult.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            return Intrinsics.areEqual((Object)this.patchApplyResult, (Object)result2.patchApplyResult);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$agents_ext(Result self, CompositeEncoder output, SerialDescriptor serialDesc) {
            ToolResult.TextSerializable.write$Self(self, output, serialDesc);
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), (Object)self.patchApplyResult);
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.applied != TokenNormalizedPatchApplierKt.isSuccess(self.patchApplyResult)) {
                output.encodeBooleanElement(serialDesc, 1, self.applied);
            }
        }

        public /* synthetic */ Result(int seen0, PatchApplyResult patchApplyResult, boolean applied, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Result$$serializer.INSTANCE.getDescriptor());
            }
            super(seen0, serializationConstructorMarker);
            this.patchApplyResult = patchApplyResult;
            this.applied = (seen0 & 2) == 0 ? TokenNormalizedPatchApplierKt.isSuccess(this.patchApplyResult) : applied;
        }

        private static final Unit textForLLM$lambda$2$lambda$0(MarkdownContentBuilder.LineContext $this$line) {
            Intrinsics.checkNotNullParameter((Object)$this$line, (String)"$this$line");
            $this$line.bold("Successfully").text(" edited file (patch applied)");
            return Unit.INSTANCE;
        }

        private static final Unit textForLLM$lambda$2$lambda$1(Result this$0, MarkdownContentBuilder.LineContext $this$line) {
            Intrinsics.checkNotNullParameter((Object)$this$line, (String)"$this$line");
            $this$line.text("File was ").bold("not").text(" modified (patch application failed: " + ((PatchApplyResult.Failure)this$0.patchApplyResult).getReason() + ")");
            return Unit.INSTANCE;
        }

        private static final Unit textForLLM$lambda$2(Result this$0, MarkdownContentBuilder $this$markdown) {
            Intrinsics.checkNotNullParameter((Object)$this$markdown, (String)"$this$markdown");
            if (TokenNormalizedPatchApplierKt.isSuccess(this$0.patchApplyResult)) {
                $this$markdown.line((Function1<? super MarkdownContentBuilder.LineContext, Unit>)((Function1)Result::textForLLM$lambda$2$lambda$0));
            } else {
                $this$markdown.line((Function1<? super MarkdownContentBuilder.LineContext, Unit>)((Function1)arg_0 -> Result.textForLLM$lambda$2$lambda$1(this$0, arg_0)));
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> PatchApplyResult.Companion.serializer()), null};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lai/koog/agents/ext/tool/file/EditFileTool$Result$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lai/koog/agents/ext/tool/file/EditFileTool$Result;", "agents-ext"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Result> serializer() {
                return (KSerializer)Result$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

