/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.prompt.executor.ollama.client;

import ai.koog.prompt.dsl.Prompt;
import ai.koog.prompt.executor.ollama.client.ContextWindowStrategyKt;
import ai.koog.prompt.llm.LLModel;
import ai.koog.prompt.tokenizer.PromptTokenizer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \t2\u00020\u0001:\u0001\tJ\u001f\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lai/koog/prompt/executor/ollama/client/ContextWindowStrategy;", "", "computeContextLength", "", "prompt", "Lai/koog/prompt/dsl/Prompt;", "model", "Lai/koog/prompt/llm/LLModel;", "(Lai/koog/prompt/dsl/Prompt;Lai/koog/prompt/llm/LLModel;)Ljava/lang/Long;", "Companion", "prompt-executor-ollama-client"})
public interface ContextWindowStrategy {
    @NotNull
    public static final Companion Companion = ai.koog.prompt.executor.ollama.client.ContextWindowStrategy$Companion.$$INSTANCE;

    @Nullable
    public Long computeContextLength(@NotNull Prompt var1, @NotNull LLModel var2);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lai/koog/prompt/executor/ollama/client/ContextWindowStrategy$Companion;", "", "<init>", "()V", "None", "Fixed", "FitPrompt", "prompt-executor-ollama-client"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ<\u0010\u001e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0011\u0010\u000fR\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006("}, d2={"Lai/koog/prompt/executor/ollama/client/ContextWindowStrategy$Companion$FitPrompt;", "Lai/koog/prompt/executor/ollama/client/ContextWindowStrategy;", "promptTokenizer", "Lai/koog/prompt/tokenizer/PromptTokenizer;", "contextChunkSize", "", "minimumChunkCount", "maximumChunkCount", "<init>", "(Lai/koog/prompt/tokenizer/PromptTokenizer;JLjava/lang/Long;Ljava/lang/Long;)V", "getPromptTokenizer", "()Lai/koog/prompt/tokenizer/PromptTokenizer;", "getContextChunkSize", "()J", "getMinimumChunkCount", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getMaximumChunkCount", "minimumContextLength", "maximumContextLength", "computeContextLength", "prompt", "Lai/koog/prompt/dsl/Prompt;", "model", "Lai/koog/prompt/llm/LLModel;", "(Lai/koog/prompt/dsl/Prompt;Lai/koog/prompt/llm/LLModel;)Ljava/lang/Long;", "component1", "component2", "component3", "component4", "copy", "(Lai/koog/prompt/tokenizer/PromptTokenizer;JLjava/lang/Long;Ljava/lang/Long;)Lai/koog/prompt/executor/ollama/client/ContextWindowStrategy$Companion$FitPrompt;", "equals", "", "other", "", "hashCode", "", "toString", "", "prompt-executor-ollama-client"})
        @SourceDebugExtension(value={"SMAP\nContextWindowStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextWindowStrategy.kt\nai/koog/prompt/executor/ollama/client/ContextWindowStrategy$Companion$FitPrompt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
        public static final class FitPrompt
        implements ContextWindowStrategy {
            @Nullable
            private final PromptTokenizer promptTokenizer;
            private final long contextChunkSize;
            @Nullable
            private final Long minimumChunkCount;
            @Nullable
            private final Long maximumChunkCount;
            @Nullable
            private final Long minimumContextLength;
            @Nullable
            private final Long maximumContextLength;

            public FitPrompt(@Nullable PromptTokenizer promptTokenizer, long contextChunkSize, @Nullable Long minimumChunkCount, @Nullable Long maximumChunkCount) {
                Long l;
                Long l2;
                long cnt;
                FitPrompt fitPrompt;
                this.promptTokenizer = promptTokenizer;
                this.contextChunkSize = contextChunkSize;
                this.minimumChunkCount = minimumChunkCount;
                this.maximumChunkCount = maximumChunkCount;
                FitPrompt fitPrompt2 = this;
                Long l3 = this.minimumChunkCount;
                if (l3 != null) {
                    long l4 = ((Number)l3).longValue();
                    fitPrompt = fitPrompt2;
                    boolean bl = false;
                    l2 = (long)(cnt * this.contextChunkSize);
                    fitPrompt2 = fitPrompt;
                } else {
                    l2 = null;
                }
                fitPrompt2.minimumContextLength = l2;
                FitPrompt fitPrompt3 = this;
                Long l5 = this.maximumChunkCount;
                if (l5 != null) {
                    cnt = ((Number)l5).longValue();
                    fitPrompt = fitPrompt3;
                    boolean bl = false;
                    l = cnt * this.contextChunkSize;
                    fitPrompt3 = fitPrompt;
                } else {
                    l = null;
                }
                fitPrompt3.maximumContextLength = l;
                if (!(this.contextChunkSize > 0L)) {
                    boolean $i$a$-require-ContextWindowStrategy$Companion$FitPrompt$42 = false;
                    String $i$a$-require-ContextWindowStrategy$Companion$FitPrompt$42 = "`contextChunkSize`` must be greater than 0";
                    throw new IllegalArgumentException($i$a$-require-ContextWindowStrategy$Companion$FitPrompt$42.toString());
                }
                if (!(this.minimumChunkCount == null || this.minimumChunkCount > 0L)) {
                    boolean $i$a$-require-ContextWindowStrategy$Companion$FitPrompt$52 = false;
                    String $i$a$-require-ContextWindowStrategy$Companion$FitPrompt$52 = "`minimumChunkCount` must be a positive number or `null`";
                    throw new IllegalArgumentException($i$a$-require-ContextWindowStrategy$Companion$FitPrompt$52.toString());
                }
                if (this.minimumChunkCount != null && this.maximumChunkCount != null && !(this.minimumChunkCount <= this.maximumChunkCount)) {
                    boolean bl = false;
                    String string = "`maximumChunkCount` (" + this.maximumChunkCount + ") must be greater or equal to `minimumChunkCount` (" + this.minimumChunkCount + ")";
                    throw new IllegalArgumentException(string.toString());
                }
            }

            public /* synthetic */ FitPrompt(PromptTokenizer promptTokenizer, long l, Long l2, Long l3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    promptTokenizer = null;
                }
                if ((n & 2) != 0) {
                    l = 2048L;
                }
                if ((n & 4) != 0) {
                    l2 = null;
                }
                if ((n & 8) != 0) {
                    l3 = null;
                }
                this(promptTokenizer, l, l2, l3);
            }

            @Nullable
            public final PromptTokenizer getPromptTokenizer() {
                return this.promptTokenizer;
            }

            public final long getContextChunkSize() {
                return this.contextChunkSize;
            }

            @Nullable
            public final Long getMinimumChunkCount() {
                return this.minimumChunkCount;
            }

            @Nullable
            public final Long getMaximumChunkCount() {
                return this.maximumChunkCount;
            }

            @Override
            @Nullable
            public Long computeContextLength(@NotNull Prompt prompt, @NotNull LLModel model) {
                Integer promptLength;
                Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                Integer n = this.promptTokenizer != null ? Integer.valueOf(this.promptTokenizer.tokenCountFor(prompt)) : (promptLength = prompt.getLatestTokenUsage() != 0 ? Integer.valueOf(prompt.getLatestTokenUsage()) : null);
                if (promptLength == null) {
                    return this.minimumContextLength;
                }
                if (this.maximumContextLength != null && (long)promptLength.intValue() > this.maximumContextLength) {
                    ContextWindowStrategyKt.access$getLogger$p().warn((Function0<? extends Object>)((Function0)() -> FitPrompt.computeContextLength$lambda$5(promptLength, this)));
                    return this.maximumContextLength;
                }
                if ((long)promptLength.intValue() > model.getContextLength()) {
                    ContextWindowStrategyKt.access$getLogger$p().warn((Function0<? extends Object>)((Function0)() -> FitPrompt.computeContextLength$lambda$6(promptLength, model)));
                    return model.getContextLength();
                }
                return ((long)promptLength.intValue() / this.contextChunkSize + 1L) * this.contextChunkSize;
            }

            @Nullable
            public final PromptTokenizer component1() {
                return this.promptTokenizer;
            }

            public final long component2() {
                return this.contextChunkSize;
            }

            @Nullable
            public final Long component3() {
                return this.minimumChunkCount;
            }

            @Nullable
            public final Long component4() {
                return this.maximumChunkCount;
            }

            @NotNull
            public final FitPrompt copy(@Nullable PromptTokenizer promptTokenizer, long contextChunkSize, @Nullable Long minimumChunkCount, @Nullable Long maximumChunkCount) {
                return new FitPrompt(promptTokenizer, contextChunkSize, minimumChunkCount, maximumChunkCount);
            }

            public static /* synthetic */ FitPrompt copy$default(FitPrompt fitPrompt, PromptTokenizer promptTokenizer, long l, Long l2, Long l3, int n, Object object) {
                if ((n & 1) != 0) {
                    promptTokenizer = fitPrompt.promptTokenizer;
                }
                if ((n & 2) != 0) {
                    l = fitPrompt.contextChunkSize;
                }
                if ((n & 4) != 0) {
                    l2 = fitPrompt.minimumChunkCount;
                }
                if ((n & 8) != 0) {
                    l3 = fitPrompt.maximumChunkCount;
                }
                return fitPrompt.copy(promptTokenizer, l, l2, l3);
            }

            @NotNull
            public String toString() {
                return "FitPrompt(promptTokenizer=" + this.promptTokenizer + ", contextChunkSize=" + this.contextChunkSize + ", minimumChunkCount=" + this.minimumChunkCount + ", maximumChunkCount=" + this.maximumChunkCount + ")";
            }

            public int hashCode() {
                int result2 = this.promptTokenizer == null ? 0 : this.promptTokenizer.hashCode();
                result2 = result2 * 31 + Long.hashCode(this.contextChunkSize);
                result2 = result2 * 31 + (this.minimumChunkCount == null ? 0 : ((Object)this.minimumChunkCount).hashCode());
                result2 = result2 * 31 + (this.maximumChunkCount == null ? 0 : ((Object)this.maximumChunkCount).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FitPrompt)) {
                    return false;
                }
                FitPrompt fitPrompt = (FitPrompt)other;
                if (!Intrinsics.areEqual((Object)this.promptTokenizer, (Object)fitPrompt.promptTokenizer)) {
                    return false;
                }
                if (this.contextChunkSize != fitPrompt.contextChunkSize) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.minimumChunkCount, (Object)fitPrompt.minimumChunkCount)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.maximumChunkCount, (Object)fitPrompt.maximumChunkCount);
            }

            private static final Object computeContextLength$lambda$5(Integer $promptLength, FitPrompt this$0) {
                return "Prompt length " + $promptLength + " was more than the maximum context length " + this$0.maximumContextLength + " provideded";
            }

            private static final Object computeContextLength$lambda$6(Integer $promptLength, LLModel $model) {
                return "Prompt length " + $promptLength + " was more than the maximum context length of model '" + $model.getId() + "', falling back to the model's maximum context length " + $model.getContextLength();
            }

            public FitPrompt() {
                this(null, 0L, null, null, 15, null);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lai/koog/prompt/executor/ollama/client/ContextWindowStrategy$Companion$Fixed;", "Lai/koog/prompt/executor/ollama/client/ContextWindowStrategy;", "contextLength", "", "<init>", "(J)V", "getContextLength", "()J", "computeContextLength", "prompt", "Lai/koog/prompt/dsl/Prompt;", "model", "Lai/koog/prompt/llm/LLModel;", "(Lai/koog/prompt/dsl/Prompt;Lai/koog/prompt/llm/LLModel;)Ljava/lang/Long;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "prompt-executor-ollama-client"})
        @SourceDebugExtension(value={"SMAP\nContextWindowStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextWindowStrategy.kt\nai/koog/prompt/executor/ollama/client/ContextWindowStrategy$Companion$Fixed\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
        public static final class Fixed
        implements ContextWindowStrategy {
            private final long contextLength;

            public Fixed(long contextLength) {
                this.contextLength = contextLength;
                if (!(this.contextLength > 0L)) {
                    boolean bl = false;
                    String string = "Context length must be positive but was: " + this.contextLength;
                    throw new IllegalArgumentException(string.toString());
                }
            }

            public final long getContextLength() {
                return this.contextLength;
            }

            @Override
            @NotNull
            public Long computeContextLength(@NotNull Prompt prompt, @NotNull LLModel model) {
                Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                if (this.contextLength > model.getContextLength()) {
                    ContextWindowStrategyKt.access$getLogger$p().warn((Function0<? extends Object>)((Function0)() -> Fixed.computeContextLength$lambda$1(this, model)));
                    return model.getContextLength();
                }
                return this.contextLength;
            }

            public final long component1() {
                return this.contextLength;
            }

            @NotNull
            public final Fixed copy(long contextLength) {
                return new Fixed(contextLength);
            }

            public static /* synthetic */ Fixed copy$default(Fixed fixed, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = fixed.contextLength;
                }
                return fixed.copy(l);
            }

            @NotNull
            public String toString() {
                return "Fixed(contextLength=" + this.contextLength + ")";
            }

            public int hashCode() {
                return Long.hashCode(this.contextLength);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Fixed)) {
                    return false;
                }
                Fixed fixed = (Fixed)other;
                return this.contextLength == fixed.contextLength;
            }

            private static final Object computeContextLength$lambda$1(Fixed this$0, LLModel $model) {
                return "Context length " + this$0.contextLength + " was more than what is supported by model '" + $model.getId() + "', falling back to the model's maximum context length " + $model.getContextLength();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001\u00a8\u0006\u0013"}, d2={"Lai/koog/prompt/executor/ollama/client/ContextWindowStrategy$Companion$None;", "Lai/koog/prompt/executor/ollama/client/ContextWindowStrategy;", "<init>", "()V", "computeContextLength", "", "prompt", "Lai/koog/prompt/dsl/Prompt;", "model", "Lai/koog/prompt/llm/LLModel;", "(Lai/koog/prompt/dsl/Prompt;Lai/koog/prompt/llm/LLModel;)Ljava/lang/Long;", "equals", "", "other", "", "hashCode", "", "toString", "", "prompt-executor-ollama-client"})
        public static final class None
        implements ContextWindowStrategy {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
            }

            @Override
            @Nullable
            public Long computeContextLength(@NotNull Prompt prompt, @NotNull LLModel model) {
                Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                return null;
            }

            @NotNull
            public String toString() {
                return "None";
            }

            public int hashCode() {
                return -1233372242;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof None)) {
                    return false;
                }
                None cfr_ignored_0 = (None)other;
                return true;
            }
        }
    }
}

