/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.telemetry;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u001a\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\b\u0010\r\u001a\u00020\u000eH\u0000\u001a\b\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0006\u0010\u0011\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\t\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"LANGFUSE_BASE_URL", "", "LANGFUSE_OTEL_EXPORT_URL", "getLANGFUSE_OTEL_EXPORT_URL", "()Ljava/lang/String;", "ENVIRONMENT_VARIABLE_KEY", "AUTH_STRING_FILE_NAME", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "langfuseAuthString", "determineLangfuseAuthString", "getAuthFile", "Ljava/io/File;", "getAssistantLogDir", "Ljava/nio/file/Path;", "isOpenTelemetryEnabled", "", "isExportToLangfuseEnabled", "intellij.ml.llm.telemetry"})
@SourceDebugExtension(value={"SMAP\nAIAssistantTelemetryExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantTelemetryExporter.kt\ncom/intellij/ml/llm/telemetry/AIAssistantTelemetryExporterKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,88:1\n57#2:89\n35#2,2:90\n*S KotlinDebug\n*F\n+ 1 AIAssistantTelemetryExporter.kt\ncom/intellij/ml/llm/telemetry/AIAssistantTelemetryExporterKt\n*L\n59#1:89\n59#1:90,2\n*E\n"})
public final class AIAssistantTelemetryExporterKt {
    @NotNull
    public static final String LANGFUSE_BASE_URL = "https://langfuse.labs.jb.gg";
    @NotNull
    private static final String LANGFUSE_OTEL_EXPORT_URL;
    @NotNull
    private static final String ENVIRONMENT_VARIABLE_KEY = "AI_ASSISTANT_LANGFUSE_AUTH";
    @NotNull
    private static final String AUTH_STRING_FILE_NAME = ".ai-assistant-langfuse-auth";
    @NotNull
    private static final Logger logger;
    @Nullable
    private static final String langfuseAuthString;

    @NotNull
    public static final String getLANGFUSE_OTEL_EXPORT_URL() {
        return LANGFUSE_OTEL_EXPORT_URL;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final String determineLangfuseAuthString() {
        String string;
        String string2 = System.getenv(ENVIRONMENT_VARIABLE_KEY);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            logger.warn("Found Langfuse auth string in AI_ASSISTANT_LANGFUSE_AUTH.");
            string = string3;
            return string;
        }
        File file = AIAssistantTelemetryExporterKt.getAuthFile();
        if (file != null) {
            Object object = file;
            File it = object;
            boolean bl = false;
            logger.warn("Found Langfuse auth string in " + it.getName() + ".");
            object = FilesKt.readText$default((File)object, null, (int)1, null);
            if (object != null) {
                string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                return string;
            }
        }
        boolean bl = false;
        logger.warn("No Langfuse auth string found.");
        return null;
    }

    private static final File getAuthFile() {
        String string = SystemProperties.getUserHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
        String userHome = string;
        File file = new File(userHome, AUTH_STRING_FILE_NAME);
        return file.exists() ? file : null;
    }

    @NotNull
    public static final Path getAssistantLogDir() {
        Path path = PathManager.getLogDir().resolve("ai-assistant");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final boolean isOpenTelemetryEnabled() {
        return Intrinsics.areEqual((Object)System.getProperty("llm.opentelemetry.trace.enable", "false"), (Object)"true");
    }

    public static final boolean isExportToLangfuseEnabled() {
        return AIAssistantTelemetryExporterKt.isOpenTelemetryEnabled() && langfuseAuthString != null;
    }

    public static final /* synthetic */ boolean access$isOpenTelemetryEnabled() {
        return AIAssistantTelemetryExporterKt.isOpenTelemetryEnabled();
    }

    public static final /* synthetic */ String access$getLangfuseAuthString$p() {
        return langfuseAuthString;
    }

    static {
        String string = System.getProperty("llm.opentelemetry.export.url");
        if (string == null) {
            string = "https://langfuse.labs.jb.gg/api/public/otel/v1/traces";
        }
        LANGFUSE_OTEL_EXPORT_URL = string;
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        AIAssistantTelemetryExporterKt.logger = logger;
        langfuseAuthString = AIAssistantTelemetryExporterKt.determineLangfuseAuthString();
    }
}

