/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro;

import ai.grazie.def.WordDefinition;
import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.tokenizer.word.WhitespaceWordTokenizer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.grazie.cloud.APIQueries;
import com.intellij.grazie.cloud.GrazieCloudConnector;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.ide.fus.GrazieFUSCounter;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.GrazieUtilsKt;
import com.intellij.grazie.utils.HighlightingUtil;
import com.intellij.grazie.utils.Text;
import com.intellij.ml.grazie.pro.GrazieProBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.IconUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class WordDefinitions
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(WordDefinitions.class);

    @IntentionName
    @NotNull
    public String getText() {
        String string = GrazieProBundle.msg("action.intention.word.definition.text", new String[0]);
        if (string == null) {
            WordDefinitions.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            WordDefinitions.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            WordDefinitions.$$$reportNull$$$0(2);
        }
        if (CommitMessage.isCommitMessage((PsiElement)psiFile) || !GrazieCloudConnector.Companion.seemsCloudConnected()) {
            return false;
        }
        TextContent content = TextExtractor.findTextAt((PsiFile)psiFile, (int)editor.getCaretModel().getOffset(), (Set)TextContent.TextDomain.ALL);
        if (content == null) {
            return false;
        }
        TextRange range = WordDefinitions.textRangeToQuery(content, HighlightingUtil.selectionRange((Editor)editor));
        if (range == null || range.isEmpty()) {
            return false;
        }
        Language language = GrazieUtilsKt.getLanguageIfAvailable((String)content.toString());
        return language != null && APIQueries.defLanguages.contains(language);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        WordDefinitionWithLanguage descriptor;
        if (project == null) {
            WordDefinitions.$$$reportNull$$$0(3);
        }
        if ((descriptor = WordDefinitions.findDefinitions(editor, psiFile)) == null) {
            return;
        }
        WordDefinitions.showPopup(editor, descriptor);
    }

    public static WordDefinitionWithLanguage findDefinitions(Editor editor, PsiFile file) {
        TextContent content = TextExtractor.findTextAt((PsiFile)file, (int)editor.getCaretModel().getOffset(), (Set)TextContent.TextDomain.ALL);
        if (content == null) {
            return null;
        }
        TextRange textRange = WordDefinitions.textRangeToQuery(content, HighlightingUtil.selectionRange((Editor)editor));
        Language lang = LangDetector.INSTANCE.getLanguage(content.toString());
        if (lang == null || textRange == null || textRange.isEmpty()) {
            return null;
        }
        String rangeText = textRange.subSequence((CharSequence)content).toString();
        int wordsCount = WhitespaceWordTokenizer.INSTANCE.words(rangeText).size();
        GrazieFUSCounter.INSTANCE.reportDefinitionRequested(lang, wordsCount);
        WordDefinition descriptor = (WordDefinition)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> APIQueries.definitions((String)content.toString(), (TextRange)textRange, (Language)lang, (Project)file.getProject()), GrazieProBundle.msg("action.definition.progress.title", rangeText), true, file.getProject());
        if (descriptor == null) {
            Messages.showInfoMessage((Project)file.getProject(), (String)GrazieProBundle.msg("action.definition.not.found.message", rangeText), (String)GrazieProBundle.msg("action.definition.not.found.title", new String[0]));
            return null;
        }
        return new WordDefinitionWithLanguage(descriptor, lang);
    }

    private static void showPopup(Editor editor, final WordDefinitionWithLanguage descriptor) {
        JEditorPane html = SwingHelper.createHtmlViewer((boolean)true, null, null, null);
        FontMetrics metrics = html.getFontMetrics(html.getFont());
        int limit = metrics.stringWidth("w".repeat(30));
        int border = metrics.stringWidth("J");
        WordDefinition definition = descriptor.definition();
        html.setText(WordDefinitions.renderResult(definition));
        html.setBorder((Border)new JBEmptyBorder(border));
        html.setSize(limit + border * 2, limit + border * 2);
        int preferredHeight = html.getPreferredSize().height;
        Icon icon = WordDefinitions.downloadImage(editor, definition, limit);
        boolean iconNorth = icon.getIconWidth() > icon.getIconHeight();
        JPanel component = new JPanel(new BorderLayout());
        component.add((Component)ScrollPaneFactory.createScrollPane((Component)html), "Center");
        component.add((Component)new JLabel(icon), iconNorth ? "North" : "East");
        Dimension componentSize = new Dimension(Math.max(html.getWidth(), limit) + (iconNorth ? 0 : icon.getIconWidth()) + border * 2, preferredHeight + (iconNorth ? icon.getIconHeight() : 0) + border * 2);
        component.setSize(componentSize);
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, null).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).setResizable(true).setMovable(true).setMinSize(componentSize).createPopup();
        popup.addListener(new JBPopupListener(){
            private long shownAt = 0L;

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.shownAt = System.currentTimeMillis();
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                long wasShownFor = System.currentTimeMillis() - this.shownAt;
                GrazieFUSCounter.INSTANCE.reportDefinitionShown(descriptor.language(), descriptor.definition().getDefinitions().length, Duration.ofMillis(wasShownFor));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/ml/grazie/pro/WordDefinitions$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeShown";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        popup.showInBestPositionFor(editor);
    }

    private static Icon downloadImage(Editor editor, WordDefinition descriptor, int limit) {
        if (descriptor.getImage_link() != null && descriptor.getDefinitions().length == 1) {
            try {
                ImageIcon icon = new ImageIcon(ImageIO.read(new URL(descriptor.getImage_link())));
                if (icon.getIconWidth() > limit || icon.getIconHeight() > limit) {
                    int maxDimension = Math.max(icon.getIconWidth(), icon.getIconHeight());
                    return IconUtil.scale((Icon)icon, (Component)editor.getComponent(), (float)((float)limit / (float)maxDimension));
                }
                return icon;
            }
            catch (IOException ex) {
                LOG.info((Throwable)ex);
            }
        }
        return EmptyIcon.create((int)0);
    }

    private static TextRange textRangeToQuery(TextContent content, TextRange range) {
        TextRange textRange = content.fileRangeToText(range);
        return textRange == null ? null : Text.alignToWordBounds((TextRange)textRange, (CharSequence)content);
    }

    private static String renderResult(WordDefinition descriptor) {
        String prefix = "<b>" + descriptor.getWord() + "</b> ";
        if (descriptor.getTranscription() != null) {
            prefix = prefix + "<i>" + descriptor.getTranscription() + "</i> ";
        }
        if (descriptor.getPos() != null) {
            prefix = prefix + "<i>" + descriptor.getPos() + "</i> ";
        }
        if (descriptor.getDefinitions().length == 1) {
            return prefix + "<br><br>" + WordDefinitions.renderDefinition(descriptor.getDefinitions()[0]);
        }
        StringBuilder result = new StringBuilder(prefix + "<ol>");
        for (WordDefinition.Definition definition : descriptor.getDefinitions()) {
            result.append("<li>").append(WordDefinitions.renderDefinition(definition));
        }
        result.append("</ol>");
        return result.toString();
    }

    private static String renderDefinition(WordDefinition.Definition definition) {
        Object result = "";
        if (definition.getTopic() != null) {
            result = (String)result + "<i>" + definition.getTopic() + "</i> ";
        }
        if (definition.getTags() != null) {
            result = (String)result + "<i>" + String.join((CharSequence)", ", definition.getTags()) + "</i> ";
        }
        result = (String)result + definition.getDefinition() + " ";
        if (definition.getContent_link() != null) {
            result = (String)result + "<a href=\"" + definition.getContent_link() + "\">Wikipedia</a>";
        }
        return ((String)result).trim();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ml/grazie/pro/WordDefinitions";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ml/grazie/pro/WordDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    public record WordDefinitionWithLanguage(@NotNull WordDefinition definition, @NotNull Language language) {
        @NotNull
        private final WordDefinition definition;
        @NotNull
        private final Language language;

        public WordDefinitionWithLanguage(@NotNull WordDefinition definition, @NotNull Language language) {
            if (definition == null) {
                WordDefinitionWithLanguage.$$$reportNull$$$0(0);
            }
            if (language == null) {
                WordDefinitionWithLanguage.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public WordDefinition definition() {
            WordDefinition wordDefinition = this.definition;
            if (wordDefinition == null) {
                WordDefinitionWithLanguage.$$$reportNull$$$0(2);
            }
            return wordDefinition;
        }

        @NotNull
        public Language language() {
            Language language = this.language;
            if (language == null) {
                WordDefinitionWithLanguage.$$$reportNull$$$0(3);
            }
            return language;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "definition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ml/grazie/pro/WordDefinitions$WordDefinitionWithLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ml/grazie/pro/WordDefinitions$WordDefinitionWithLanguage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "definition";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "language";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

