/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy;

import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.serialization.PSStringSerializer;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=PSStringSerializer.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0017\u0018\u0000 >2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001>B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0002J\b\u0010\b\u001a\u00020\u0000H\u0016J\u0014\u0010\b\u001a\u00020\u00002\n\u0010\t\u001a\u00020\n\"\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000eJ\u001c\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001J\u001c\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001J\"\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00022\b\b\u0002\u0010\u0013\u001a\u00020\u000e2\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u0000J\u0014\u0010 \u001a\u00020\u00002\n\u0010\t\u001a\u00020\n\"\u00020\u000bH\u0016J\u0014\u0010!\u001a\u00020\u00002\n\u0010\t\u001a\u00020\n\"\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\u0000H\u0016J\b\u0010!\u001a\u00020\u0000H\u0016J\u0013\u0010\"\u001a\u00020\u001d2\b\u0010\u0007\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u000eH\u0016J#\u0010%\u001a\u00020\u00002\u0016\u0010&\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010(0'\"\u0004\u0018\u00010(\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00022\b\b\u0002\u0010,\u001a\u00020\u0002J\u0018\u0010-\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00022\b\b\u0002\u0010,\u001a\u00020\u0002J\u0018\u0010.\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00022\b\b\u0002\u0010,\u001a\u00020\u0002J\u0006\u0010/\u001a\u00020\u0000J\u0006\u00100\u001a\u00020\u0000J\u000e\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u0002J\u0006\u00103\u001a\u00020\u0000J\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0002J\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0002J\u0010\u00108\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0000J\u0018\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u000e2\b\b\u0002\u0010=\u001a\u00020\u000b\u00a8\u0006?"}, d2={"Lcom/intellij/ml/llm/privacy/PSString;", "Lcom/intellij/ml/llm/privacy/PrivacySafe;", "", "contents", "<init>", "(Lcom/intellij/ml/llm/privacy/PrivacySafe;)V", "plus", "other", "trim", "chars", "", "", "take", "n", "", "takeLast", "substring", "range", "Lkotlin/ranges/IntRange;", "startIndex", "endIndex", "replace", "placeHolder", "newValue", "regex", "Lkotlin/text/Regex;", "indexOf", "value", "ignoreCase", "", "isNotBlank", "trimIndent", "trimStart", "trimEnd", "equals", "", "hashCode", "format", "substrings", "", "Lcom/intellij/ml/llm/privacy/PSStringConvertible;", "([Lcom/intellij/ml/llm/privacy/PSStringConvertible;)Lcom/intellij/ml/llm/privacy/PSString;", "substringBefore", "delimiter", "missingDelimiterValue", "substringAfter", "substringAfterLast", "uppercase", "lowercase", "endsWith", "string", "trimMargin", "removePrefix", "prefix", "removeSuffix", "suffix", "repeat", "prependIndent", "indent", "padStart", "length", "padChar", "Companion", "intellij.ml.llm.privacy.shared"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPSString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PSString.kt\ncom/intellij/ml/llm/privacy/PSString\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,206:1\n11561#2:207\n11896#2,3:208\n37#3,2:211\n*S KotlinDebug\n*F\n+ 1 PSString.kt\ncom/intellij/ml/llm/privacy/PSString\n*L\n101#1:207\n101#1:208,3\n102#1:211,2\n*E\n"})
public class PSString
extends PrivacySafe<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public PSString(@NotNull PrivacySafe<String> contents) {
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        super(contents);
    }

    @NotNull
    public final PSString plus(@NotNull PSString other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        PSString[] pSStringArray = new PSString[]{this, other};
        PrivacySafe<String> concatenatedContent = PrivacySafe.Companion.createWith$intellij_ml_llm_privacy_shared(new ConcatenateBuilder(pSStringArray));
        return new PSString(concatenatedContent);
    }

    @NotNull
    public PSString trim() {
        return super.trim().toPSString();
    }

    @NotNull
    public PSString trim(char ... chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return super.trim(Arrays.copyOf(chars, chars.length)).toPSString();
    }

    @NotNull
    public PSString take(int n) {
        return super.take(n).toPSString();
    }

    @NotNull
    public PSString takeLast(int n) {
        return super.takeLast(n).toPSString();
    }

    @NotNull
    public final PSString substring(@NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return ((PSStringBuilder)() -> PSString.substring$lambda$0(this, range)).toPSString();
    }

    @NotNull
    public final PSString substring(int startIndex, int endIndex) {
        return this.substring(new IntRange(startIndex, endIndex - 1));
    }

    @NotNull
    public final PSString substring(int startIndex) {
        return this.substring(startIndex, this.length());
    }

    @NotNull
    public final PSString replace(@NotNull String placeHolder, @NotNull PrivacySafe<String> newValue) {
        Intrinsics.checkNotNullParameter((Object)placeHolder, (String)"placeHolder");
        Intrinsics.checkNotNullParameter(newValue, (String)"newValue");
        return ((PSStringBuilder)() -> PSString.replace$lambda$0(this, placeHolder, newValue)).toPSString();
    }

    @NotNull
    public final PSString replace(@NotNull Regex regex, @NotNull PrivacySafe<String> newValue) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter(newValue, (String)"newValue");
        return ((PSStringBuilder)() -> PSString.replace$lambda$1(this, regex, newValue)).toPSString();
    }

    public final int indexOf(@NotNull String value, int startIndex, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String actualString = (String)this.unwrap();
        return StringsKt.indexOf((CharSequence)actualString, (String)value, (int)startIndex, (boolean)ignoreCase);
    }

    public static /* synthetic */ int indexOf$default(PSString pSString, String string, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOf");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return pSString.indexOf(string, n, bl);
    }

    public final boolean isNotBlank() {
        return !StringsKt.isBlank(this.unwrap());
    }

    @NotNull
    public final PSString trimIndent() {
        return ((PSStringBuilder)() -> PSString.trimIndent$lambda$0(this)).toPSString();
    }

    @NotNull
    public PSString trimStart(char ... chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return super.trimStart(Arrays.copyOf(chars, chars.length)).toPSString();
    }

    @NotNull
    public PSString trimEnd(char ... chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return super.trimEnd(Arrays.copyOf(chars, chars.length)).toPSString();
    }

    @NotNull
    public PSString trimStart() {
        return super.trimStart().toPSString();
    }

    @NotNull
    public PSString trimEnd() {
        return super.trimEnd().toPSString();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof PSString)) {
            return false;
        }
        return Intrinsics.areEqual(((PSString)other).unwrap(), this.unwrap());
    }

    public int hashCode() {
        return ((String)this.unwrap()).hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PSString format(PSStringConvertible ... substrings) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)substrings, (String)"substrings");
        PSStringConvertible[] $this$map$iv = substrings;
        boolean $i$f$map = false;
        PSStringConvertible[] pSStringConvertibleArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            collection.add(v0 != null ? v0.toPSString() : null);
        }
        List psStrings = (List)destination$iv$iv;
        return ((PSStringBuilder)() -> PSString.format$lambda$1(this, psStrings)).toPSString();
    }

    @NotNull
    public final PSString substringBefore(@NotNull String delimiter, @NotNull String missingDelimiterValue) {
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        Intrinsics.checkNotNullParameter((Object)missingDelimiterValue, (String)"missingDelimiterValue");
        return ((PSStringBuilder)() -> PSString.substringBefore$lambda$0(this, delimiter, missingDelimiterValue)).toPSString();
    }

    public static /* synthetic */ PSString substringBefore$default(PSString pSString, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: substringBefore");
        }
        if ((n & 2) != 0) {
            string2 = (String)pSString.unwrap();
        }
        return pSString.substringBefore(string, string2);
    }

    @NotNull
    public final PSString substringAfter(@NotNull String delimiter, @NotNull String missingDelimiterValue) {
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        Intrinsics.checkNotNullParameter((Object)missingDelimiterValue, (String)"missingDelimiterValue");
        return ((PSStringBuilder)() -> PSString.substringAfter$lambda$0(this, delimiter, missingDelimiterValue)).toPSString();
    }

    public static /* synthetic */ PSString substringAfter$default(PSString pSString, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: substringAfter");
        }
        if ((n & 2) != 0) {
            string2 = (String)pSString.unwrap();
        }
        return pSString.substringAfter(string, string2);
    }

    @NotNull
    public final PSString substringAfterLast(@NotNull String delimiter, @NotNull String missingDelimiterValue) {
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        Intrinsics.checkNotNullParameter((Object)missingDelimiterValue, (String)"missingDelimiterValue");
        return ((PSStringBuilder)() -> PSString.substringAfterLast$lambda$0(this, delimiter, missingDelimiterValue)).toPSString();
    }

    public static /* synthetic */ PSString substringAfterLast$default(PSString pSString, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: substringAfterLast");
        }
        if ((n & 2) != 0) {
            string2 = (String)pSString.unwrap();
        }
        return pSString.substringAfterLast(string, string2);
    }

    @NotNull
    public final PSString uppercase() {
        return ((PSStringBuilder)() -> PSString.uppercase$lambda$0(this)).toPSString();
    }

    @NotNull
    public final PSString lowercase() {
        return ((PSStringBuilder)() -> PSString.lowercase$lambda$0(this)).toPSString();
    }

    public final boolean endsWith(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return StringsKt.endsWith$default((String)((String)this.unwrap()), (String)string, (boolean)false, (int)2, null);
    }

    @NotNull
    public final PSString trimMargin() {
        return ((PSStringBuilder)() -> PSString.trimMargin$lambda$0(this)).toPSString();
    }

    @NotNull
    public final PSString removePrefix(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (this.startsWith(prefix)) {
            return this.substring(prefix.length());
        }
        return this;
    }

    @NotNull
    public final PSString removeSuffix(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        if (this.endsWith(suffix)) {
            return this.substring(0, this.length() - suffix.length());
        }
        return this;
    }

    @NotNull
    public PSString repeat(int n) {
        return super.repeat(n).toPSString();
    }

    @NotNull
    public final PSString prependIndent(@NotNull PSString indent) {
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        return ((PSStringBuilder)() -> PSString.prependIndent$lambda$0(this, indent)).toPSString();
    }

    @NotNull
    public final PSString padStart(int length, char padChar) {
        return ((PSStringBuilder)() -> PSString.padStart$lambda$0(this, length, padChar)).toPSString();
    }

    public static /* synthetic */ PSString padStart$default(PSString pSString, int n, char c, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: padStart");
        }
        if ((n2 & 2) != 0) {
            c = (char)32;
        }
        return pSString.padStart(n, c);
    }

    private static final String substring$lambda$0(PSString this$0, IntRange $range) {
        return StringsKt.substring((String)((String)this$0.unwrap()), (IntRange)$range);
    }

    private static final String replace$lambda$0(PSString this$0, String $placeHolder, PrivacySafe $newValue) {
        return StringsKt.replace$default((String)((String)this$0.unwrap()), (String)$placeHolder, (String)((String)$newValue.unwrap()), (boolean)false, (int)4, null);
    }

    private static final String replace$lambda$1(PSString this$0, Regex $regex, PrivacySafe $newValue) {
        Object t = this$0.unwrap();
        String string = (String)$newValue.unwrap();
        return $regex.replace(t, string);
    }

    private static final String trimIndent$lambda$0(PSString this$0) {
        return StringsKt.trimIndent((String)((String)this$0.unwrap()));
    }

    private static final String format$lambda$1(PSString this$0, List $psStrings) {
        String string = (String)this$0.unwrap();
        Collection $this$toTypedArray$iv = $psStrings;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PSString[] pSStringArray = thisCollection$iv.toArray(new PSString[0]);
        pSStringArray = Arrays.copyOf(pSStringArray, pSStringArray.length);
        String string2 = String.format(string, Arrays.copyOf(pSStringArray, pSStringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final String substringBefore$lambda$0(PSString this$0, String $delimiter, String $missingDelimiterValue) {
        return StringsKt.substringBefore((String)((String)this$0.unwrap()), (String)$delimiter, (String)$missingDelimiterValue);
    }

    private static final String substringAfter$lambda$0(PSString this$0, String $delimiter, String $missingDelimiterValue) {
        return StringsKt.substringAfter((String)((String)this$0.unwrap()), (String)$delimiter, (String)$missingDelimiterValue);
    }

    private static final String substringAfterLast$lambda$0(PSString this$0, String $delimiter, String $missingDelimiterValue) {
        return StringsKt.substringAfterLast((String)((String)this$0.unwrap()), (String)$delimiter, (String)$missingDelimiterValue);
    }

    private static final String uppercase$lambda$0(PSString this$0) {
        String string = ((String)this$0.unwrap()).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }

    private static final String lowercase$lambda$0(PSString this$0) {
        String string = ((String)this$0.unwrap()).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    private static final String trimMargin$lambda$0(PSString this$0) {
        return StringsKt.trimMargin$default((String)((String)this$0.unwrap()), null, (int)1, null);
    }

    private static final String prependIndent$lambda$0(PSString this$0, PSString $indent) {
        return StringsKt.prependIndent((String)((String)this$0.unwrap()), (String)((String)$indent.unwrap()));
    }

    private static final String padStart$lambda$0(PSString this$0, int $length, char $padChar) {
        return StringsKt.padStart((String)((String)this$0.unwrap()), (int)$length, (char)$padChar);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/privacy/PSString$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/privacy/PSString;", "intellij.ml.llm.privacy.shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<PSString> serializer() {
            return PSStringSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

