/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions;

import com.intellij.ml.llm.core.chat.ui.chat.HtmlMdTransferable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import java.awt.datatransfer.Transferable;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ>\u0010\f\u001a\u00020\r26\u0010\u000e\u001a2\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00050\u000f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/AIAssistantChatActionsUtil;", "", "<init>", "()V", "updateSelectionDependentAction", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getTextToPaste", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "createHtmlMarkdownTransferable", "Ljava/awt/datatransfer/Transferable;", "action", "Lkotlin/Function2;", "Ljava/io/StringWriter;", "Lkotlin/ParameterName;", "name", "md", "html", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantChatActionsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantChatActionsUtil.kt\ncom/intellij/ml/llm/core/chat/actions/AIAssistantChatActionsUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class AIAssistantChatActionsUtil {
    @NotNull
    public static final AIAssistantChatActionsUtil INSTANCE = new AIAssistantChatActionsUtil();

    private AIAssistantChatActionsUtil() {
    }

    public final void updateSelectionDependentAction(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        Editor selectedTextEditor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (selectedTextEditor == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        if (!selectedTextEditor.getDocument().isWritable()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    @NotNull
    public final String getTextToPaste(@NotNull Editor editor) {
        SelectionModel selectionModel;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        SelectionModel it = selectionModel = editor.getSelectionModel();
        boolean bl = false;
        Object object = it.hasSelection() ? selectionModel : null;
        if (object == null || (object = object.getSelectedText()) == null) {
            String string = editor.getDocument().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            object = ((Object)StringsKt.trim((CharSequence)string)).toString();
        }
        return object;
    }

    @NotNull
    public final Transferable createHtmlMarkdownTransferable(@NotNull Function2<? super StringWriter, ? super StringWriter, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        StringWriter md = new StringWriter();
        StringWriter html = new StringWriter();
        html.append("<html><body>");
        action2.invoke((Object)md, (Object)html);
        html.append("</body></html>");
        String string = md.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = html.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return new HtmlMdTransferable(string, string2);
    }
}

