/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions;

import com.intellij.codeInsight.editorActions.TypingActionsExtension;
import com.intellij.lang.LanguageFormatting;
import com.intellij.ml.llm.core.chat.actions.AIAssistantLangPostInsertHandler;
import com.intellij.ml.llm.core.chat.actions.codeSnippet.formatter.AIMessageOnPasteFormattingOptionProvider;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorCopyPasteHelperImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ.\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u0004\u0018\u00010\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/AIAssistantEditorUtil;", "", "<init>", "()V", "insertAtCaret", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textToPaste", "", "insertAtOffset", "offset", "", "insertWithAction", "anchorColumn", "insertAction", "Lcom/intellij/openapi/util/Computable;", "Lcom/intellij/openapi/util/TextRange;", "getLangExtension", "Lcom/intellij/ml/llm/core/chat/actions/AIAssistantLangPostInsertHandler;", "Lcom/intellij/psi/PsiFile;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantEditorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantEditorUtil.kt\ncom/intellij/ml/llm/core/chat/actions/AIAssistantEditorUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class AIAssistantEditorUtil {
    @NotNull
    public static final AIAssistantEditorUtil INSTANCE = new AIAssistantEditorUtil();

    private AIAssistantEditorUtil() {
    }

    public final void insertAtCaret(@NotNull Project project, @NotNull Editor editor, @NotNull String textToPaste) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textToPaste, (String)"textToPaste");
        this.insertWithAction(project, editor, editor.getCaretModel().getLogicalPosition().column, (Computable<TextRange>)((Computable)() -> AIAssistantEditorUtil.insertAtCaret$lambda$0(editor, textToPaste)));
    }

    public final void insertAtOffset(@NotNull Project project, @NotNull Editor editor, @NotNull String textToPaste, int offset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textToPaste, (String)"textToPaste");
        int column = editor.offsetToLogicalPosition((int)offset).column;
        this.insertWithAction(project, editor, column, (Computable<TextRange>)((Computable)() -> AIAssistantEditorUtil.insertAtOffset$lambda$0(editor, offset, textToPaste)));
    }

    private final void insertWithAction(Project project, Editor editor, int anchorColumn, Computable<TextRange> insertAction) {
        String insertWithActionGroupId = "insertWithActionGroup" + UUID.randomUUID();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        TextRange pastedRange = (TextRange)WriteCommandAction.writeCommandAction((Project)project).withGroupId(insertWithActionGroupId).compute(() -> AIAssistantEditorUtil.insertWithAction$lambda$0(insertAction));
        AIAssistantLangPostInsertHandler langExtensionPostInsertHandler = this.getLangExtension(psiFile);
        if (langExtensionPostInsertHandler == null) {
            AIAssistantEditorUtil.insertWithAction$formatWithExtensions(psiFile, project, editor, insertWithActionGroupId, pastedRange, anchorColumn);
        } else {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Intrinsics.checkNotNull((Object)pastedRange);
            langExtensionPostInsertHandler.handle(project, document, pastedRange);
        }
    }

    private final AIAssistantLangPostInsertHandler getLangExtension(PsiFile $this$getLangExtension) {
        AIAssistantLangPostInsertHandler aIAssistantLangPostInsertHandler;
        PsiFile psiFile = $this$getLangExtension;
        if (psiFile != null) {
            PsiFile it = psiFile;
            boolean bl = false;
            aIAssistantLangPostInsertHandler = (AIAssistantLangPostInsertHandler)AIAssistantLangPostInsertHandler.Companion.getEP_NAME().forLanguage(it.getLanguage());
        } else {
            aIAssistantLangPostInsertHandler = null;
        }
        return aIAssistantLangPostInsertHandler;
    }

    private static final TextRange insertAtCaret$lambda$0(Editor $editor, String $textToPaste) {
        return EditorCopyPasteHelperImpl.insertStringAtCaret((Editor)$editor, (String)$textToPaste);
    }

    private static final TextRange insertAtOffset$lambda$0(Editor $editor, int $offset, String $textToPaste) {
        $editor.getDocument().insertString($offset, (CharSequence)$textToPaste);
        return new TextRange($offset, $offset + $textToPaste.length());
    }

    private static final TextRange insertWithAction$lambda$0(Computable $insertAction) {
        return (TextRange)ApplicationKt.getApplication().runWriteAction($insertAction);
    }

    private static final void insertWithAction$formatWithExtensions(PsiFile psiFile, Project $project, Editor $editor, String insertWithActionGroupId, TextRange pastedRange, int $anchorColumn) {
        Integer languageSpecificIndentOption;
        Integer n = languageSpecificIndentOption = AIMessageOnPasteFormattingOptionProvider.Companion.getIndentOption((PsiElement)psiFile);
        int indentOptions = n != null ? n : (psiFile == null || LanguageFormatting.INSTANCE.forContext((PsiElement)psiFile) == null ? 2 : 3);
        TypingActionsExtension typingActionsExtension = TypingActionsExtension.findForContext((Project)$project, (Editor)$editor);
        Intrinsics.checkNotNullExpressionValue((Object)typingActionsExtension, (String)"findForContext(...)");
        TypingActionsExtension extensions = typingActionsExtension;
        WriteCommandAction.writeCommandAction((Project)$project).withGroupId(insertWithActionGroupId).run(() -> AIAssistantEditorUtil.insertWithAction$formatWithExtensions$lambda$1(extensions, $project, $editor, indentOptions, pastedRange, $anchorColumn));
    }

    private static final void insertWithAction$formatWithExtensions$lambda$1(TypingActionsExtension $extensions, Project $project, Editor $editor, int $indentOptions, TextRange $pastedRange, int $anchorColumn) {
        ApplicationKt.getApplication().runWriteAction(() -> AIAssistantEditorUtil.insertWithAction$formatWithExtensions$lambda$1$0($extensions, $project, $editor, $indentOptions, $pastedRange, $anchorColumn));
    }

    private static final void insertWithAction$formatWithExtensions$lambda$1$0(TypingActionsExtension $extensions, Project $project, Editor $editor, int $indentOptions, TextRange $pastedRange, int $anchorColumn) {
        $extensions.format($project, $editor, $indentOptions, $pastedRange.getStartOffset(), $pastedRange.getEndOffset(), $anchorColumn, true, false);
    }
}

