/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.Language;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.FocusedChatSessionListener;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/ChatRenderedDumpLog;", "", "<init>", "()V", "SCRATCH_FILE_NAME", "", "appendMessage", "", "project", "Lcom/intellij/openapi/project/Project;", "content", "openInEditor", "getDocument", "Lcom/intellij/openapi/editor/Document;", "executeInWriteAction", "action", "Lkotlin/Function0;", "getScratchFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "SessionListener", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nChatRenderedDumpLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatRenderedDumpLog.kt\ncom/intellij/ml/llm/core/chat/actions/ChatRenderedDumpLog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class ChatRenderedDumpLog {
    @NotNull
    public static final ChatRenderedDumpLog INSTANCE = new ChatRenderedDumpLog();
    @NotNull
    private static final String SCRATCH_FILE_NAME = "RenderedMessages";

    private ChatRenderedDumpLog() {
    }

    public final void appendMessage(@NotNull Project project, @NotNull String content2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            if (!Registry.Companion.is("llm.chat.rendered.message.logging.enabled")) {
                return;
            }
            if (StringsKt.isBlank((CharSequence)content2)) {
                return;
            }
            Document document = this.getDocument(project);
            if (document == null) break block2;
            Document doc = document;
            boolean bl = false;
            INSTANCE.executeInWriteAction(project, (Function0<Unit>)((Function0)() -> ChatRenderedDumpLog.appendMessage$lambda$0$0(doc, content2)));
        }
    }

    public final void openInEditor(@NotNull Project project) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!Registry.Companion.is("llm.chat.rendered.message.logging.enabled")) {
                return;
            }
            VirtualFile virtualFile2 = this.getScratchFile(project);
            if (virtualFile2 == null) break block1;
            VirtualFile file = virtualFile2;
            boolean bl = false;
            FileEditorManager.getInstance((Project)project).openFile(file, true);
        }
    }

    private final Document getDocument(Project project) {
        VirtualFile virtualFile2 = this.getScratchFile(project);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file = virtualFile2;
        return FileDocumentManager.getInstance().getDocument(file);
    }

    private final void executeInWriteAction(Project project, Function0<Unit> action2) {
        WriteCommandAction.writeCommandAction((Project)project).withName("").run(() -> ChatRenderedDumpLog.executeInWriteAction$lambda$0(action2));
    }

    private final VirtualFile getScratchFile(Project project) {
        VirtualFile virtualFile2 = ScratchRootType.getInstance().findFile(project, SCRATCH_FILE_NAME, ScratchFileService.Option.existing_only);
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            return it;
        }
        return ScratchRootType.getInstance().createScratchFile(project, SCRATCH_FILE_NAME, (Language)PlainTextLanguage.INSTANCE, "", ScratchFileService.Option.create_if_missing);
    }

    private static final Unit appendMessage$lambda$0$0(Document $doc, String $content) {
        $doc.insertString($doc.getTextLength(), (CharSequence)($content + "\n\n-----------------\n\n"));
        FileDocumentManager.getInstance().saveDocument($doc);
        return Unit.INSTANCE;
    }

    private static final void executeInWriteAction$lambda$0(Function0 $action) {
        $action.invoke();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/ChatRenderedDumpLog$SessionListener;", "Lcom/intellij/ml/llm/core/chat/session/FocusedChatSessionListener;", "<init>", "()V", "onFocusChanged", "", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "intellij.ml.llm.chat"})
    public static final class SessionListener
    implements FocusedChatSessionListener {
        @Override
        public void onFocusChanged(@NotNull ChatSession chatSession2) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)chatSession2, (String)"chatSession");
                if (!Registry.Companion.is("llm.chat.rendered.message.logging.enabled")) {
                    return;
                }
                VirtualFile virtualFile2 = INSTANCE.getScratchFile(chatSession2.getProject());
                if (virtualFile2 == null) break block1;
                VirtualFile file = virtualFile2;
                boolean bl = false;
                INSTANCE.executeInWriteAction(chatSession2.getProject(), (Function0<Unit>)() -> SessionListener.onFocusChanged$lambda$0$0(file, this));
            }
        }

        private static final Unit onFocusChanged$lambda$0$0(VirtualFile $file, SessionListener this$0) {
            $file.delete((Object)this$0);
            return Unit.INSTANCE;
        }
    }
}

