/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions.message;

import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.messages.ChatMessageRating;
import com.intellij.ml.llm.core.chat.messages.CompletedState;
import com.intellij.ml.llm.core.chat.messages.ErrorState;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H&J\b\u0010\u0014\u001a\u00020\u0015H&J\b\u0010\u0016\u001a\u00020\u0015H&R\u001f\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0002\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/message/AIAssistantRateMessageAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "message", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessage;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getMessage", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/ml/llm/core/chat/messages/ChatMessage;", "update", "", "e", "isReactionSelected", "", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getReaction", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;", "getReactionIcon", "Ljavax/swing/Icon;", "getReactionIconSelected", "Like", "Dislike", "Lcom/intellij/ml/llm/core/chat/actions/message/AIAssistantRateMessageAction$Dislike;", "Lcom/intellij/ml/llm/core/chat/actions/message/AIAssistantRateMessageAction$Like;", "intellij.ml.llm.chat"})
public abstract sealed class AIAssistantRateMessageAction
extends DumbAwareAction {
    private AIAssistantRateMessageAction() {
    }

    private final ChatMessage getMessage(AnActionEvent $this$message) {
        return (ChatMessage)$this$message.getDataContext().getData(ChatMessage.Companion.getKey());
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Icon icon = !this.isReactionSelected(e) ? this.getReactionIcon() : this.getReactionIconSelected();
        e.getPresentation().setIcon(icon);
        ChatMessage message = this.getMessage(e);
        ChatMessage chatMessage = message;
        e.getPresentation().setEnabledAndVisible((chatMessage != null ? chatMessage.getState() : null) instanceof CompletedState && !(message.getState() instanceof ErrorState));
    }

    private final boolean isReactionSelected(AnActionEvent e) {
        ChatMessage chatMessage = this.getMessage(e);
        return (chatMessage != null ? chatMessage.getRating() : null) == this.getReaction();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ChatMessage chatMessage = this.getMessage(e);
        if (chatMessage == null) {
            return;
        }
        ChatMessage message = chatMessage;
        ChatMessage chatMessage2 = (ChatMessage)e.getDataContext().getData(ChatMessage.Companion.getKey());
        ChatSession session = (ChatSession)e.getDataContext().getData(ChatSession.Companion.getCurrentSession());
        message.setRating(this.isReactionSelected(e) ? ChatMessageRating.None : this.getReaction());
        message.getChat().setTimestamp(System.currentTimeMillis());
        AIAssistantChatEventLogger.logMessageReacted(e.getProject(), session, chatMessage2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NotNull
    public abstract ChatMessageRating getReaction();

    @NotNull
    public abstract Icon getReactionIcon();

    @NotNull
    public abstract Icon getReactionIconSelected();

    public /* synthetic */ AIAssistantRateMessageAction(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\r\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/message/AIAssistantRateMessageAction$Dislike;", "Lcom/intellij/ml/llm/core/chat/actions/message/AIAssistantRateMessageAction;", "<init>", "()V", "getReaction", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;", "getReactionIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getReactionIconSelected", "intellij.ml.llm.chat"})
    public static final class Dislike
    extends AIAssistantRateMessageAction {
        public Dislike() {
            super(null);
        }

        @Override
        @NotNull
        public ChatMessageRating getReaction() {
            return ChatMessageRating.Dislike;
        }

        @Override
        @NotNull
        public Icon getReactionIcon() {
            Icon icon = MLLlmIcons.Dislike;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Dislike");
            return icon;
        }

        @Override
        @NotNull
        public Icon getReactionIconSelected() {
            Icon icon = MLLlmIcons.DislikeSelected;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"DislikeSelected");
            return icon;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\r\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/message/AIAssistantRateMessageAction$Like;", "Lcom/intellij/ml/llm/core/chat/actions/message/AIAssistantRateMessageAction;", "<init>", "()V", "getReaction", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;", "getReactionIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getReactionIconSelected", "intellij.ml.llm.chat"})
    public static final class Like
    extends AIAssistantRateMessageAction {
        public Like() {
            super(null);
        }

        @Override
        @NotNull
        public ChatMessageRating getReaction() {
            return ChatMessageRating.Like;
        }

        @Override
        @NotNull
        public Icon getReactionIcon() {
            Icon icon = MLLlmIcons.Like;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Like");
            return icon;
        }

        @Override
        @NotNull
        public Icon getReactionIconSelected() {
            Icon icon = MLLlmIcons.LikeSelected;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LikeSelected");
            return icon;
        }
    }
}

