/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.retrievers;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.context.ContextEntity;
import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.context.project.BuildSystemProjectDependencies;
import com.intellij.ml.llm.core.chat.context.retrievers.BuildSystemDependenciesWrapper;
import com.intellij.ml.llm.core.chat.context.retrievers.ProjectDependenciesChatAttachment;
import com.intellij.ml.llm.core.chat.context.retrievers.ProjectDependenciesRetriever;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010,\u001a\u00020-H\u0096@\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u0012\u0012\u000e\u0012\f0\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00150\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\rR\u0014\u0010\u001d\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\rR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0019\u0010'\u001a\u00070(\u00a2\u0006\u0002\b)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00065"}, d2={"Lcom/intellij/ml/llm/core/chat/context/retrievers/ProjectDependenciesContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "Lcom/intellij/ml/llm/context/ContextEntity;", "project", "Lcom/intellij/openapi/project/Project;", "buildSystemDependencies", "", "Lcom/intellij/ml/llm/core/chat/context/project/BuildSystemProjectDependencies;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "id", "", "getId", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "getIcon", "hint", "", "getHint", "()Ljava/lang/Void;", "tooltipText", "getTooltipText", "popupPresentationText", "getPopupPresentationText", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "Lcom/intellij/openapi/util/NlsSafe;", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "toString", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nProjectDependenciesContextRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectDependenciesContextRetriever.kt\ncom/intellij/ml/llm/core/chat/context/retrievers/ProjectDependenciesContextAttachment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1869#2,2:132\n1#3:134\n*S KotlinDebug\n*F\n+ 1 ProjectDependenciesContextRetriever.kt\ncom/intellij/ml/llm/core/chat/context/retrievers/ProjectDependenciesContextAttachment\n*L\n74#1:132,2\n*E\n"})
final class ProjectDependenciesContextAttachment
extends ContextAttachmentBase
implements ContextEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<BuildSystemProjectDependencies> buildSystemDependencies;
    @NotNull
    private final String id;
    @NotNull
    private final AtomicProperty<String> name;
    @NotNull
    private final AtomicProperty<Icon> icon;
    @Nullable
    private final Void hint;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final ContextEntityPrivacy privacy;
    @NotNull
    private final ContextEntitySource attachedBy;
    @NotNull
    private static final PSString ATTACHMENT_NAME = ConstantsKt.getPrivacyConst((String)"Project Dependencies");
    @NotNull
    private static final String SOURCE_ID = "PROJECT_DEPENDENCIES";

    public ProjectDependenciesContextAttachment(@NotNull Project project, @NotNull List<BuildSystemProjectDependencies> buildSystemDependencies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(buildSystemDependencies, (String)"buildSystemDependencies");
        this.project = project;
        this.buildSystemDependencies = buildSystemDependencies;
        this.id = SOURCE_ID;
        this.name = new AtomicProperty((Object)ATTACHMENT_NAME.unwrap());
        this.icon = new AtomicProperty((Object)AllIcons.Graph.Layout);
        this.tooltipText = SOURCE_ID;
        this.popupPresentationText = "";
        this.privacy = (ContextEntityPrivacy)ContextEntityPrivacy.Unrelated.INSTANCE;
        this.attachedBy = ProjectDependenciesRetriever.INSTANCE;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public AtomicProperty<String> getName() {
        return this.name;
    }

    @NotNull
    public AtomicProperty<Icon> getIcon() {
        return this.icon;
    }

    @Nullable
    public Void getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return this.privacy;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @Override
    @NotNull
    public PSString getText() {
        PSString formattedDependenciesReport = PSStringKt.buildStringPrivacySafe(arg_0 -> ProjectDependenciesContextAttachment._get_text_$lambda$0(this, arg_0));
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{formattedDependenciesReport};
        return ConstantsKt.getPrivacyConst((String)"\n        |List of project dependencies split by the build systems:\n        |%s\n      ").trimMargin().format(pSStringConvertibleArray);
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new ProjectDependenciesChatAttachment(this.project, this.buildSystemDependencies, this.getText());
    }

    @Override
    public void performAction(boolean isInMessage) {
        VirtualFile file;
        String fileName = this.getId() + ".txt";
        VirtualFile virtualFile2 = ProjectDependenciesContextAttachment.performAction$getOpenedLocalChangesFile(this, fileName);
        if (virtualFile2 == null) {
            virtualFile2 = (VirtualFile)new LightVirtualFile(fileName, (CharSequence)this.getText());
        }
        if ((file = virtualFile2).isValid()) {
            FileEditorManager.getInstance((Project)this.project).openFile(file, true);
        }
    }

    @NotNull
    public String toString() {
        return (String)ATTACHMENT_NAME.unwrap();
    }

    private static final Unit _get_text_$lambda$0(ProjectDependenciesContextAttachment this$0, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        Iterable $this$forEach$iv = this$0.buildSystemDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PSStringConvertible[] pSStringConvertibleArray;
            BuildSystemProjectDependencies dependency = (BuildSystemProjectDependencies)element$iv;
            boolean bl = false;
            BuildSystemDependenciesWrapper dependencyWrapper = new BuildSystemDependenciesWrapper(dependency.getBuildSystem(), dependency.getDependencies());
            if (!StringsKt.isBlank((CharSequence)dependency.getBuildSystem())) {
                pSStringConvertibleArray = new PSStringConvertible[]{dependencyWrapper.getSafeBuildSystem()};
                $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"%s dependencies:\n").format(pSStringConvertibleArray));
            }
            $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"```\n"));
            pSStringConvertibleArray = new PSStringConvertible[]{dependencyWrapper.getSafeDependenciesList()};
            $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"%s\n").format(pSStringConvertibleArray));
            $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"```\n"));
        }
        return Unit.INSTANCE;
    }

    private static final VirtualFile performAction$getOpenedLocalChangesFile(ProjectDependenciesContextAttachment this$0, String fileName) {
        Object object;
        block1: {
            VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this$0.project).getOpenFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
            for (Object object2 : (Object[])virtualFileArray) {
                VirtualFile it = (VirtualFile)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (VirtualFile)object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/core/chat/context/retrievers/ProjectDependenciesContextAttachment$Companion;", "", "<init>", "()V", "ATTACHMENT_NAME", "Lcom/intellij/ml/llm/privacy/PSString;", "getATTACHMENT_NAME", "()Lcom/intellij/ml/llm/privacy/PSString;", "SOURCE_ID", "", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PSString getATTACHMENT_NAME() {
            return ATTACHMENT_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

