/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.uiPicker.problems;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.ml.llm.editor.common.progress.AICaretAttributeKeys;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.DocumentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bJ \u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u001e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/core/chat/context/uiPicker/problems/ProblemsAttachmentUtil;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "ATTACHMENT_NAME", "Lcom/intellij/ml/llm/privacy/PSString;", "getATTACHMENT_NAME", "()Lcom/intellij/ml/llm/privacy/PSString;", "supportedProblemSeverityTypes", "", "Lcom/intellij/lang/annotation/HighlightSeverity;", "kotlin.jvm.PlatformType", "getFileProblems", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "getProblemsSummary", "problems", "getProblemLines", "document", "Lcom/intellij/openapi/editor/Document;", "problem", "getLineRangeForOffsets", "Lcom/intellij/openapi/util/TextRange;", "startOffset", "", "endOffset", "getProblemDescription", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nProblemsAttachmentUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProblemsAttachmentUtil.kt\ncom/intellij/ml/llm/core/chat/context/uiPicker/problems/ProblemsAttachmentUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n11879#2,9:72\n13805#2:81\n13806#2:83\n11888#2:84\n1#3:82\n774#4:85\n865#4,2:86\n13#5:88\n*S KotlinDebug\n*F\n+ 1 ProblemsAttachmentUtil.kt\ncom/intellij/ml/llm/core/chat/context/uiPicker/problems/ProblemsAttachmentUtil\n*L\n31#1:72,9\n31#1:81\n31#1:83\n31#1:84\n31#1:82\n32#1:85\n32#1:86,2\n20#1:88\n*E\n"})
public final class ProblemsAttachmentUtil {
    @NotNull
    public static final ProblemsAttachmentUtil INSTANCE = new ProblemsAttachmentUtil();
    @NotNull
    private static final Logger log;
    @NotNull
    private static final PSString ATTACHMENT_NAME;
    @NotNull
    private static final List<HighlightSeverity> supportedProblemSeverityTypes;

    private ProblemsAttachmentUtil() {
    }

    @NotNull
    public final PSString getATTACHMENT_NAME() {
        return ATTACHMENT_NAME;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<HighlightInfo> getFileProblems(@NotNull PsiFile file, @NotNull Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        RangeHighlighter[] highlighters;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (ImageFileTypeManager.getInstance().isImage(file.getVirtualFile()) || file.getVirtualFile().getFileType().isBinary()) {
            return CollectionsKt.emptyList();
        }
        RangeHighlighter[] rangeHighlighterArray = DocumentMarkupModel.forDocument((Document)file.getFileDocument(), (Project)project, (boolean)false).getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        RangeHighlighter[] rangeHighlighterArray2 = highlighters = rangeHighlighterArray;
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            HighlightInfo it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            Object object = it.getErrorStripeTooltip();
            if ((object instanceof HighlightInfo ? (HighlightInfo)object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CharSequence charSequence;
            HighlightInfo it = (HighlightInfo)element$iv$iv;
            boolean bl = false;
            if (!(supportedProblemSeverityTypes.contains(it.getSeverity()) && !Intrinsics.areEqual((Object)it.forcedTextAttributesKey, (Object)AICaretAttributeKeys.INLINE_PROMPT_ATTRS) && !((charSequence = (CharSequence)it.getDescription()) == null || StringsKt.isBlank((CharSequence)charSequence)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final PSString getProblemsSummary(@NotNull PsiFile file, @NotNull List<? extends HighlightInfo> problems) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        PSString pSString = ConstantsKt.getPrivacyConst((String)"%s file contains the following detected problems:\n%s\n");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[2];
        PSString pSString2 = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)((PsiNamedElement)file)).getName();
        if (pSString2 == null) {
            pSString2 = ConstantsKt.getPrivacyConst((String)"****");
        }
        pSStringConvertibleArray[0] = pSString2;
        pSStringConvertibleArray[1] = PSStringKt.joinToString$default((Iterable)problems, (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"----------\n")), null, null, (int)0, null, arg_0 -> ProblemsAttachmentUtil.getProblemsSummary$lambda$0(file, arg_0), (int)30, null);
        return pSString.format(pSStringConvertibleArray);
    }

    private final PSString getProblemLines(Project project, Document document, HighlightInfo problem) {
        TextRange textRange = this.getLineRangeForOffsets(document, problem.startOffset, problem.endOffset);
        if (textRange == null) {
            return ConstantsKt.getPrivacyConst((String)"");
        }
        TextRange lineRange = textRange;
        return ExtensionsKtKt.privacySafe((Document)document, (Project)project).getText().substring(lineRange.getStartOffset(), lineRange.getEndOffset());
    }

    private final TextRange getLineRangeForOffsets(Document document, int startOffset, int endOffset) {
        int lineEnd;
        if (!DocumentUtil.isValidOffset((int)startOffset, (Document)document) || !DocumentUtil.isValidOffset((int)endOffset, (Document)document) || startOffset > endOffset) {
            log.warn("Invalid offsets provided: " + startOffset + "-" + endOffset + " for document length: " + document.getTextLength());
            return null;
        }
        int lineStart = document.getLineStartOffset(document.getLineNumber(startOffset));
        return lineStart <= (lineEnd = document.getLineEndOffset(document.getLineNumber(endOffset))) ? new TextRange(lineStart, lineEnd) : null;
    }

    @NotNull
    public final PSString getProblemDescription(@NotNull Project project, @NotNull Document document, @NotNull HighlightInfo problem) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{SharedExtensionsKtKt.getPrivacySafe((HighlightInfo)problem).getDescription(), SharedExtensionsKtKt.getPrivacySafe((HighlightInfo)problem).getText(), this.getProblemLines(project, document, problem)};
        return ConstantsKt.getPrivacyConst((String)"\n%s\nat: %s\non the lines:\n%s\n").format(pSStringConvertibleArray);
    }

    private static final PrivacySafe getProblemsSummary$lambda$0(PsiFile $file, HighlightInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Project project = $file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Document document = $file.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        return (PrivacySafe)INSTANCE.getProblemDescription(project, document, it);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProblemsAttachmentUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
        ATTACHMENT_NAME = ConstantsKt.getPrivacyConst((String)"Problems");
        supportedProblemSeverityTypes = CollectionsKt.listOf((Object)HighlightSeverity.ERROR);
    }
}

