/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.parts.latex;

import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00062\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\rJ\u0010\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r*\u00020\u0006J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\rJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J4\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\rH\u0002J\f\u0010\u001d\u001a\u00020\u0006*\u00020\u0006H\u0002J\u001c\u0010\u001e\u001a\u00020\u0019*\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\b\b\u0002\u0010 \u001a\u00020\u0019R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/core/chat/parts/latex/LatexDetectionUtils;", "", "<init>", "()V", "SPECIAL_SYMBOLS", "", "", "[Ljava/lang/String;", "MATHEMATICAL_EXPRESSIONS", "COMMON_COMMANDS", "SIMPLE_LATEX_REGEX", "Lkotlin/text/Regex;", "heuristicDetectLatexInText", "", "Lcom/intellij/ml/llm/core/chat/parts/latex/LatexDetectionUtils$LatexDetectionResult;", "text", "previousDetected", "Lcom/intellij/ml/llm/core/chat/parts/latex/LatexDetectionUtils$LatexDetectionResult$Latex;", "findCorrectBracketSequences", "Lkotlin/ranges/IntRange;", "findSimpleLatexSequences", "mergeNeighboringLatexSequences", "splitLatexBySimpleText", "getCorrectBracketSequences", "isCorrectLatexExpression", "", "range", "pastAcceptedLatex", "previousRanges", "trimFromSpacesBrackets", "inside", "other", "strictly", "LatexDetectionResult", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nLatexDetectionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatexDetectionUtils.kt\ncom/intellij/ml/llm/core/chat/parts/latex/LatexDetectionUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,292:1\n1878#2,2:293\n808#2,11:295\n1880#2:306\n808#2,11:307\n1869#2:318\n1870#2:330\n1056#2:334\n1761#2,3:358\n1761#2,3:361\n648#3,5:319\n621#3,6:324\n1188#3,3:331\n1104#3,3:364\n106#4:335\n78#4,22:336\n106#4:371\n78#4,22:372\n13805#5,2:367\n13805#5,2:369\n*S KotlinDebug\n*F\n+ 1 LatexDetectionUtils.kt\ncom/intellij/ml/llm/core/chat/parts/latex/LatexDetectionUtils\n*L\n78#1:293,2\n83#1:295,11\n78#1:306\n99#1:307,11\n160#1:318\n160#1:330\n225#1:334\n243#1:358,3\n246#1:361,3\n167#1:319,5\n168#1:324,6\n212#1:331,3\n262#1:364,3\n229#1:335\n229#1:336,22\n278#1:371\n278#1:372,22\n266#1:367,2\n270#1:369,2\n*E\n"})
public final class LatexDetectionUtils {
    @NotNull
    public static final LatexDetectionUtils INSTANCE = new LatexDetectionUtils();
    @NotNull
    private static final String[] SPECIAL_SYMBOLS;
    @NotNull
    private static final String[] MATHEMATICAL_EXPRESSIONS;
    @NotNull
    private static final String[] COMMON_COMMANDS;
    @NotNull
    private static final Regex SIMPLE_LATEX_REGEX;

    private LatexDetectionUtils() {
    }

    @NotNull
    public final List<LatexDetectionResult> heuristicDetectLatexInText(@NotNull String text2, @NotNull List<LatexDetectionResult.Latex> previousDetected) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(previousDetected, (String)"previousDetected");
        return this.splitLatexBySimpleText(this.mergeNeighboringLatexSequences(this.findSimpleLatexSequences(this.findCorrectBracketSequences(text2), text2, previousDetected)));
    }

    public static /* synthetic */ List heuristicDetectLatexInText$default(LatexDetectionUtils latexDetectionUtils, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return latexDetectionUtils.heuristicDetectLatexInText(string, list);
    }

    @NotNull
    public final List<IntRange> findCorrectBracketSequences(@NotNull String $this$findCorrectBracketSequences) {
        Intrinsics.checkNotNullParameter((Object)$this$findCorrectBracketSequences, (String)"<this>");
        return this.getCorrectBracketSequences($this$findCorrectBracketSequences);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LatexDetectionResult> findSimpleLatexSequences(@NotNull List<IntRange> $this$findSimpleLatexSequences, @NotNull String text2, @NotNull List<LatexDetectionResult.Latex> previousDetected) {
        Intrinsics.checkNotNullParameter($this$findSimpleLatexSequences, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(previousDetected, (String)"previousDetected");
        int iteration = 0;
        List previousLatexRanges = new ArrayList();
        List previousLatexSequences = new ArrayList();
        List latexRanges = new ArrayList();
        List latexSequences = new ArrayList();
        while (iteration == 0 || previousLatexSequences.size() != latexSequences.size()) {
            int currentPosition = 0;
            ++iteration;
            previousLatexSequences.clear();
            previousLatexSequences.addAll(latexSequences);
            latexSequences.clear();
            previousLatexRanges.clear();
            previousLatexRanges.addAll(latexRanges);
            latexRanges.clear();
            Iterable $this$forEachIndexed$iv = $this$findSimpleLatexSequences;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstance$iv;
                void sequence;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IntRange intRange = (IntRange)item$iv;
                int index = n;
                boolean bl = false;
                if (sequence.getFirst() < currentPosition) continue;
                Iterable iterable = previousLatexSequences;
                Collection collection = previousDetected;
                String string = StringsKt.substring((String)text2, (IntRange)sequence);
                void var22_24 = sequence;
                LatexDetectionUtils latexDetectionUtils = INSTANCE;
                boolean $i$f$filterIsInstance = false;
                void var25_27 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LatexDetectionResult.Latex)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                if (!latexDetectionUtils.isCorrectLatexExpression((IntRange)var22_24, string, CollectionsKt.plus((Collection)collection, (Iterable)list), previousLatexRanges)) continue;
                if (sequence.getFirst() > currentPosition) {
                    String string2 = text2.substring(currentPosition, sequence.getFirst());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    latexSequences.add(new LatexDetectionResult.SimpleText(string2));
                }
                latexSequences.add(new LatexDetectionResult.Latex(StringsKt.substring((String)text2, (IntRange)sequence)));
                latexRanges.add(sequence);
                currentPosition = sequence.getLast() + 1;
            }
            if (currentPosition != text2.length()) {
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstance$iv;
                String leftSuffix;
                Intrinsics.checkNotNullExpressionValue((Object)text2.substring(currentPosition, text2.length()), (String)"substring(...)");
                Iterable $i$f$forEachIndexed2 = previousLatexSequences;
                Collection collection = previousDetected;
                String string = leftSuffix;
                IntRange intRange = new IntRange(currentPosition, text2.length() - 1);
                LatexDetectionUtils latexDetectionUtils = this;
                boolean $i$f$filterIsInstance = false;
                Iterator iterator = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LatexDetectionResult.Latex)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                if (latexDetectionUtils.isCorrectLatexExpression(intRange, string, CollectionsKt.plus((Collection)collection, (Iterable)list), previousLatexRanges)) {
                    latexRanges.add(new IntRange(currentPosition, text2.length() - 1));
                    v1 = latexSequences.add(new LatexDetectionResult.Latex(leftSuffix));
                } else {
                    v1 = latexSequences.add(new LatexDetectionResult.SimpleText(leftSuffix));
                }
            }
            if (iteration != 10) continue;
            break;
        }
        return latexSequences;
    }

    @NotNull
    public final List<LatexDetectionResult> mergeNeighboringLatexSequences(@NotNull List<? extends LatexDetectionResult> $this$mergeNeighboringLatexSequences) {
        Intrinsics.checkNotNullParameter($this$mergeNeighboringLatexSequences, (String)"<this>");
        List mergedSequences = new ArrayList();
        int i = 0;
        while (i < $this$mergeNeighboringLatexSequences.size()) {
            LatexDetectionResult current = $this$mergeNeighboringLatexSequences.get(i);
            if (current instanceof LatexDetectionResult.SimpleText) {
                int j;
                Object mergedText = current.getText();
                for (j = i + 1; j < $this$mergeNeighboringLatexSequences.size() && $this$mergeNeighboringLatexSequences.get(j) instanceof LatexDetectionResult.SimpleText; ++j) {
                    LatexDetectionResult latexDetectionResult = $this$mergeNeighboringLatexSequences.get(j);
                    Intrinsics.checkNotNull((Object)latexDetectionResult, (String)"null cannot be cast to non-null type com.intellij.ml.llm.core.chat.parts.latex.LatexDetectionUtils.LatexDetectionResult.SimpleText");
                    LatexDetectionResult.SimpleText next = (LatexDetectionResult.SimpleText)latexDetectionResult;
                    mergedText = (String)mergedText + next.getText();
                }
                mergedSequences.add(new LatexDetectionResult.SimpleText(((String)mergedText).toString()));
                i = j;
                continue;
            }
            mergedSequences.add(current);
            ++i;
        }
        return mergedSequences;
    }

    @NotNull
    public final List<LatexDetectionResult> splitLatexBySimpleText(@NotNull List<? extends LatexDetectionResult> $this$splitLatexBySimpleText) {
        Intrinsics.checkNotNullParameter($this$splitLatexBySimpleText, (String)"<this>");
        List newTextSeparatedSequences = new ArrayList();
        Iterable $this$forEach$iv = $this$splitLatexBySimpleText;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LatexDetectionResult currentSequence = (LatexDetectionResult)element$iv;
            boolean bl = false;
            LatexDetectionResult latexDetectionResult = currentSequence;
            if (latexDetectionResult instanceof LatexDetectionResult.Latex) {
                String symbolEnding;
                String symbolStarting;
                int startIndex;
                int currentIndex;
                int currentCountOfBrackets;
                String text2;
                block15: {
                    String string;
                    String string2;
                    block14: {
                        text2 = INSTANCE.trimFromSpacesBrackets(currentSequence.getText());
                        currentCountOfBrackets = 0;
                        currentIndex = 0;
                        startIndex = 0;
                        String $this$takeWhile$iv = currentSequence.getText();
                        boolean $i$f$takeWhile = false;
                        int n = $this$takeWhile$iv.length();
                        for (int index$iv = 0; index$iv < n; ++index$iv) {
                            char it22 = $this$takeWhile$iv.charAt(index$iv);
                            int n2 = 0;
                            if (it22 == '[' || it22 == '(' || CharsKt.isWhitespace((char)it22)) continue;
                            String it22 = $this$takeWhile$iv;
                            n2 = 0;
                            String string3 = it22.substring(n2, index$iv);
                            string2 = string3;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                            break block14;
                        }
                        string2 = $this$takeWhile$iv;
                    }
                    symbolStarting = string2;
                    String $this$takeLastWhile$iv = currentSequence.getText();
                    boolean $i$f$takeLastWhile = false;
                    for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                        char it = $this$takeLastWhile$iv.charAt(index$iv);
                        boolean bl2 = false;
                        if (it == ']' || it == ')' || CharsKt.isWhitespace((char)it)) continue;
                        String string4 = $this$takeLastWhile$iv;
                        int n = index$iv + 1;
                        String string5 = string4.substring(n);
                        string = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        break block15;
                    }
                    string = symbolEnding = $this$takeLastWhile$iv;
                }
                while (currentIndex < text2.length()) {
                    switch (text2.charAt(currentIndex)) {
                        case '(': 
                        case '[': 
                        case '{': {
                            ++currentCountOfBrackets;
                            break;
                        }
                        case ')': 
                        case ']': 
                        case '}': {
                            --currentCountOfBrackets;
                        }
                    }
                    if (currentCountOfBrackets == 0) {
                        String string = text2.substring(currentIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        if (StringsKt.startsWith$default((String)string, (String)"\\text{", (boolean)false, (int)2, null)) {
                            int endTextIndex = StringsKt.indexOf$default((CharSequence)text2, (char)'}', (int)currentIndex, (boolean)false, (int)4, null);
                            String string6 = text2.substring(startIndex, currentIndex);
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                            String simpleText = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                            String string7 = text2.substring(currentIndex + 6, endTextIndex);
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                            String insideText = ((Object)StringsKt.trim((CharSequence)string7)).toString();
                            if (!SIMPLE_LATEX_REGEX.containsMatchIn((CharSequence)insideText)) {
                                if (!StringsKt.isBlank((CharSequence)simpleText)) {
                                    newTextSeparatedSequences.add(new LatexDetectionResult.Latex(symbolStarting + simpleText + symbolEnding));
                                }
                                newTextSeparatedSequences.add(new LatexDetectionResult.SimpleText(insideText));
                                currentIndex = startIndex = endTextIndex + 1;
                            }
                        }
                    }
                    ++currentIndex;
                }
                if (startIndex >= text2.length()) continue;
                String string = text2.substring(startIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String remainingLatex = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (!(((CharSequence)remainingLatex).length() > 0)) continue;
                newTextSeparatedSequences.add(new LatexDetectionResult.Latex(symbolStarting + remainingLatex + symbolEnding));
                continue;
            }
            if (latexDetectionResult instanceof LatexDetectionResult.SimpleText) {
                newTextSeparatedSequences.add(currentSequence);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return newTextSeparatedSequences;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IntRange> getCorrectBracketSequences(String text2) {
        List brackets = new ArrayList();
        List stackOfBrackets = new ArrayList();
        CharSequence $this$forEachIndexed$iv = text2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void char_;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c = item$iv;
            int index = n;
            boolean bl = false;
            switch (char_) {
                case 40: 
                case 91: {
                    stackOfBrackets.add(TuplesKt.to((Object)Character.valueOf((char)char_), (Object)index));
                    break;
                }
                case 41: 
                case 93: {
                    if (!(!((Collection)stackOfBrackets).isEmpty())) break;
                    Object e = stackOfBrackets.removeLast();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
                    Pair pair = (Pair)e;
                    char lastBracket = ((Character)pair.component1()).charValue();
                    int lastBracketPosition = ((Number)pair.component2()).intValue();
                    if ((lastBracket != '(' || char_ != 41) && (lastBracket != '[' || char_ != 93)) break;
                    brackets.add(new IntRange(lastBracketPosition, index));
                }
            }
        }
        Iterable $this$sortedBy$iv = brackets;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IntRange it = (IntRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getFirst());
                it = (IntRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getFirst()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCorrectLatexExpression(IntRange range, String text2, List<LatexDetectionResult.Latex> pastAcceptedLatex, List<IntRange> previousRanges) {
        void $this$count$iv;
        int n;
        String $this$trim$iv = text2;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = CharsKt.isWhitespace((char)it) || it == ']' || it == '[' || it == ')' || it == '(';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (StringsKt.isBlank((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) {
            return false;
        }
        try {
            new TeXFormula(text2);
        }
        catch (ParseException parseException) {
            return false;
        }
        if (StringsKt.startsWith$default((String)text2, (String)"[ ", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text2, (String)" ]", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text2, (String)"( ", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text2, (String)" )", (boolean)false, (int)2, null)) {
            return true;
        }
        if (Registry.Companion.is("llm.chat.latex.rendering.advanced.detection") && (StringsKt.startsWith$default((String)text2, (String)"(", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text2, (String)")", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text2, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text2, (String)"]", (boolean)false, (int)2, null))) {
            String formulaCandidate = this.trimFromSpacesBrackets(text2);
            Regex formulaRegex = new Regex("(?<![A-Za-z])" + Regex.Companion.escape(formulaCandidate) + "(?![A-Za-z])");
            if (((CharSequence)formulaCandidate).length() > 0) {
                boolean bl;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block21: {
                    $this$any$iv = pastAcceptedLatex;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            LatexDetectionResult.Latex it = (LatexDetectionResult.Latex)element$iv;
                            boolean bl3 = false;
                            if (!formulaRegex.containsMatchIn((CharSequence)it.getText())) continue;
                            bl = true;
                            break block21;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    boolean bl4;
                    block22: {
                        $this$any$iv = previousRanges;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                IntRange it = (IntRange)element$iv;
                                boolean bl5 = false;
                                if (!(INSTANCE.inside(range, it, false) && !Intrinsics.areEqual((Object)range, (Object)it))) continue;
                                bl4 = true;
                                break block22;
                            }
                            bl4 = false;
                        }
                    }
                    if (!bl4) {
                        return true;
                    }
                }
            }
        }
        int points = 0;
        if (StringsKt.startsWith$default((String)text2, (String)"(", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text2, (String)")", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text2, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text2, (String)"]", (boolean)false, (int)2, null)) {
            points += 20;
        }
        CharSequence formulaRegex = text2;
        int n2 = 15;
        int n3 = points;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!(it == '\\')) continue;
            ++count$iv;
        }
        int n4 = count$iv;
        points = n3 + n2 * n4;
        Object[] $this$forEach$iv = ArraysKt.plus((Object[])SPECIAL_SYMBOLS, (Object[])MATHEMATICAL_EXPRESSIONS);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String specialSymbol = (String)element$iv;
            boolean bl = false;
            Regex regex = new Regex("\\\\" + specialSymbol, RegexOption.IGNORE_CASE);
            points += 14 * SequencesKt.count((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)text2, (int)0, (int)2, null));
        }
        $this$forEach$iv = COMMON_COMMANDS;
        $i$f$forEach = false;
        n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object element$iv;
            Object command = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Regex regex = new Regex("\\\\" + (String)command + "\\{", RegexOption.IGNORE_CASE);
            points += 18 * SequencesKt.count((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)text2, (int)0, (int)2, null));
        }
        return points >= 100;
    }

    private final String trimFromSpacesBrackets(String $this$trimFromSpacesBrackets) {
        String $this$trim$iv = $this$trimFromSpacesBrackets;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char c = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = CharsKt.isWhitespace((char)c) || c == '[' || c == ']' || c == '(' || c == ')';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    public final boolean inside(@NotNull IntRange $this$inside, @NotNull IntRange other, boolean strictly) {
        Intrinsics.checkNotNullParameter((Object)$this$inside, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return !strictly ? $this$inside.getFirst() >= other.getFirst() && $this$inside.getLast() <= other.getLast() : $this$inside.getFirst() > other.getFirst() && $this$inside.getLast() < other.getLast();
    }

    public static /* synthetic */ boolean inside$default(LatexDetectionUtils latexDetectionUtils, IntRange intRange, IntRange intRange2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return latexDetectionUtils.inside(intRange, intRange2, bl);
    }

    static {
        String[] stringArray = new String[]{"Delta", "Gamma", "Lambda", "Omega", "Phi", "Pi", "Psi", "Sigma", "Theta", "Upsilon", "Xi", "alpha", "beta", "chi", "delta", "epsilon", "eta", "gamma", "iota", "kappa", "lambda", "mu", "nu", "omega", "phi", "pi", "psi", "rho", "sigma", "tau", "theta", "upsilon", "xi", "zeta"};
        SPECIAL_SYMBOLS = stringArray;
        stringArray = new String[]{"Pr", "arccos", "arcsin", "arctan", "arg", "cos", "cosh", "cot", "coth", "csc", "deg", "det", "dim", "exp", "gcd", "hom", "inf", "injlim", "ker", "lg", "lim", "liminf", "limsup", "ln", "log", "max", "min", "projlim", "sec", "sin", "sinh", "sup", "tan", "tanh", "varinjlim", "varliminf", "varlimsup", "varprojlim"};
        MATHEMATICAL_EXPRESSIONS = stringArray;
        stringArray = new String[]{"textbf", "textit", "text", "mathcal", "frac", "sum_", "int_", "sqrt", "sin", "cos", "tan"};
        COMMON_COMMANDS = stringArray;
        SIMPLE_LATEX_REGEX = new Regex("[\\\\{\\[]");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/core/chat/parts/latex/LatexDetectionUtils$LatexDetectionResult;", "", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "Latex", "SimpleText", "Lcom/intellij/ml/llm/core/chat/parts/latex/LatexDetectionUtils$LatexDetectionResult$Latex;", "Lcom/intellij/ml/llm/core/chat/parts/latex/LatexDetectionUtils$LatexDetectionResult$SimpleText;", "intellij.ml.llm.chat"})
    public static abstract sealed class LatexDetectionResult {
        @NotNull
        private final String text;

        private LatexDetectionResult(String text2) {
            this.text = text2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public /* synthetic */ LatexDetectionResult(String text2, DefaultConstructorMarker $constructor_marker) {
            this(text2);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/core/chat/parts/latex/LatexDetectionUtils$LatexDetectionResult$Latex;", "Lcom/intellij/ml/llm/core/chat/parts/latex/LatexDetectionUtils$LatexDetectionResult;", "text", "", "<init>", "(Ljava/lang/String;)V", "intellij.ml.llm.chat"})
        public static final class Latex
        extends LatexDetectionResult {
            public Latex(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                super(text2, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/core/chat/parts/latex/LatexDetectionUtils$LatexDetectionResult$SimpleText;", "Lcom/intellij/ml/llm/core/chat/parts/latex/LatexDetectionUtils$LatexDetectionResult;", "text", "", "<init>", "(Ljava/lang/String;)V", "intellij.ml.llm.chat"})
        public static final class SimpleText
        extends LatexDetectionResult {
            public SimpleText(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                super(text2, null);
            }
        }
    }
}

