/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.promptLibrary.entryPoints;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.UserMessage;
import com.intellij.ml.llm.core.chat.promptLibrary.settings.OpenAiAssistantPromptLibrarySettingsKt;
import com.intellij.ml.llm.core.promptLibrary.AIChatLibraryPrompt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/core/chat/promptLibrary/entryPoints/AIAssistantPromptListSavePromptAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "isEnabled", "", "getContents", "Lcom/intellij/ml/llm/privacy/PSString;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.ml.llm.chat"})
public final class AIAssistantPromptListSavePromptAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setIcon(AllIcons.Actions.MenuSaveall);
        e.getPresentation().setEnabledAndVisible(this.isEnabled(e));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            throw new IllegalStateException("Project is required for this action".toString());
        }
        Project project2 = project;
        PSString pSString = this.getContents(e);
        if (pSString == null) {
            return;
        }
        PSString text2 = pSString;
        AIChatLibraryPrompt newPrompt = AIChatLibraryPrompt.Companion.fromContent(text2);
        OpenAiAssistantPromptLibrarySettingsKt.openAiAssistantPromptLibrarySettings(project2, newPrompt);
    }

    private final boolean isEnabled(AnActionEvent e) {
        PSString pSString = this.getContents(e);
        return pSString != null ? pSString.isNotBlank() : false;
    }

    private final PSString getContents(AnActionEvent e) {
        PSString pSString;
        String string = e.getPlace();
        switch (string.hashCode()) {
            case -946567173: {
                if (string.equals("AIAssistantInputLeft")) {
                    Editor editor = (Editor)e.getDataContext().getData(PlatformDataKeys.EDITOR);
                    if (editor == null) {
                        throw new IllegalStateException("Editor is required for this action".toString());
                    }
                    Editor editor2 = editor;
                    pSString = ExtensionsKtKt.getPrivacySafe((Editor)editor2).getDocument().getText();
                    break;
                }
            }
            default: {
                UserMessage message;
                Object object = e.getDataContext().getData(ChatMessage.Companion.getKey());
                UserMessage userMessage = message = object instanceof UserMessage ? (UserMessage)object : null;
                if ((userMessage != null ? userMessage.getAuthor() : null) != ChatMessageAuthor.User) {
                    return null;
                }
                pSString = message.getDisplayText();
            }
        }
        return pSString;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

