/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.promptLibrary.views;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateHighlighter;
import com.intellij.lang.Language;
import com.intellij.ml.llm.core.promptLibrary.variables.AIAssistantPromptLibraryVariablesService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ui.JBUI;
import java.util.Properties;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0002\u001a\b\u0010\u0015\u001a\u00020\u0016H\u0002\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"VELOCITY_FILE_NAME", "Lcom/intellij/openapi/fileTypes/FileType;", "Lorg/jetbrains/annotations/NotNull;", "getVELOCITY_FILE_NAME", "()Lcom/intellij/openapi/fileTypes/FileType;", "TEXT_TOKEN", "Lcom/intellij/psi/tree/IElementType;", "createEditor", "Lcom/intellij/openapi/editor/Editor;", "disposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "filename", "", "createFile", "Lcom/intellij/psi/PsiFile;", "name", "createDocument", "Lcom/intellij/openapi/editor/Document;", "file", "createHighlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "intellij.ml.llm.chat"})
public final class PromptEditorFieldKt {
    @NotNull
    private static final IElementType TEXT_TOKEN = new IElementType("TEXT", Language.ANY);

    private static final FileType getVELOCITY_FILE_NAME() {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension("ft");
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByExtension(...)");
        return fileType;
    }

    @NotNull
    public static final Editor createEditor(@NotNull Disposable disposable, @NotNull Project project, @NotNull String filename) {
        EditorSettings editorSettings;
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        PsiFile file = PromptEditorFieldKt.createFile(project, filename);
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document doc = PromptEditorFieldKt.createDocument(file);
        Editor editor = editorFactory.createEditor(doc, project);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        EditorSettings $this$createEditor_u24lambda_u240 = editorSettings = editor2.getSettings();
        boolean bl = false;
        $this$createEditor_u24lambda_u240.setVirtualSpace(false);
        $this$createEditor_u24lambda_u240.setLineMarkerAreaShown(false);
        $this$createEditor_u24lambda_u240.setIndentGuidesShown(false);
        $this$createEditor_u24lambda_u240.setLineNumbersShown(false);
        $this$createEditor_u24lambda_u240.setFoldingOutlineShown(false);
        $this$createEditor_u24lambda_u240.setAdditionalColumnsCount(3);
        $this$createEditor_u24lambda_u240.setAdditionalLinesCount(3);
        $this$createEditor_u24lambda_u240.setCaretRowShown(false);
        $this$createEditor_u24lambda_u240.setUseSoftWraps(true);
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> PromptEditorFieldKt.createEditor$lambda$1(editorFactory, editor2));
        editor2.setHighlighter(PromptEditorFieldKt.createHighlighter());
        editor2.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        return (Editor)editor2;
    }

    private static final PsiFile createFile(Project project, String name) {
        FileType fileType = PromptEditorFieldKt.getVELOCITY_FILE_NAME();
        if (fileType == FileTypes.UNKNOWN) {
            return null;
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("$" + name + ".txt.ft", fileType, (CharSequence)"", 0L, true);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        PsiFile file = psiFile;
        Properties properties = AIAssistantPromptLibraryVariablesService.Companion.getInstance().getProperties();
        file.getViewProvider().putUserData(FileTemplateManager.DEFAULT_TEMPLATE_PROPERTIES, (Object)properties);
        return file;
    }

    private static final Document createDocument(PsiFile file) {
        PsiFile psiFile = file;
        Document document = psiFile != null ? PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(file) : null;
        Document document2 = document;
        if (document2 == null) {
            Document document3 = EditorFactory.getInstance().createDocument((CharSequence)"");
            document2 = document3;
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"createDocument(...)");
        }
        return document2;
    }

    private static final EditorHighlighter createHighlighter() {
        LanguageFileType fileType = FileTypes.PLAIN_TEXT;
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)((FileType)fileType), null, null);
        if (syntaxHighlighter == null) {
            syntaxHighlighter = (SyntaxHighlighter)new PlainSyntaxHighlighter();
        }
        SyntaxHighlighter originalHighlighter = syntaxHighlighter;
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        LayeredLexerEditorHighlighter highlighter = new LayeredLexerEditorHighlighter((SyntaxHighlighter)new FileTemplateHighlighter(), scheme);
        highlighter.registerLayer(TEXT_TOKEN, new LayerDescriptor(originalHighlighter, ""));
        return (EditorHighlighter)highlighter;
    }

    private static final Unit createEditor$lambda$1(EditorFactory $editorFactory, EditorEx $editor) {
        $editorFactory.releaseEditor((Editor)$editor);
        return Unit.INSTANCE;
    }
}

