/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.services.paste;

import com.intellij.ide.PasteProvider;
import com.intellij.ml.llm.core.chat.services.paste.AIChatImagePasteProviderKt;
import com.intellij.ml.llm.core.chat.services.paste.PasteAttachmentSource;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.ui.chat.context.AIChatContextVm;
import com.intellij.ml.llm.core.chat.ui.chat.context.AIChatModeUtil;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentKind;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.FileContextAttachment;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.util.Producer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.MultiResolutionImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.fileTypes.impl.ImageFileType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0007H\u0002J\u0016\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b*\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\fH\u0002J\f\u0010\u0014\u001a\u00020\u0013*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/AIChatImagePasteProvider;", "Lcom/intellij/ide/PasteProvider;", "<init>", "()V", "performPaste", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "transferable", "Lcom/intellij/util/Producer;", "Ljava/awt/datatransfer/Transferable;", "isPastePossible", "", "isPasteEnabled", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getImageContents", "Ljava/awt/image/BufferedImage;", "toBufferedImage", "Ljava/awt/Image;", "intellij.ml.llm.chat"})
public final class AIChatImagePasteProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        ChatSession chatSession2 = this.chatSession(dataContext);
        if (chatSession2 == null) {
            return;
        }
        ChatSession chatSession3 = chatSession2;
        Object object = this.transferable(dataContext);
        if (object == null || (object = (Transferable)object.produce()) == null) {
            return;
        }
        Object transferable = object;
        AIChatContextVm contextModel = chatSession3.getContextViewModel();
        Project project = chatSession3.getProject();
        BufferedImage bufferedImage = this.getImageContents((Transferable)transferable);
        if (bufferedImage == null) {
            return;
        }
        BufferedImage image = bufferedImage;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", byteArrayOutputStream);
        byte[] data2 = byteArrayOutputStream.toByteArray();
        BinaryLightVirtualFile lightImageFile = new BinaryLightVirtualFile("Image", (FileType)ImageFileType.INSTANCE, data2);
        contextModel.getModelImpl().addContextItem(new FileContextAttachment(project, (VirtualFile)lightImageFile, PasteAttachmentSource.INSTANCE, null, 8, null));
    }

    private final ChatSession chatSession(DataContext $this$chatSession) {
        return (ChatSession)$this$chatSession.getData(ChatSession.Companion.getCurrentSession());
    }

    private final Producer<Transferable> transferable(DataContext $this$transferable) {
        return (Producer)$this$transferable.getData(PasteAction.TRANSFERABLE_PROVIDER);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!FileContextAttachment.Companion.isAllowedToAddImages()) {
            return false;
        }
        ChatSession chatSession2 = this.chatSession(dataContext);
        if (chatSession2 == null) {
            return false;
        }
        ChatSession session = chatSession2;
        if (!AIChatModeUtil.INSTANCE.isSupported(session, ContextAttachmentKind.IMAGE)) {
            return false;
        }
        Object object = this.transferable(dataContext);
        if (object == null || (object = (Transferable)object.produce()) == null) {
            return false;
        }
        Object transferable = object;
        return transferable.isDataFlavorSupported(DataFlavor.imageFlavor);
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return FileContextAttachment.Companion.isAllowedToAddImages() && this.isPastePossible(dataContext);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final BufferedImage getImageContents(Transferable transferable) {
        BufferedImage imageToPaste;
        BufferedImage bufferedImage;
        Object object;
        try {
            object = transferable.getTransferData(DataFlavor.imageFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (IOException ioException) {
            AIChatImagePasteProviderKt.access$getLogger$p().error("Failed to get data from the clipboard. Data is no longer available. Aborting operation.", (Throwable)ioException);
            return null;
        }
        Object it = object;
        boolean bl = false;
        Object object2 = it;
        if (object2 instanceof MultiResolutionImage) {
            List<Image> list = ((MultiResolutionImage)it).getResolutionVariants();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getResolutionVariants(...)");
            Image image = (Image)CollectionsKt.firstOrNull(list);
            bufferedImage = image != null ? this.toBufferedImage(image) : null;
        } else {
            bufferedImage = object2 instanceof BufferedImage ? (BufferedImage)it : (object2 instanceof Image ? this.toBufferedImage((Image)it) : null);
        }
        if ((imageToPaste = bufferedImage) == null) {
            AIChatImagePasteProviderKt.access$getLogger$p().error("Failed to get data from the clipboard. Nothing to paste. Aborting operation.");
            return null;
        }
        return imageToPaste;
    }

    /*
     * WARNING - void declaration
     */
    private final BufferedImage toBufferedImage(Image $this$toBufferedImage) {
        BufferedImage bufferedImage;
        if ($this$toBufferedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)$this$toBufferedImage;
        } else {
            void var2_2;
            BufferedImage bufferedImage2 = new BufferedImage($this$toBufferedImage.getWidth(null), $this$toBufferedImage.getHeight(null), 2);
            Graphics2D bGr = bufferedImage2.createGraphics();
            bGr.drawImage($this$toBufferedImage, 0, 0, null);
            bGr.dispose();
            bufferedImage = var2_2;
        }
        return bufferedImage;
    }
}

