/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.session.summary;

import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.session.summary.ChatSummarizationStrategy;
import com.intellij.ml.llm.core.chat.session.summary.ChatSummaryStateWrapper;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0011J(\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\bH\u0086@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/chat/session/summary/ChatSummarizerContext;", "", "strategy", "Lcom/intellij/ml/llm/core/chat/session/summary/ChatSummarizationStrategy;", "messages", "", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessage;", "summarySizeInSymbols", "", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "<init>", "(Lcom/intellij/ml/llm/core/chat/session/summary/ChatSummarizationStrategy;Ljava/util/List;ILcom/intellij/ml/llm/tokenizer/Tokenizer;)V", "executeSummarization", "Lcom/intellij/ml/llm/core/chat/session/summary/ChatSummaryStateWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeUpdateSummary", "previousSummaryState", "indexOfLastMessage", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/core/chat/session/summary/ChatSummaryStateWrapper;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.chat"})
public final class ChatSummarizerContext {
    @NotNull
    private final ChatSummarizationStrategy strategy;
    @NotNull
    private final List<ChatMessage> messages;
    private final int summarySizeInSymbols;
    @NotNull
    private final Tokenizer tokenizer;

    public ChatSummarizerContext(@NotNull ChatSummarizationStrategy strategy, @NotNull List<? extends ChatMessage> messages, int summarySizeInSymbols, @NotNull Tokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.strategy = strategy;
        this.messages = messages;
        this.summarySizeInSymbols = summarySizeInSymbols;
        this.tokenizer = tokenizer;
    }

    @Nullable
    public final Object executeSummarization(@NotNull Project project, @NotNull Continuation<? super ChatSummaryStateWrapper> $completion) {
        return this.strategy.generate(project, this.messages, this.summarySizeInSymbols, this.tokenizer, $completion);
    }

    @Nullable
    public final Object executeUpdateSummary(@NotNull Project project, @NotNull ChatSummaryStateWrapper previousSummaryState, int indexOfLastMessage, @NotNull Continuation<? super ChatSummaryStateWrapper> $completion) {
        return this.strategy.update(project, previousSummaryState, this.messages, indexOfLastMessage, this.summarySizeInSymbols, this.tokenizer, $completion);
    }
}

