/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ml.llm.core.chat.parts.CustomCSSProvider;
import com.intellij.ml.llm.core.chat.parts.CustomCSSProviderKt;
import com.intellij.ml.llm.core.chat.ui.AIAssistantColors;
import com.intellij.ml.llm.core.chat.ui.chat.AiPartViewTransferHandler;
import com.intellij.ml.llm.core.chat.ui.chat.MessagePartView;
import com.intellij.ml.llm.core.chat.ui.chat.MessagePartViewExtension;
import com.intellij.ml.llm.core.chat.ui.chat.TextPartViewEditorPaneKt;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageSelectUtilsKt;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBHtmlPaneConfiguration;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.StyleSheetUtil;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u001f\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0007J\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eJ\b\u0010\u000f\u001a\u00020\fH\u0002J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0017J\b\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/TextPartViewEditorPane;", "Lcom/intellij/ui/components/JBHtmlPane;", "Lcom/intellij/ide/CopyProvider;", "Lcom/intellij/ide/PasteProvider;", "Lcom/intellij/openapi/editor/colors/EditorColorsListener;", "msgView", "Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartView;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartView;Lcom/intellij/openapi/project/Project;)V", "patchCSSOnStateChanged", "", "styleSheetProviders", "", "overwriteCustomStyleSheetProviders", "globalSchemeChange", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "setupCopyActionForComponent", "performCopy", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyEnabled", "", "isCopyVisible", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "performPaste", "isPastePossible", "isPasteEnabled", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nTextPartViewEditorPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextPartViewEditorPane.kt\ncom/intellij/ml/llm/core/chat/ui/chat/TextPartViewEditorPane\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,317:1\n1#2:318\n1563#3:319\n1634#3,3:320\n37#4,2:323\n42#5,3:325\n23#6:328\n23#6:329\n*S KotlinDebug\n*F\n+ 1 TextPartViewEditorPane.kt\ncom/intellij/ml/llm/core/chat/ui/chat/TextPartViewEditorPane\n*L\n76#1:319\n76#1:320,3\n76#1:323,2\n116#1:325,3\n126#1:328\n187#1:329\n*E\n"})
public final class TextPartViewEditorPane
extends JBHtmlPane
implements CopyProvider,
PasteProvider,
EditorColorsListener {
    @Nullable
    private final MessagePartView msgView;
    @Nullable
    private final Project project;

    /*
     * WARNING - void declaration
     */
    public TextPartViewEditorPane(@Nullable MessagePartView msgView, @Nullable Project project) {
        super(new JBHtmlPaneStyleConfiguration(), new JBHtmlPaneConfiguration());
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        MessagePartViewExtension.Context context;
        this.msgView = msgView;
        this.project = project;
        MessagePartView messagePartView = this.msgView;
        if (messagePartView != null) {
            MessagePartView msg = messagePartView;
            boolean bl = false;
            Project project2 = this.project;
            if (project2 != null) {
                Project prj = project2;
                boolean bl2 = false;
                context = new MessagePartViewExtension.Context(msg, prj);
            } else {
                context = null;
            }
        } else {
            context = null;
        }
        MessagePartViewExtension.Context mpvCtx = context;
        Iterable $this$map$iv = MessagePartViewExtension.Companion.getEP().getExtensionList();
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MessagePartViewExtension messagePartViewExtension = (MessagePartViewExtension)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getExtension(mpvCtx));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Function2[] elementExtensions = thisCollection$iv.toArray(new Function2[0]);
        EditorKit editorKit = this.getEditorKit();
        Intrinsics.checkNotNull((Object)editorKit, (String)"null cannot be cast to non-null type com.intellij.util.ui.JBHtmlEditorKit");
        TextPartViewEditorPaneKt.access$addExtensions((JBHtmlEditorKit)editorKit, Arrays.copyOf(elementExtensions, elementExtensions.length));
        this.overwriteCustomStyleSheetProviders();
        this.patchCSSOnStateChanged();
        if (CustomCSSProviderKt.isCustomCSSEnabled()) {
            CustomCSSProvider.Companion.getInstance().watchEditorPane(this);
        }
        this.setEditable(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.setOpaque(false);
        this.setBorder(null);
        this.putClientProperty("AccessibleName", StringUtil.unescapeXmlEntities((String)StringUtil.stripHtml((String)"", (String)" ")));
        this.setText("");
        this.setCaret(new DefaultCaret());
        this.putClientProperty("caretWidth", null);
        this.setCaretPosition(0);
        Caret caret = this.getCaret();
        DefaultCaret defaultCaret = caret instanceof DefaultCaret ? (DefaultCaret)caret : null;
        if (defaultCaret != null) {
            defaultCaret.setUpdatePolicy(1);
        }
        this.setupCopyActionForComponent();
        this.setFocusable(true);
        this.setFocusCycleRoot(false);
    }

    public /* synthetic */ TextPartViewEditorPane(MessagePartView messagePartView, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            messagePartView = null;
        }
        if ((n & 2) != 0) {
            project = null;
        }
        this(messagePartView, project);
    }

    @RequiresEdt
    public final void patchCSSOnStateChanged() {
        float originalScale = JBUIScale.scale((float)1.0f);
        try {
            TextPartViewEditorPaneKt.invalidateInternalStyleSheetCacheIfNeed();
            boolean $i$f$service22 = false;
            Class<LLMSettingsManager> serviceClass$iv = LLMSettingsManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            float scaledFontSize = originalScale * ((LLMSettingsManager)object).getToolwindowFontScale() * 13.0f;
            this.setFont(this.getFont().deriveFont(scaledFontSize));
            Class[] $i$f$service22 = new Class[]{HTMLEditorKit.class};
            Method it = JBHtmlPane.class.getDeclaredMethod("updateDocumentationPaneDefaultCssRules", $i$f$service22);
            boolean bl = false;
            it.setAccessible(true);
            Object[] objectArray = new Object[1];
            EditorKit editorKit = this.getEditorKit();
            objectArray[0] = editorKit instanceof HTMLEditorKit ? (HTMLEditorKit)editorKit : null;
            it.invoke((Object)this, objectArray);
            View view = this.getUI().getRootView((JTextComponent)((Object)this));
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getRootView(...)");
            TextPartViewEditorPaneKt.access$applyCssToView(view);
        }
        catch (Exception e) {
            TextPartViewEditorPane $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TextPartViewEditorPane.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
        }
    }

    @NotNull
    public final List<?> styleSheetProviders() {
        Function1 styleSheetProvider = arg_0 -> TextPartViewEditorPane.styleSheetProviders$lambda$0(this, arg_0);
        return CollectionsKt.listOf((Object)styleSheetProvider);
    }

    private final void overwriteCustomStyleSheetProviders() {
        Field f_myPaneConfiguration = JBHtmlPane.class.getDeclaredField("myPaneConfiguration");
        f_myPaneConfiguration.setAccessible(true);
        Field f_customStyleSheetProviders = JBHtmlPaneConfiguration.class.getDeclaredField("customStyleSheetProviders");
        f_customStyleSheetProviders.setAccessible(true);
        f_customStyleSheetProviders.set(f_myPaneConfiguration.get((Object)this), this.styleSheetProviders());
    }

    @RequiresEdt
    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        this.patchCSSOnStateChanged();
    }

    private final void setupCopyActionForComponent() {
        AIMessageSelectUtilsKt.createStackedPopupHandler((JComponent)((Object)this), AIMessageSelectUtilsKt.messagePartPopupGroupId(), "EditorPopup", true);
        ActionManager.getInstance().getAction("$Copy").registerCustomShortcutSet((JComponent)((Object)this), null);
        ActionManager.getInstance().getAction("$Paste").registerCustomShortcutSet((JComponent)((Object)this), null);
        this.setTransferHandler(new AiPartViewTransferHandler());
    }

    public void performCopy(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        this.copy();
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        Intrinsics.checkNotNullExpressionValue((Object)transferable, (String)"getContents(...)");
        Transferable contents = transferable;
        if (contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                Object object = contents.getTransferData(DataFlavor.stringFlavor);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String htmlContent = (String)object;
                this.setText(htmlContent);
            }
            catch (Exception e) {
                TextPartViewEditorPane $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(TextPartViewEditorPane.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
            }
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    private static final StyleSheet styleSheetProviders$lambda$0(TextPartViewEditorPane this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        float scaleVsBaseFontSize = this$0.getFont().getSize2D() / 13.0f;
        String string = ColorUtil.toHtmlColor((Color)this$0.getForeground());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(...)");
        String string2 = StringsKt.replace$default((String)"\n          h6 { font-size: 14; }\n          h5 { font-size: 15; }\n          h4 { font-size: 16; }\n          h3 { font-size: 17; }\n          h2 { font-size: 19; }\n          h1 { font-size: 21; }\n          a  { text-decoration: none; }          \n          code { color: {{code-color}}; background-color: {{code-background-color}}; text-decoration: none; font-weight: normal; }\n          .user-del { text-decoration: line-through }\n      ", (String)"{{code-color}}", (String)string, (boolean)false, (int)4, null);
        Object object = this$0.msgView;
        String string3 = ColorUtil.toHtmlColor((Color)AIAssistantColors.INSTANCE.getInlineCodeBackground(object != null && (object = object.getPart()) != null && (object = object.getMessage()) != null ? object.getAuthor() : null));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toHtmlColor(...)");
        CharSequence charSequence = StringsKt.replace$default((String)string2, (String)"{{code-background-color}}", (String)string3, (boolean)false, (int)4, null);
        Regex regex = TextPartViewEditorPaneKt.access$getFONT_SIZE_REGEX$p();
        Function1 function1 = arg_0 -> TextPartViewEditorPane.styleSheetProviders$lambda$0$0(scaleVsBaseFontSize, arg_0);
        String cssScaled = regex.replace(charSequence, function1);
        return StyleSheetUtil.loadStyleSheet((String)cssScaled);
    }

    private static final CharSequence styleSheetProviders$lambda$0$0(float $scaleVsBaseFontSize, MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "font-size: " + MathKt.roundToInt((float)((float)Integer.parseInt((String)it.getGroupValues().get(1)) * $scaleVsBaseFontSize)) + ";";
    }

    public TextPartViewEditorPane() {
        this(null, null, 3, null);
    }
}

