/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.codeSpan;

import com.intellij.ml.llm.core.chat.ui.chat.codeSpan.Token;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0086\b\u00f8\u0001\u0000J&\u0010\u000e\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/codeSpan/TokenizedSearcher;", "", "<init>", "()V", "search", "", "pattern", "", "Lcom/intellij/ml/llm/core/chat/ui/chat/codeSpan/Token;", "text", "processor", "Lkotlin/Function1;", "Lcom/intellij/ml/llm/core/chat/ui/chat/codeSpan/TokenizedSearcher$Match;", "", "computeLPSArray", "patternLength", "", "lps", "", "Match", "intellij.ml.llm.chat"})
final class TokenizedSearcher {
    @NotNull
    public static final TokenizedSearcher INSTANCE = new TokenizedSearcher();

    private TokenizedSearcher() {
    }

    public final void search(@NotNull List<Token> pattern, @NotNull List<Token> text2, @NotNull Function1<? super Match, Boolean> processor) {
        Intrinsics.checkNotNullParameter(pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(text2, (String)"text");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        boolean $i$f$search = false;
        int patternLength = pattern.size();
        if (patternLength == 0) {
            return;
        }
        Iterator<Token> textIterator = text2.iterator();
        if (!textIterator.hasNext()) {
            return;
        }
        int[] lps = new int[patternLength];
        this.computeLPSArray(pattern, patternLength, lps);
        int j = 0;
        int i = 0;
        Token token = null;
        boolean skipAdvance = false;
        while (textIterator.hasNext()) {
            if (!skipAdvance) {
                token = textIterator.next();
                ++i;
            }
            skipAdvance = false;
            if (Intrinsics.areEqual((Object)pattern.get(j), (Object)token)) {
                if (++j != patternLength) continue;
                if (!((Boolean)processor.invoke((Object)new Match(text2.get(i - j).getOffset(), token.getOffset() + token.getText().length()))).booleanValue()) {
                    return;
                }
                j = lps[j - 1];
                continue;
            }
            if (j <= 0) continue;
            j = lps[j - 1];
            skipAdvance = true;
        }
    }

    private final void computeLPSArray(List<Token> pattern, int patternLength, int[] lps) {
        int length = 0;
        int i = 1;
        lps[0] = 0;
        while (i < patternLength) {
            if (Intrinsics.areEqual((Object)pattern.get(i), (Object)pattern.get(length))) {
                lps[i] = ++length;
                ++i;
                continue;
            }
            if (length != 0) {
                length = lps[length - 1];
                continue;
            }
            lps[i] = 0;
            ++i;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/codeSpan/TokenizedSearcher$Match;", "", "startOffset", "", "endOffset", "<init>", "(II)V", "getStartOffset", "()I", "getEndOffset", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.chat"})
    public static final class Match {
        private final int startOffset;
        private final int endOffset;

        public Match(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public final int getEndOffset() {
            return this.endOffset;
        }

        public final int component1() {
            return this.startOffset;
        }

        public final int component2() {
            return this.endOffset;
        }

        @NotNull
        public final Match copy(int startOffset, int endOffset) {
            return new Match(startOffset, endOffset);
        }

        public static /* synthetic */ Match copy$default(Match match, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = match.startOffset;
            }
            if ((n3 & 2) != 0) {
                n2 = match.endOffset;
            }
            return match.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Match(startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.startOffset);
            result2 = result2 * 31 + Integer.hashCode(this.endOffset);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Match)) {
                return false;
            }
            Match match = (Match)other;
            if (this.startOffset != match.startOffset) {
                return false;
            }
            return this.endOffset == match.endOffset;
        }
    }
}

