/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.DirectoryAttachmentTreeNode;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringBackendKt;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.smartChat.endpoints.ContentsType;
import com.intellij.ml.llm.smartChat.psiSummarization.AIAssistantReadContents;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import com.intellij.ml.llm.tokenizer.TrimTokenizer;
import com.intellij.ml.llm.tokenizer.fus.PromptSource;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J!\u0010\u0015\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryTextGenerator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getTrimmedText", "Lcom/intellij/ml/llm/smartChat/psiSummarization/AIAssistantReadContents;", "tree", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryAttachmentTreeNode;", "tokenLimit", "", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "(Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryAttachmentTreeNode;ILcom/intellij/ml/llm/tokenizer/Tokenizer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateDirectoryText", "Lcom/intellij/ml/llm/privacy/PSString;", "(Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryAttachmentTreeNode;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "formatDirectoryContent", "structure", "filesContent", "getFileTreeStructure", "maxDepth", "(Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryAttachmentTreeNode;Ljava/lang/Integer;)Lcom/intellij/ml/llm/privacy/PSString;", "getFileContents", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nDirectoryContextAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryContextAttachment.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryTextGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,586:1\n774#2:587\n865#2,2:588\n1869#2,2:590\n1869#2,2:592\n*S KotlinDebug\n*F\n+ 1 DirectoryContextAttachment.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryTextGenerator\n*L\n554#1:587\n554#1:588,2\n554#1:590,2\n578#1:592,2\n*E\n"})
final class DirectoryTextGenerator {
    @NotNull
    private final Project project;

    public DirectoryTextGenerator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final Object getTrimmedText(@NotNull DirectoryAttachmentTreeNode tree, int tokenLimit, @NotNull Tokenizer tokenizer, @NotNull Continuation<? super AIAssistantReadContents> $completion) {
        return CoroutinesKt.readAction(() -> DirectoryTextGenerator.getTrimmedText$lambda$0(tree, this, tokenizer, tokenLimit), $completion);
    }

    @Nullable
    public final Object generateDirectoryText(@NotNull DirectoryAttachmentTreeNode tree, @NotNull Continuation<? super PSString> $completion) {
        return CoroutinesKt.readAction(() -> DirectoryTextGenerator.generateDirectoryText$lambda$0(this, tree), $completion);
    }

    private final PSString formatDirectoryContent(DirectoryAttachmentTreeNode tree, PSString structure, PSString filesContent) {
        return PSStringKt.buildStringPrivacySafe(arg_0 -> DirectoryTextGenerator.formatDirectoryContent$lambda$0(tree, structure, filesContent, arg_0));
    }

    private final PSString getFileTreeStructure(DirectoryAttachmentTreeNode tree, Integer maxDepth) {
        List treeLines = new ArrayList();
        DirectoryTextGenerator.getFileTreeStructure$addNodeToTree(maxDepth, treeLines, tree);
        return PSStringKt.joinToString$default((Iterable)treeLines, (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"\n")), null, null, (int)0, null, (int)30, null);
    }

    static /* synthetic */ PSString getFileTreeStructure$default(DirectoryTextGenerator directoryTextGenerator, DirectoryAttachmentTreeNode directoryAttachmentTreeNode, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return directoryTextGenerator.getFileTreeStructure(directoryAttachmentTreeNode, n);
    }

    private final PSString getFileContents(DirectoryAttachmentTreeNode tree, Integer maxDepth) {
        List fileContents = new ArrayList();
        DirectoryTextGenerator.getFileContents$collectFiles(maxDepth, this, fileContents, tree);
        return PSStringKt.joinToString$default((Iterable)fileContents, (PrivacySafe)((PrivacySafe)ConstantsKt.getNL()), null, null, (int)0, null, (int)30, null);
    }

    static /* synthetic */ PSString getFileContents$default(DirectoryTextGenerator directoryTextGenerator, DirectoryAttachmentTreeNode directoryAttachmentTreeNode, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return directoryTextGenerator.getFileContents(directoryAttachmentTreeNode, n);
    }

    private static final AIAssistantReadContents getTrimmedText$lambda$0(DirectoryAttachmentTreeNode $tree, DirectoryTextGenerator this$0, Tokenizer $tokenizer, int $tokenLimit) {
        PSString firstLayerFiles;
        int maxDepth = $tree.findMaxDepthInTree();
        PSString firstLayerStructure = this$0.getFileTreeStructure($tree, 1);
        PSString firstLayerContent = this$0.formatDirectoryContent($tree, firstLayerStructure, firstLayerFiles = this$0.getFileContents($tree, 1));
        int firstLayerTokens = $tokenizer.count((String)firstLayerContent.unwrap());
        if (firstLayerTokens <= $tokenLimit) {
            PSString depthContent;
            int depthTokens;
            PSString resultingMaxStructure = firstLayerStructure;
            PSString resultingContent = firstLayerContent;
            ContentsType resultingContentType = ContentsType.FULL;
            int depth = 2;
            if (depth <= maxDepth) {
                while (true) {
                    PSString depthStructure;
                    if ((depthTokens = $tokenizer.count((String)(depthContent = this$0.formatDirectoryContent($tree, depthStructure = this$0.getFileTreeStructure($tree, depth), firstLayerFiles)).unwrap())) > $tokenLimit) {
                        resultingContentType = ContentsType.TRUNCATED;
                        break;
                    }
                    resultingMaxStructure = depthStructure;
                    resultingContent = depthContent;
                    if (depth == maxDepth) break;
                    ++depth;
                }
            }
            if (resultingContentType == ContentsType.FULL && (depth = 2) <= maxDepth) {
                while (true) {
                    PSString depthFiles;
                    if ((depthTokens = $tokenizer.count((String)(depthContent = this$0.formatDirectoryContent($tree, resultingMaxStructure, depthFiles = this$0.getFileContents($tree, depth))).unwrap())) > $tokenLimit) {
                        resultingContentType = ContentsType.TRUNCATED;
                        break;
                    }
                    resultingContent = depthContent;
                    if (depth == maxDepth) break;
                    ++depth;
                }
            }
            return new AIAssistantReadContents(resultingContent, resultingContentType);
        }
        PSString structureOnlyContent = this$0.formatDirectoryContent($tree, firstLayerStructure, ConstantsKt.getPrivacyConst((String)""));
        int structureOnlyTokens = $tokenizer.count((String)structureOnlyContent.unwrap());
        if (structureOnlyTokens <= $tokenLimit) {
            PSString bestStructureContent = structureOnlyContent;
            int depth = 2;
            if (depth <= maxDepth) {
                PSString depthStructure;
                PSString depthContent;
                int depthTokens;
                while ((depthTokens = $tokenizer.count((String)(depthContent = this$0.formatDirectoryContent($tree, depthStructure = this$0.getFileTreeStructure($tree, depth), ConstantsKt.getPrivacyConst((String)""))).unwrap())) <= $tokenLimit) {
                    bestStructureContent = depthContent;
                    if (depth == maxDepth) break;
                    ++depth;
                }
            }
            return new AIAssistantReadContents(bestStructureContent, ContentsType.TRUNCATED);
        }
        PSString truncatedContent = PSStringBackendKt.trimWithTokenizer((PSString)structureOnlyContent, (TrimTokenizer)((TrimTokenizer)$tokenizer), (int)$tokenLimit, (PromptSource)PromptSource.DIRECTORY_STRUCTURE_ATTACHED_CONTEXT);
        return new AIAssistantReadContents(truncatedContent, ContentsType.TRUNCATED);
    }

    private static final PSString generateDirectoryText$lambda$0(DirectoryTextGenerator this$0, DirectoryAttachmentTreeNode $tree) {
        PSString structure = DirectoryTextGenerator.getFileTreeStructure$default(this$0, $tree, null, 2, null);
        PSString filesContent = DirectoryTextGenerator.getFileContents$default(this$0, $tree, null, 2, null);
        return this$0.formatDirectoryContent($tree, structure, filesContent);
    }

    private static final Unit formatDirectoryContent$lambda$0(DirectoryAttachmentTreeNode $tree, PSString $structure, PSString $filesContent, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((VirtualFile)$tree.getFile()).getPath()};
        $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"Directory: %s").format(pSStringConvertibleArray));
        $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"\n\n"));
        pSStringConvertibleArray = new PSStringConvertible[]{$structure};
        $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"Structure:\n%s").format(pSStringConvertibleArray));
        $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"\n"));
        if (!($filesContent.unwrap().length() == 0)) {
            $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"\n"));
            pSStringConvertibleArray = new PSStringConvertible[]{$filesContent};
            $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"Files contents:\n%s").format(pSStringConvertibleArray));
            $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"\n"));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void getFileTreeStructure$addNodeToTree(Integer $maxDepth, List<PSString> treeLines, DirectoryAttachmentTreeNode node) {
        void $this$filterTo$iv$iv;
        Object object;
        if ($maxDepth != null && node.getDepth() > $maxDepth) {
            return;
        }
        if (node.getDepth() == 0) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((VirtualFile)node.getFile()).getName()};
            v0 = treeLines.add(ConstantsKt.getPrivacyConst((String)"%s/").format(pSStringConvertibleArray));
        } else {
            PSString pSString;
            PSString indent = ConstantsKt.getPrivacyConst((String)"  ").repeat(node.getDepth());
            if (node.getFile().isDirectory()) {
                object = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((VirtualFile)node.getFile()).getName()};
                pSString = ConstantsKt.getPrivacyConst((String)"%s/").format((PSStringConvertible[])object);
            } else {
                pSString = ExtensionsKtKt.getPrivacySafe((VirtualFile)node.getFile()).getName();
            }
            PSString fileName = pSString;
            object = new PSStringConvertible[]{indent, fileName};
            v0 = treeLines.add(ConstantsKt.getPrivacyConst((String)"%s- %s").format((PSStringConvertible[])object));
        }
        Iterable $this$filter$iv = node.getChildren();
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DirectoryAttachmentTreeNode it = (DirectoryAttachmentTreeNode)element$iv$iv;
            boolean bl = false;
            if (!(!it.isAiIgnored())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DirectoryAttachmentTreeNode child = (DirectoryAttachmentTreeNode)element$iv;
            boolean bl = false;
            DirectoryTextGenerator.getFileTreeStructure$addNodeToTree($maxDepth, treeLines, child);
        }
    }

    private static final void getFileContents$collectFiles(Integer $maxDepth, DirectoryTextGenerator this$0, List<PSString> fileContents, DirectoryAttachmentTreeNode node) {
        if ($maxDepth != null && node.getDepth() > $maxDepth) {
            return;
        }
        if (!node.getFile().isDirectory() && !node.isAiIgnored()) {
            Document document = VirtualFileUtil.findDocument((VirtualFile)node.getFile());
            if (document == null || (document = ExtensionsKtKt.privacySafe((Document)document, (Project)this$0.project)) == null || (document = document.getText()) == null) {
                document = ConstantsKt.getPrivacyConst((String)"");
            }
            Document fileContent = document;
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((VirtualFile)node.getFile()).getName()};
            PSString pSString = ConstantsKt.getPrivacyConst((String)"-----Start of %s file content-----").format(pSStringConvertibleArray).plus(ConstantsKt.getNL()).plus((PSString)fileContent);
            pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((VirtualFile)node.getFile()).getName()};
            fileContents.add(pSString.plus(ConstantsKt.getPrivacyConst((String)"-----End of %s file content-----").format(pSStringConvertibleArray)).plus(ConstantsKt.getNL()));
        }
        Iterable $this$forEach$iv = node.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DirectoryAttachmentTreeNode child = (DirectoryAttachmentTreeNode)element$iv;
            boolean bl = false;
            DirectoryTextGenerator.getFileContents$collectFiles($maxDepth, this$0, fileContents, child);
        }
    }
}

