/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.UIPickerContextChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.testFramework.LightVirtualFile;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010*\u001a\u00020+H\u0096@\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u0006\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u0014\u0010\u001f\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00061"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/UIPickerContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "project", "Lcom/intellij/openapi/project/Project;", "uiAttachmentName", "Lcom/intellij/ml/llm/privacy/PSString;", "text", "icon", "Ljavax/swing/Icon;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Ljavax/swing/Icon;)V", "virtualFile", "Lcom/intellij/testFramework/LightVirtualFile;", "getVirtualFile", "()Lcom/intellij/testFramework/LightVirtualFile;", "virtualFile$delegate", "Lkotlin/Lazy;", "id", "", "getId", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "hint", "getHint", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "tooltipText", "getTooltipText", "popupPresentationText", "getPopupPresentationText", "getIcon", "attachedBy", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentSource;", "getAttachedBy", "()Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentSource;", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "intellij.ml.llm.chat"})
public final class UIPickerContextAttachment
extends ContextAttachmentBase {
    @NotNull
    private final Project project;
    @NotNull
    private final PSString uiAttachmentName;
    @NotNull
    private final Lazy virtualFile$delegate;
    @NotNull
    private final String id;
    @NotNull
    private final ObservableProperty<String> name;
    @NotNull
    private final ObservableProperty<String> hint;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final ObservableProperty<Icon> icon;
    @NotNull
    private final ContextAttachmentSource attachedBy;
    @NotNull
    private final ContextEntityPrivacy privacy;

    public UIPickerContextAttachment(@NotNull Project project, @NotNull PSString uiAttachmentName, @NotNull PSString text2, @Nullable Icon icon) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uiAttachmentName, (String)"uiAttachmentName");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.project = project;
        this.uiAttachmentName = uiAttachmentName;
        this.virtualFile$delegate = LazyKt.lazy(() -> UIPickerContextAttachment.virtualFile_delegate$lambda$0(this, text2));
        this.id = (String)text2.unwrap();
        this.name = (ObservableProperty)new AtomicProperty((Object)this.uiAttachmentName.unwrap());
        this.hint = (ObservableProperty)new AtomicProperty((Object)"");
        this.tooltipText = (String)this.uiAttachmentName.unwrap();
        this.popupPresentationText = "UI";
        Icon icon2 = icon;
        if (icon2 == null) {
            Icon icon3 = AllIcons.Ide.Pipette;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Pipette");
        }
        this.icon = (ObservableProperty)new AtomicProperty((Object)icon2);
        this.attachedBy = ContextAttachmentSource.User.INSTANCE;
        this.privacy = (ContextEntityPrivacy)ContextEntityPrivacy.Unrelated.INSTANCE;
    }

    public /* synthetic */ UIPickerContextAttachment(Project project, PSString pSString, PSString pSString2, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            icon = null;
        }
        this(project, pSString, pSString2, icon);
    }

    private final LightVirtualFile getVirtualFile() {
        Lazy lazy = this.virtualFile$delegate;
        return (LightVirtualFile)lazy.getValue();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public ObservableProperty<String> getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ObservableProperty<String> getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public PSString getText() {
        Object object = ApplicationManager.getApplication().runReadAction(() -> UIPickerContextAttachment._get_text_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        return (PSString)object;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @Override
    @NotNull
    public ObservableProperty<Icon> getIcon() {
        return this.icon;
    }

    @NotNull
    public ContextAttachmentSource getAttachedBy() {
        return this.attachedBy;
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return this.privacy;
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new UIPickerContextChatAttachment(this.project, this.uiAttachmentName, this.getText(), ContextAttachmentSource.UIPickerContextAttachmentSource.INSTANCE, (Icon)this.getIcon().get());
    }

    @Override
    public void performAction(boolean isInMessage) {
        if (this.getVirtualFile().isValid()) {
            FileEditorManager.getInstance((Project)this.project).openFile((VirtualFile)this.getVirtualFile(), true);
        }
    }

    private static final LightVirtualFile virtualFile_delegate$lambda$0(UIPickerContextAttachment this$0, PSString $text) {
        return new LightVirtualFile((String)this$0.uiAttachmentName.unwrap(), (CharSequence)$text);
    }

    private static final PSString _get_text_$lambda$0(UIPickerContextAttachment this$0) {
        Document document = VirtualFileUtil.findDocument((VirtualFile)((VirtualFile)this$0.getVirtualFile()));
        if (document == null || (document = ExtensionsKtKt.privacySafe((Document)document, (Project)this$0.project)) == null || (document = document.getText()) == null) {
            document = ConstantsKt.getEMPTY();
        }
        return document;
    }
}

