/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.popup;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.context.ChatContextMigrationService;
import com.intellij.ml.llm.core.chat.context.ChatDefaultRetrievers;
import com.intellij.ml.llm.core.chat.context.UserInputContextService;
import com.intellij.ml.llm.core.chat.ui.chat.context.AIChatContextViewModel;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.CurrentFileContextAttachment;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010(\u001a\u00020)H\u0096@\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020,2\u0006\u00100\u001a\u000201H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\u000f\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0011R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u00062"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/popup/CurrentFilePopupPlaceholderAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "hint", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "Lcom/intellij/openapi/util/NlsSafe;", "getHint", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "tooltipText", "getTooltipText", "()Ljava/lang/String;", "id", "getId", "popupPresentationText", "getPopupPresentationText", "icon", "Ljavax/swing/Icon;", "getIcon", "attachedBy", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentSource$Other;", "getAttachedBy", "()Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentSource$Other;", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "onChosen", "model", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/AIChatContextViewModel;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\npopupAttachmentElements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 popupAttachmentElements.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/popup/CurrentFilePopupPlaceholderAttachment\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,244:1\n30#2,2:245\n*S KotlinDebug\n*F\n+ 1 popupAttachmentElements.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/popup/CurrentFilePopupPlaceholderAttachment\n*L\n90#1:245,2\n*E\n"})
public final class CurrentFilePopupPlaceholderAttachment
extends ContextAttachmentBase {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final AtomicProperty<String> name;
    @Nullable
    private final ObservableProperty<String> hint;
    @NotNull
    private final PSString text;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String id;
    @NotNull
    private final ObservableProperty<Icon> icon;
    @NotNull
    private final ContextAttachmentSource.Other attachedBy;

    public CurrentFilePopupPlaceholderAttachment(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.name = new AtomicProperty((Object)"");
        this.text = ConstantsKt.getPrivacyConst((String)"");
        this.tooltipText = "";
        this.id = "javaClass";
        Icon icon = this.file.getFileType().getIcon();
        if (icon == null) {
            Icon icon2 = AllIcons.FileTypes.Unknown;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Unknown");
        }
        this.icon = (ObservableProperty)new AtomicProperty((Object)icon);
        this.attachedBy = ContextAttachmentSource.Other.INSTANCE;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public AtomicProperty<String> getName() {
        return this.name;
    }

    @Override
    @Nullable
    public ObservableProperty<String> getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.text;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return LLMBundle.message((String)"popup.add.context.current.file.text", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public ObservableProperty<Icon> getIcon() {
        return this.icon;
    }

    @NotNull
    public ContextAttachmentSource.Other getAttachedBy() {
        return this.attachedBy;
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return (ContextEntityPrivacy)new ContextEntityPrivacy.FileRelated(this.file);
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void performAction(boolean isInMessage) {
    }

    @Override
    public void onChosen(@NotNull AIChatContextViewModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (!ChatContextMigrationService.Companion.isRetrieverDisabled(ChatDefaultRetrievers.CurrentFile.getId())) {
            ComponentManager $this$service$iv = (ComponentManager)model.getProject();
            boolean $i$f$service = false;
            Class<UserInputContextService> serviceClass$iv = UserInputContextService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            UserInputContextService service = (UserInputContextService)object;
            model.getManuallyExcludedContextProcessor$intellij_ml_llm_chat().includeItem("CURRENT_FILE");
            service.registerCurrentFileRetriever$intellij_ml_llm_chat(model.getChatSession$intellij_ml_llm_chat());
            service.registerCurrentFileRanker$intellij_ml_llm_chat(model.getChatSession$intellij_ml_llm_chat());
        } else {
            CurrentFileContextAttachment item = new CurrentFileContextAttachment(model.getProject(), this.file, null, 4, null);
            model.addContextItem(item);
        }
    }
}

