/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.errorExplanation.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.ml.llm.errorExplanation.filters.DoNothingPostprocessor;
import com.intellij.ml.llm.errorExplanation.filters.ErrorExplainButtonItem;
import com.intellij.ml.llm.errorExplanation.filters.ExceptionRange;
import com.intellij.ml.llm.errorExplanation.filters.ExceptionRangePostprocessor;
import com.intellij.ml.llm.errorExplanation.filters.RuntimeErrorExplainButtonItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0002,-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0015J\u0006\u0010!\u001a\u00020\u001bJ\b\u0010\"\u001a\u00020#H\u0016J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0015H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0015H\u0016J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0015H\u0016J\u0018\u0010*\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0015H\u0016J\u0018\u0010+\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006."}, d2={"Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter;", "Lcom/intellij/execution/filters/Filter;", "<init>", "()V", "disabled", "", "currentState", "Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter$State;", "getCurrentState", "()Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter$State;", "setCurrentState", "(Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter$State;)V", "results", "", "Lcom/intellij/ml/llm/errorExplanation/filters/ExceptionRange;", "getResults", "()Ljava/util/List;", "isErrorBegin", "line", "", "entireLength", "", "isErrorEnd", "detectEvents", "", "Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter$Event;", "onBegin", "", "beginOffset", "onEnd", "endOffset", "process", "entireOffset", "disable", "getPostprocessor", "Lcom/intellij/ml/llm/errorExplanation/filters/ExceptionRangePostprocessor;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "getErrorExplainButtonItem", "Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainButtonItem;", "inlayPosition", "calcExceptionStartOffset", "calcInlayPosition", "calcExceptionEndOffset", "State", "Event", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nLLMExplainFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMExplainFilter.kt\ncom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1563#2:139\n1634#2,3:140\n1761#2,3:143\n*S KotlinDebug\n*F\n+ 1 LLMExplainFilter.kt\ncom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter\n*L\n81#1:139\n81#1:140,3\n102#1:143,3\n*E\n"})
public abstract class ErrorExplainFilter
implements Filter {
    private boolean disabled;
    @NotNull
    private State currentState = State.NO_EXCEPTION;
    @NotNull
    private final List<ExceptionRange> results = new ArrayList();

    @NotNull
    public final State getCurrentState() {
        return this.currentState;
    }

    public final void setCurrentState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.currentState = state;
    }

    @NotNull
    public final List<ExceptionRange> getResults() {
        return this.results;
    }

    public abstract boolean isErrorBegin(@NotNull String var1, int var2);

    public boolean isErrorEnd(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return false;
    }

    private final List<Event> detectEvents(String line, int entireLength) {
        List result2 = new ArrayList();
        if (this.isErrorBegin(line, entireLength)) {
            result2.add(Event.EXCEPTION_BEGIN);
        }
        if (this.isErrorEnd(line, entireLength)) {
            result2.add(Event.EXCEPTION_END);
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    private final void onBegin(int beginOffset) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentState.ordinal()]) {
            case 1: {
                this.results.add(new ExceptionRange(beginOffset, null));
                this.currentState = State.COLLECTING;
                break;
            }
            case 2: {
                ExceptionRange exceptionRange = this.results.removeLast();
                Intrinsics.checkNotNullExpressionValue((Object)exceptionRange, (String)"removeLast(...)");
                ExceptionRange lastExceptionRange = exceptionRange;
                this.results.add(new ExceptionRange(lastExceptionRange.getStartOffset(), beginOffset - 1));
                this.results.add(new ExceptionRange(beginOffset, null));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void onEnd(int endOffset) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentState.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                ExceptionRange exceptionRange = this.results.removeLast();
                Intrinsics.checkNotNullExpressionValue((Object)exceptionRange, (String)"removeLast(...)");
                ExceptionRange lastExceptionRange = exceptionRange;
                this.results.add(new ExceptionRange(lastExceptionRange.getStartOffset(), endOffset));
                this.currentState = State.NO_EXCEPTION;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Event> process(@NotNull String line, int entireOffset) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        List<Event> events = this.detectEvents(line, entireOffset);
        Iterable $this$map$iv = events;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Event event = (Event)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$1[it.ordinal()]) {
                case 1: {
                    this.onBegin(this.calcExceptionStartOffset(line, entireOffset));
                    break;
                }
                case 2: {
                    this.onEnd(this.calcExceptionEndOffset(line, entireOffset));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return events;
    }

    public final void disable() {
        this.disabled = true;
    }

    @NotNull
    public ExceptionRangePostprocessor getPostprocessor() {
        return new DoNothingPostprocessor();
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireOffset) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (this.disabled) {
                return null;
            }
            Iterable $this$any$iv = this.process(line, entireOffset);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Event it = (Event)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(it == Event.EXCEPTION_BEGIN)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            int inlayPosition = this.calcInlayPosition(line, entireOffset);
            ErrorExplainButtonItem result2 = this.getErrorExplainButtonItem(inlayPosition);
            Object[] objectArray = new Filter.ResultItem[]{result2, new Filter.ResultItem(0, 0, null)};
            return new Filter.Result(CollectionsKt.mutableListOf((Object[])objectArray));
        }
        return null;
    }

    @NotNull
    public ErrorExplainButtonItem getErrorExplainButtonItem(int inlayPosition) {
        return new RuntimeErrorExplainButtonItem(inlayPosition, this.results, this.results.size() - 1, this.getPostprocessor());
    }

    public int calcExceptionStartOffset(@NotNull String line, int entireOffset) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return entireOffset - line.length();
    }

    public int calcInlayPosition(@NotNull String line, int entireOffset) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return Math.max(entireOffset - 1, 0);
    }

    public int calcExceptionEndOffset(@NotNull String line, int entireOffset) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return Math.max(entireOffset - 1, 0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter$Event;", "", "<init>", "(Ljava/lang/String;I)V", "EXCEPTION_BEGIN", "EXCEPTION_END", "intellij.ml.llm.chat"})
    public static final class Event
    extends Enum<Event> {
        public static final /* enum */ Event EXCEPTION_BEGIN = new Event();
        public static final /* enum */ Event EXCEPTION_END = new Event();
        private static final /* synthetic */ Event[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Event[] values() {
            return (Event[])$VALUES.clone();
        }

        public static Event valueOf(String value) {
            return Enum.valueOf(Event.class, value);
        }

        @NotNull
        public static EnumEntries<Event> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = eventArray = new Event[]{Event.EXCEPTION_BEGIN, Event.EXCEPTION_END};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter$State;", "", "<init>", "(Ljava/lang/String;I)V", "NO_EXCEPTION", "COLLECTING", "intellij.ml.llm.chat"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NO_EXCEPTION = new State();
        public static final /* enum */ State COLLECTING = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.NO_EXCEPTION, State.COLLECTING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.NO_EXCEPTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.COLLECTING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Event.values().length];
            try {
                nArray[Event.EXCEPTION_BEGIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Event.EXCEPTION_END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

