/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.intentions.chat;

import com.intellij.ml.llm.core.chat.context.UtilsKt;
import com.intellij.ml.llm.intentions.chat.ChatIntentionTarget;
import com.intellij.ml.llm.intentions.chat.ChatIntentionTargetKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.KotlinUtils;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u00118WX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00178WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00118G\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0011\u0010\u001c\u001a\u00020\u00118G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0015\u00a8\u0006)"}, d2={"Lcom/intellij/ml/llm/intentions/chat/SelectionTarget;", "Lcom/intellij/ml/llm/intentions/chat/ChatIntentionTarget;", "file", "Lcom/intellij/psi/PsiFile;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "selectedElement", "Lcom/intellij/psi/PsiElement;", "getSelectedElement$annotations", "()V", "getSelectedElement", "()Lcom/intellij/psi/PsiElement;", "selectedElements", "", "getSelectedElements", "()Ljava/util/List;", "startElement", "getStartElement", "endElement", "getEndElement", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.chat"})
public final class SelectionTarget
implements ChatIntentionTarget {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final TextRange textRange;

    public SelectionTarget(@NotNull PsiFile file, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        this.file = file;
        this.textRange = textRange;
    }

    @Override
    @NotNull
    public PsiFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        return this.textRange;
    }

    @Override
    @RequiresReadLock
    @NotNull
    public PSString getText() {
        TextRange textRange = this.getTextRange();
        PSString pSString = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)((PsiNamedElement)this.getFile())).getText();
        Intrinsics.checkNotNull((Object)pSString);
        return ChatIntentionTargetKt.indentedTrimmedSubstring(textRange, pSString);
    }

    @Override
    @RequiresReadLock
    @NotNull
    public PsiElement getSelectedElement() {
        PsiElement start2 = this.getStartElement();
        PsiElement psiElement = PsiTreeUtil.findCommonParent((PsiElement)start2, (PsiElement)this.getEndElement());
        if (psiElement == null) {
            PsiFile psiFile = start2.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            psiElement = (PsiElement)psiFile;
        }
        return psiElement;
    }

    @Deprecated(message="Use selectedElements instead", replaceWith=@ReplaceWith(expression="selectedElements", imports={}))
    public static /* synthetic */ void getSelectedElement$annotations() {
    }

    @Override
    @RequiresReadLock
    @NotNull
    public List<PsiElement> getSelectedElements() {
        PsiElement start2 = this.getStartElement();
        PsiElement end = this.getEndElement();
        return start2 == end ? CollectionsKt.listOf((Object)start2) : (start2.getParent() != end.getParent() ? CollectionsKt.listOf((Object)this.getSelectedElement()) : SequencesKt.toList((Sequence)KotlinUtils.takeWhileInclusive((Sequence)PsiTreeUtilKt.siblings((PsiElement)start2, (boolean)true, (boolean)true), arg_0 -> SelectionTarget._get_selectedElements_$lambda$0(end, arg_0))));
    }

    @RequiresReadLock
    @NotNull
    public final PsiElement getStartElement() {
        PsiElement psiElement = PsiUtilBase.getElementAtOffset((PsiFile)this.getFile(), (int)this.getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
        return UtilsKt.topMostParentWithSameStartInFile(psiElement);
    }

    @RequiresReadLock
    @NotNull
    public final PsiElement getEndElement() {
        PsiElement psiElement = PsiUtilBase.getElementAtOffset((PsiFile)this.getFile(), (int)(this.getTextRange().getEndOffset() - 1));
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
        return UtilsKt.topMostParentWithSameEndInFile(psiElement);
    }

    @NotNull
    public final PsiFile component1() {
        return this.file;
    }

    @NotNull
    public final TextRange component2() {
        return this.textRange;
    }

    @NotNull
    public final SelectionTarget copy(@NotNull PsiFile file, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        return new SelectionTarget(file, textRange);
    }

    public static /* synthetic */ SelectionTarget copy$default(SelectionTarget selectionTarget, PsiFile psiFile, TextRange textRange, int n, Object object) {
        if ((n & 1) != 0) {
            psiFile = selectionTarget.file;
        }
        if ((n & 2) != 0) {
            textRange = selectionTarget.textRange;
        }
        return selectionTarget.copy(psiFile, textRange);
    }

    @NotNull
    public String toString() {
        return "SelectionTarget(file=" + this.file + ", textRange=" + this.textRange + ")";
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = result2 * 31 + this.textRange.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SelectionTarget)) {
            return false;
        }
        SelectionTarget selectionTarget = (SelectionTarget)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)selectionTarget.file)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.textRange, (Object)selectionTarget.textRange);
    }

    private static final boolean _get_selectedElements_$lambda$0(PsiElement $end, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it != $end;
    }
}

