/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.intentions.conversion;

import ai.grazie.model.cloud.exceptions.HTTPStatusException;
import ai.grazie.model.llm.chat.v5.LLMChat;
import ai.grazie.model.task.data.TaskStreamData;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.AIFirstUseKt;
import com.intellij.ml.llm.core.LLMCoroutineScope;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.core.NotificationsKt;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.clients.AiaLlmProviderClient;
import com.intellij.ml.llm.core.statistics.CommonLoggerService;
import com.intellij.ml.llm.core.statistics.CompositeStatisticsIdeActivity;
import com.intellij.ml.llm.core.statistics.FinishState;
import com.intellij.ml.llm.grazie.ErrorStateDescriptor;
import com.intellij.ml.llm.grazie.GrazieErrorUtilKt;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.CodeConvertFileLangTaskCallBuilder;
import com.intellij.ml.llm.intentions.conversion.FileConvertLanguageIntention;
import com.intellij.ml.llm.intentions.conversion.FileConvertLanguageIntention$launchConvertFileJob$1$1$1$rawResponse$1$invokeSuspend$;
import com.intellij.ml.llm.intentions.conversion.FileConvertLanguageIntentionKt;
import com.intellij.ml.llm.intentions.conversion.ResponseProcessor;
import com.intellij.ml.llm.intentions.conversion.editor.EditorTransformations;
import com.intellij.ml.llm.intentions.conversion.language.PasteConvertLanguage;
import com.intellij.ml.llm.intentions.conversion.language.PasteConvertLanguageRegistry;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.progress.ProgressReporter;
import com.intellij.platform.util.progress.StepsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.JBIterable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J$\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0016J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0096\u0002JN\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"JR\u0010$\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\"J&\u0010%\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006("}, d2={"Lcom/intellij/ml/llm/intentions/conversion/FileConvertLanguageIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "targetLanguage", "Lcom/intellij/ml/llm/intentions/conversion/language/PasteConvertLanguage;", "getTargetLanguage", "()Lcom/intellij/ml/llm/intentions/conversion/language/PasteConvertLanguage;", "getFamilyName", "", "getText", "startInWriteAction", "", "isAvailableForAllFiles", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "files", "", "Lcom/intellij/psi/PsiFile;", "isAvailable", "psiFile", "invoke", "", "launchConvertFileJob", "Lkotlinx/coroutines/Job;", "file", "activity", "Lcom/intellij/ml/llm/core/statistics/CompositeStatisticsIdeActivity;", "sourceText", "Lcom/intellij/ml/llm/privacy/PSString;", "sourceLanguage", "currentFile", "", "numFiles", "convertFile", "handleError", "cause", "", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nFileConvertLanguageIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileConvertLanguageIntention.kt\ncom/intellij/ml/llm/intentions/conversion/FileConvertLanguageIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n774#2:182\n865#2,2:183\n*S KotlinDebug\n*F\n+ 1 FileConvertLanguageIntention.kt\ncom/intellij/ml/llm/intentions/conversion/FileConvertLanguageIntention\n*L\n67#1:182\n67#1:183,2\n*E\n"})
public abstract class FileConvertLanguageIntention
implements IntentionAction {
    @NotNull
    public abstract PasteConvertLanguage getTargetLanguage();

    @NotNull
    public String getFamilyName() {
        return (String)this.getTargetLanguage().getDisplayName().unwrap();
    }

    @NotNull
    public String getText() {
        return (String)this.getTargetLanguage().getDisplayName().unwrap();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public final boolean isAvailableForAllFiles(@NotNull Project project, @Nullable Editor editor, @NotNull List<? extends PsiFile> files) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        for (PsiFile psiFile : files) {
            if (this.isAvailable(project, editor, psiFile)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (psiFile == null) {
            return false;
        }
        PasteConvertLanguage pasteConvertLanguage = PasteConvertLanguageRegistry.INSTANCE.getFileLanguage$intellij_ml_llm_chat(psiFile);
        if (pasteConvertLanguage == null) {
            return false;
        }
        PasteConvertLanguage sourceLanguage = pasteConvertLanguage;
        Set<PasteConvertLanguage> set = PasteConvertLanguageRegistry.INSTANCE.getSupportedLanguages(sourceLanguage);
        if (set != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = set;
            boolean $i$f$filter = false;
            void var9_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PasteConvertLanguage it = (PasteConvertLanguage)element$iv$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)sourceLanguage))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            bl = ((List)destination$iv$iv).contains(this.getTargetLanguage());
        } else {
            bl = false;
        }
        boolean isTargetLanguageSupported = bl;
        return isTargetLanguageSupported && AIAssistantUIUtil.INSTANCE.hasAvailableLlmProfileId(LLMPromptsKt.getCONVERSION_OF_FILE_PROMPT_ID());
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (psiFile == null || editor == null) {
            return;
        }
        PasteConvertLanguage pasteConvertLanguage = PasteConvertLanguageRegistry.INSTANCE.getFileLanguage$intellij_ml_llm_chat(psiFile);
        if (pasteConvertLanguage == null) {
            return;
        }
        PasteConvertLanguage sourceLanguage = pasteConvertLanguage;
        PSString fileText = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)((PsiNamedElement)psiFile)).getText();
        CompositeStatisticsIdeActivity activity = CommonLoggerService.Companion.getInstance().logFileConvertStarted(project, sourceLanguage, this.getTargetLanguage(), (String)fileText.unwrap());
        if (!AIFirstUseKt.prepareAiForUse((Project)project)) {
            CommonLoggerService.Companion.getInstance().logFileConvertFinished(project, activity, sourceLanguage, this.getTargetLanguage(), (String)fileText.unwrap(), "", FinishState.NOT_AUTHENTICATED, null);
            return;
        }
        FileConvertLanguageIntention.convertFile$default(this, project, editor, psiFile, activity, fileText, sourceLanguage, this.getTargetLanguage(), 0, 0, 384, null);
    }

    @NotNull
    public final Job launchConvertFileJob(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull CompositeStatisticsIdeActivity activity, @NotNull PSString sourceText, @NotNull PasteConvertLanguage sourceLanguage, @NotNull PasteConvertLanguage targetLanguage, int currentFile, int numFiles) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)sourceText, (String)"sourceText");
        Intrinsics.checkNotNullParameter((Object)sourceLanguage, (String)"sourceLanguage");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        return BuildersKt.launch$default((CoroutineScope)LLMCoroutineScope.Companion.getScope(project), (CoroutineContext)ClientId.Companion.coroutineContext(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, currentFile, numFiles, sourceLanguage, targetLanguage, sourceText, activity, file, editor, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ int $currentFile;
            final /* synthetic */ int $numFiles;
            final /* synthetic */ PasteConvertLanguage $sourceLanguage;
            final /* synthetic */ PasteConvertLanguage $targetLanguage;
            final /* synthetic */ PSString $sourceText;
            final /* synthetic */ CompositeStatisticsIdeActivity $activity;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Editor $editor;
            {
                this.$project = $project;
                this.$currentFile = $currentFile;
                this.$numFiles = $numFiles;
                this.$sourceLanguage = $sourceLanguage;
                this.$targetLanguage = $targetLanguage;
                this.$sourceText = $sourceText;
                this.$activity = $activity;
                this.$file = $file;
                this.$editor = $editor;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgress((Project)this.$project, (String)("(" + this.$currentFile + "/" + this.$numFiles + ") " + AIAssistantUIUtil.INSTANCE.getSendingRequestBackgroundTitle()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, this.$sourceLanguage, this.$targetLanguage, this.$sourceText, this.$activity, this.$file, this.$currentFile, this.$numFiles, this.$editor, null){
                            Object L$1;
                            Object L$2;
                            int I$0;
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ PasteConvertLanguage $sourceLanguage;
                            final /* synthetic */ PasteConvertLanguage $targetLanguage;
                            final /* synthetic */ PSString $sourceText;
                            final /* synthetic */ CompositeStatisticsIdeActivity $activity;
                            final /* synthetic */ PsiFile $file;
                            final /* synthetic */ int $currentFile;
                            final /* synthetic */ int $numFiles;
                            final /* synthetic */ Editor $editor;
                            {
                                this.$project = $project;
                                this.$sourceLanguage = $sourceLanguage;
                                this.$targetLanguage = $targetLanguage;
                                this.$sourceText = $sourceText;
                                this.$activity = $activity;
                                this.$file = $file;
                                this.$currentFile = $currentFile;
                                this.$numFiles = $numFiles;
                                this.$editor = $editor;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (CoroutineScope)this.L$0;
                                var14_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.L$0 = $this$withBackgroundProgress;
                                        this.label = 1;
                                        v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.psi.PsiFile ), ()Ljava/lang/Integer;)((PsiFile)this.$file), (Continuation)((Continuation)this));
                                        if (v0 == var14_3) {
                                            return var14_3;
                                        }
                                        ** GOTO lbl15
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl15:
                                        // 2 sources

                                        errorsBeforeConverting = ((Number)v0).intValue();
                                        this.L$0 = $this$withBackgroundProgress;
                                        this.I$0 = errorsBeforeConverting;
                                        this.label = 2;
                                        v1 = AiaLlmProviderClient.Companion.getClient().sendTaskRequest(this.$project, new CodeConvertFileLangTaskCallBuilder(this.$sourceLanguage.getDisplayName(), this.$targetLanguage.getDisplayName(), this.$sourceText).build(), (Continuation)this);
                                        if (v1 == var14_3) {
                                            return var14_3;
                                        }
                                        ** GOTO lbl27
                                    }
                                    case 2: {
                                        errorsBeforeConverting = this.I$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl27:
                                        // 2 sources

                                        flow = (Flow)v1;
                                        var6_8 = LLMChat.Companion;
                                        var7_9 = this.$sourceLanguage;
                                        var8_10 = this.$targetLanguage;
                                        var9_11 = this.$sourceText;
                                        $i$f$build = false;
                                        $this$invokeSuspend_u24lambda_u241 = var11_13 = new LLMChat.Builder(null, 1, null);
                                        $i$a$-build-FileConvertLanguageIntention$launchConvertFileJob$1$1$chatWithoutInstructions$1 = false;
                                        $this$invokeSuspend_u24lambda_u241.user("Source language:\n" + var7_9.getDisplayName() + "\nTarget Language:\n" + var8_10.getDisplayName() + "\nFile:\n" + var9_11);
                                        chatWithoutInstructions = var11_13.build();
                                        CommonLoggerService.Companion.getInstance().logFileConvertRequestSent(this.$targetLanguage, this.$sourceLanguage, chatWithoutInstructions, this.$activity);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withBackgroundProgress);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)flow);
                                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)chatWithoutInstructions);
                                        this.I$0 = errorsBeforeConverting;
                                        this.label = 3;
                                        v2 = StepsKt.reportProgress((CoroutineScope)$this$withBackgroundProgress, (int)5, (Function2)((Function2)new Function2<ProgressReporter, Continuation<? super Unit>, Object>(this.$currentFile, this.$numFiles, this.$targetLanguage, (Flow<? extends TaskStreamData>)flow, this.$project, this.$editor, this.$file, this.$activity, this.$sourceLanguage, this.$sourceText, errorsBeforeConverting, null){
                                            Object L$1;
                                            int label;
                                            /* synthetic */ Object L$0;
                                            final /* synthetic */ int $currentFile;
                                            final /* synthetic */ int $numFiles;
                                            final /* synthetic */ PasteConvertLanguage $targetLanguage;
                                            final /* synthetic */ Flow<TaskStreamData> $flow;
                                            final /* synthetic */ Project $project;
                                            final /* synthetic */ Editor $editor;
                                            final /* synthetic */ PsiFile $file;
                                            final /* synthetic */ CompositeStatisticsIdeActivity $activity;
                                            final /* synthetic */ PasteConvertLanguage $sourceLanguage;
                                            final /* synthetic */ PSString $sourceText;
                                            final /* synthetic */ int $errorsBeforeConverting;
                                            {
                                                this.$currentFile = $currentFile;
                                                this.$numFiles = $numFiles;
                                                this.$targetLanguage = $targetLanguage;
                                                this.$flow = $flow;
                                                this.$project = $project;
                                                this.$editor = $editor;
                                                this.$file = $file;
                                                this.$activity = $activity;
                                                this.$sourceLanguage = $sourceLanguage;
                                                this.$sourceText = $sourceText;
                                                this.$errorsBeforeConverting = $errorsBeforeConverting;
                                                super(2, $completion);
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                var2_2 = (ProgressReporter)this.L$0;
                                                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        var4_4 = new Object[]{this.$targetLanguage.getDisplayName()};
                                                        this.L$0 = it;
                                                        this.label = 1;
                                                        v0 = it.sizedStep(4, "(" + this.$currentFile + "/" + this.$numFiles + ") " + LLMBundle.message((String)"conversion.process.title.receiving", (Object[])var4_4), (Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this.$flow, null){
                                                            int label;
                                                            final /* synthetic */ Flow<TaskStreamData> $flow;
                                                            {
                                                                this.$flow = $flow;
                                                                super(2, $completion);
                                                            }

                                                            /*
                                                             * Unable to fully structure code
                                                             * Could not resolve type clashes
                                                             */
                                                            public final Object invokeSuspend(Object $result) {
                                                                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                switch (this.label) {
                                                                    case 0: {
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        v0 /* !! */  = this.$flow;
                                                                        if (v0 /* !! */  == null) ** GOTO lbl23
                                                                        $this$map$iv /* !! */  = v0 /* !! */ ;
                                                                        $i$f$map = false;
                                                                        $this$unsafeTransform$iv$iv /* !! */  = $this$map$iv /* !! */ ;
                                                                        $i$f$unsafeTransform = false;
                                                                        $i$f$unsafeFlow = false;
                                                                        this.label = 1;
                                                                        v1 = FlowKt.toList$default((Flow)((Flow)new Flow<String>($this$unsafeTransform$iv$iv /* !! */ ){
                                                                            final /* synthetic */ Flow $this_unsafeTransform$inlined;
                                                                            {
                                                                                this.$this_unsafeTransform$inlined = flow;
                                                                            }

                                                                            public Object collect(FlowCollector collector, Continuation $completion) {
                                                                                Continuation continuation = $completion;
                                                                                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                                                                                boolean bl = false;
                                                                                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                                                                                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                                                                                    {
                                                                                        this.$this_unsafeFlow = $receiver;
                                                                                    }

                                                                                    /*
                                                                                     * Unable to fully structure code
                                                                                     */
                                                                                    public final Object emit(Object value, Continuation $completion) {
                                                                                        if (!($completion instanceof launchConvertFileJob$1$1$1$rawResponse$1$invokeSuspend$$inlined$map$1$2$1)) ** GOTO lbl-1000
                                                                                        var3_3 = $completion;
                                                                                        if ((var3_3.label & -2147483648) != 0) {
                                                                                            var3_3.label -= -2147483648;
                                                                                        } else lbl-1000:
                                                                                        // 2 sources

                                                                                        {
                                                                                            $continuation = new ContinuationImpl(this, $completion){
                                                                                                /* synthetic */ Object result;
                                                                                                int label;
                                                                                                Object L$0;
                                                                                                final /* synthetic */ launchConvertFileJob$1$1$1$rawResponse$1$invokeSuspend$$inlined$map$1$2 this$0;
                                                                                                Object L$1;
                                                                                                Object L$2;
                                                                                                Object L$3;
                                                                                                int I$0;
                                                                                                {
                                                                                                    this.this$0 = this$0;
                                                                                                    super($completion);
                                                                                                }

                                                                                                public final Object invokeSuspend(Object $result) {
                                                                                                    this.result = $result;
                                                                                                    this.label |= Integer.MIN_VALUE;
                                                                                                    return this.this$0.emit(null, (Continuation)this);
                                                                                                }
                                                                                            };
                                                                                        }
                                                                                        $result = $continuation.result;
                                                                                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                                        switch ($continuation.label) {
                                                                                            case 0: {
                                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                                var6_6 = $continuation;
                                                                                                var7_8 = value;
                                                                                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                                                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = 0;
                                                                                                var10_14 = $this$map_u24lambda_u245;
                                                                                                var11_15 = (Continuation)$continuation;
                                                                                                data = (TaskStreamData)value;
                                                                                                $i$a$-map-FileConvertLanguageIntention$launchConvertFileJob$1$1$1$rawResponse$1$1 = false;
                                                                                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                                                                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                                                                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                                                                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map_u24lambda_u245);
                                                                                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$map$1;
                                                                                                $continuation.label = 1;
                                                                                                v0 = var10_14.emit((Object)data.getContent(), (Continuation)$continuation);
                                                                                                if (v0 == var5_5) {
                                                                                                    return var5_5;
                                                                                                }
                                                                                                ** GOTO lbl38
                                                                                            }
                                                                                            case 1: {
                                                                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = $continuation.I$0;
                                                                                                $this$map_u24lambda_u245 = (FlowCollector)$continuation.L$3;
                                                                                                value = $continuation.L$2;
                                                                                                $completion = $continuation.L$1;
                                                                                                value = $continuation.L$0;
                                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                                v0 = $result;
lbl38:
                                                                                                // 2 sources

                                                                                                return Unit.INSTANCE;
                                                                                            }
                                                                                        }
                                                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                                    }
                                                                                }, $completion);
                                                                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                                                    return object;
                                                                                }
                                                                                return Unit.INSTANCE;
                                                                            }
                                                                        }), null, (Continuation)((Continuation)this), (int)1, null);
                                                                        if (v1 == var7_2) {
                                                                            return var7_2;
                                                                        }
                                                                        ** GOTO lbl22
                                                                    }
                                                                    case 1: {
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        v1 = $result;
lbl22:
                                                                        // 2 sources

                                                                        if ((v0 /* !! */  = (List)v1) != null && (v0 /* !! */  = CollectionsKt.joinToString$default((Iterable)((Iterable)v0 /* !! */ ), (CharSequence)"", null, null, (int)0, null, null, (int)62, null)) != null) ** GOTO lbl24
lbl23:
                                                                        // 2 sources

                                                                        v0 /* !! */  = "";
lbl24:
                                                                        // 2 sources

                                                                        return v0 /* !! */ ;
                                                                    }
                                                                }
                                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                            }

                                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                            }

                                                            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                            }
                                                        }, (Continuation)this);
                                                        if (v0 == var5_3) {
                                                            return var5_3;
                                                        }
                                                        ** GOTO lbl16
                                                    }
                                                    case 1: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v0 = $result;
lbl16:
                                                        // 2 sources

                                                        rawResponse = (String)v0;
                                                        var4_4 = new Object[]{this.$targetLanguage.getDisplayName()};
                                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)rawResponse);
                                                        this.label = 2;
                                                        v1 = it.itemStep("(" + this.$currentFile + "/" + this.$numFiles + ") " + LLMBundle.message((String)"conversion.process", (Object[])var4_4), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(rawResponse, this.$targetLanguage, this.$project, this.$editor, this.$file, this.$activity, this.$sourceLanguage, this.$sourceText, this.$errorsBeforeConverting, null){
                                                            Object L$0;
                                                            Object L$1;
                                                            Object L$2;
                                                            int label;
                                                            final /* synthetic */ String $rawResponse;
                                                            final /* synthetic */ PasteConvertLanguage $targetLanguage;
                                                            final /* synthetic */ Project $project;
                                                            final /* synthetic */ Editor $editor;
                                                            final /* synthetic */ PsiFile $file;
                                                            final /* synthetic */ CompositeStatisticsIdeActivity $activity;
                                                            final /* synthetic */ PasteConvertLanguage $sourceLanguage;
                                                            final /* synthetic */ PSString $sourceText;
                                                            final /* synthetic */ int $errorsBeforeConverting;
                                                            {
                                                                this.$rawResponse = $rawResponse;
                                                                this.$targetLanguage = $targetLanguage;
                                                                this.$project = $project;
                                                                this.$editor = $editor;
                                                                this.$file = $file;
                                                                this.$activity = $activity;
                                                                this.$sourceLanguage = $sourceLanguage;
                                                                this.$sourceText = $sourceText;
                                                                this.$errorsBeforeConverting = $errorsBeforeConverting;
                                                                super(2, $completion);
                                                            }

                                                            /*
                                                             * Unable to fully structure code
                                                             * Could not resolve type clashes
                                                             */
                                                            public final Object invokeSuspend(Object $result) {
                                                                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                switch (this.label) {
                                                                    case 0: {
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        response = new ResponseProcessor().extractCodeFromResponse(this.$rawResponse);
                                                                        v0 /* !! */  = Language.findLanguageByID((String)this.$targetLanguage.getIdeaId());
                                                                        if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getAssociatedFileType()) == null || (v0 /* !! */  = v0 /* !! */ .getDefaultExtension()) == null) {
                                                                            v0 /* !! */  = this.$targetLanguage.getDefaultExtension();
                                                                        }
                                                                        newExtension = v0 /* !! */ ;
                                                                        v1 = new EditorTransformations(this.$project, this.$editor);
                                                                        v2 = this.$file.getVirtualFile().getNameWithoutExtension();
                                                                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getNameWithoutExtension(...)");
                                                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)response);
                                                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)newExtension);
                                                                        this.label = 1;
                                                                        v3 = v1.applyFileConversion(response, v2, newExtension, this.$file, (Continuation<? super PsiFile>)((Continuation)this));
                                                                        if (v3 == var6_2) {
                                                                            return var6_2;
                                                                        }
                                                                        ** GOTO lbl25
                                                                    }
                                                                    case 1: {
                                                                        newExtension = (String)this.L$1;
                                                                        response = (String)this.L$0;
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        v3 = $result;
lbl25:
                                                                        // 2 sources

                                                                        transformedFile = (PsiFile)v3;
                                                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)response);
                                                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)newExtension);
                                                                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)transformedFile);
                                                                        this.label = 2;
                                                                        v4 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.psi.PsiFile ), ()Ljava/lang/Integer;)((PsiFile)transformedFile), (Continuation)((Continuation)this));
                                                                        if (v4 == var6_2) {
                                                                            return var6_2;
                                                                        }
                                                                        ** GOTO lbl40
                                                                    }
                                                                    case 2: {
                                                                        transformedFile = (PsiFile)this.L$2;
                                                                        newExtension = (String)this.L$1;
                                                                        response = (String)this.L$0;
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        v4 = $result;
lbl40:
                                                                        // 2 sources

                                                                        errors = ((Number)v4).intValue();
                                                                        CommonLoggerService.Companion.getInstance().logFileConvertFinished(this.$project, this.$activity, this.$targetLanguage, this.$sourceLanguage, (String)this.$sourceText.unwrap(), this.$rawResponse, FinishState.SUCCEED, Boxing.boxInt((int)(errors - this.$errorsBeforeConverting)));
                                                                        return Unit.INSTANCE;
                                                                    }
                                                                }
                                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                            }

                                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                            }

                                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                            }

                                                            private static final int invokeSuspend$lambda$0(PsiFile $transformedFile) {
                                                                JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)$transformedFile)).traverse().filter(arg_0 -> launchConvertFileJob.1.invokeSuspend$lambda$0$1(launchConvertFileJob.1::invokeSuspend$lambda$0$0, arg_0));
                                                                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                                                                return CollectionsKt.count((Iterable)((Iterable)jBIterable));
                                                            }

                                                            private static final boolean invokeSuspend$lambda$0$0(PsiElement it) {
                                                                return it instanceof PsiErrorElement;
                                                            }

                                                            private static final boolean invokeSuspend$lambda$0$1(Function1 $tmp0, Object p0) {
                                                                return (Boolean)$tmp0.invoke(p0);
                                                            }
                                                        }, (Continuation)this);
                                                        if (v1 == var5_3) {
                                                            return var5_3;
                                                        }
                                                        ** GOTO lbl29
                                                    }
                                                    case 2: {
                                                        rawResponse = (String)this.L$1;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v1 = $result;
lbl29:
                                                        // 2 sources

                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                var3_3.L$0 = value;
                                                return (Continuation)var3_3;
                                            }

                                            public final Object invoke(ProgressReporter p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v2 == var14_3) {
                                            return var14_3;
                                        }
                                        ** GOTO lbl55
                                    }
                                    case 3: {
                                        errorsBeforeConverting = this.I$0;
                                        chatWithoutInstructions = (LLMChat)this.L$2;
                                        flow = (Flow)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl55:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final int invokeSuspend$lambda$0(PsiFile $file) {
                                JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)$file)).traverse().filter(arg_0 -> launchConvertFileJob.1.invokeSuspend$lambda$0$1(launchConvertFileJob.1::invokeSuspend$lambda$0$0, arg_0));
                                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                                return CollectionsKt.count((Iterable)((Iterable)jBIterable));
                            }

                            private static final boolean invokeSuspend$lambda$0$0(PsiElement it) {
                                return it instanceof PsiErrorElement;
                            }

                            private static final boolean invokeSuspend$lambda$0$1(Function1 $tmp0, Object p0) {
                                return (Boolean)$tmp0.invoke(p0);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void convertFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull CompositeStatisticsIdeActivity activity, @NotNull PSString sourceText, @NotNull PasteConvertLanguage sourceLanguage, @NotNull PasteConvertLanguage targetLanguage, int currentFile, int numFiles) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)sourceText, (String)"sourceText");
        Intrinsics.checkNotNullParameter((Object)sourceLanguage, (String)"sourceLanguage");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        this.launchConvertFileJob(project, editor, file, activity, sourceText, sourceLanguage, targetLanguage, currentFile, numFiles).invokeOnCompletion(true, true, arg_0 -> FileConvertLanguageIntention.convertFile$lambda$0(project, activity, targetLanguage, sourceLanguage, sourceText, this, editor, file, arg_0));
    }

    public static /* synthetic */ void convertFile$default(FileConvertLanguageIntention fileConvertLanguageIntention, Project project, Editor editor, PsiFile psiFile, CompositeStatisticsIdeActivity compositeStatisticsIdeActivity, PSString pSString, PasteConvertLanguage pasteConvertLanguage, PasteConvertLanguage pasteConvertLanguage2, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: convertFile");
        }
        if ((n3 & 0x80) != 0) {
            n = 1;
        }
        if ((n3 & 0x100) != 0) {
            n2 = 1;
        }
        fileConvertLanguageIntention.convertFile(project, editor, psiFile, compositeStatisticsIdeActivity, pSString, pasteConvertLanguage, pasteConvertLanguage2, n, n2);
    }

    public final void handleError(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        ErrorStateDescriptor errorStateDescriptor = GrazieErrorUtilKt.getErrorDescriptor((Throwable)cause);
        if (errorStateDescriptor != null) {
            if (cause instanceof HTTPStatusException.ContentTooLarge) {
                NotificationsKt.showErrorNotification((Project)project, (ErrorStateDescriptor)((ErrorStateDescriptor)new ErrorStateDescriptor.Informative(LLMBundle.message((String)"file.convert.file.too.large", (Object[])new Object[0]), null, 2, null)), (Editor)editor, (String)"", null);
            } else {
                NotificationsKt.showErrorNotification((Project)project, (ErrorStateDescriptor)errorStateDescriptor, (Editor)editor, (String)"", arg_0 -> FileConvertLanguageIntention.handleError$lambda$0(project, this, editor, file, arg_0));
            }
        } else {
            FileConvertLanguageIntentionKt.access$getLogger$p().error(cause);
        }
    }

    private static final Unit convertFile$lambda$0(Project $project, CompositeStatisticsIdeActivity $activity, PasteConvertLanguage $targetLanguage, PasteConvertLanguage $sourceLanguage, PSString $sourceText, FileConvertLanguageIntention this$0, Editor $editor, PsiFile $file, Throwable cause) {
        if (cause instanceof CancellationException) {
            CommonLoggerService.Companion.getInstance().logFileConvertFinished($project, $activity, $targetLanguage, $sourceLanguage, (String)$sourceText.unwrap(), "", FinishState.CANCEL, null);
        } else if (cause != null) {
            CommonLoggerService.Companion.getInstance().logFileConvertFinished($project, $activity, $targetLanguage, $sourceLanguage, (String)$sourceText.unwrap(), "", FinishState.ERROR, null);
            this$0.handleError($project, $editor, $file, cause);
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleError$lambda$0(Project $project, FileConvertLanguageIntention this$0, Editor $editor, PsiFile $file, Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"<unused var>");
        BuildersKt.launch$default((CoroutineScope)LLMCoroutineScope.Companion.getScope($project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $project, $editor, $file, null){
            int label;
            final /* synthetic */ FileConvertLanguageIntention this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PsiFile $file;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$editor = $editor;
                this.$file = $file;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.invoke(this.$project, this.$editor, this.$file);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }
}

