/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.api;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.DataRowKt;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.FilterKt;
import org.jetbrains.kotlinx.dataframe.api.FirstKt;
import org.jetbrains.kotlinx.dataframe.api.TakeKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumnKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aI\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012+\u0010\u0003\u001a'\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0004j\b\u0012\u0004\u0012\u0002H\u0002`\t\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a&\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\r\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\u001a&\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\r\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a`\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\r\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\r2B\u0010\u0003\u001a>\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u000f\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00020\u000f\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u000ej\b\u0012\u0004\u0012\u0002H\u0002`\u0011\u00a2\u0006\u0002\b\u0010\u001a`\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\r\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\r2B\u0010\u0003\u001a>\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u000f\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00020\u000f\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u000ej\b\u0012\u0004\u0012\u0002H\u0002`\u0011\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0013"}, d2={"drop", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "T", "predicate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "it", "", "Lorg/jetbrains/kotlinx/dataframe/Predicate;", "n", "", "dropLast", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/RowFilter;", "dropWhile", "core"})
@SourceDebugExtension(value={"SMAP\ndrop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 drop.kt\norg/jetbrains/kotlinx/dataframe/api/DropKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,378:1\n1#2:379\n*E\n"})
public final class DropKt {
    @NotNull
    public static final <T> DataColumn<T> drop(@NotNull DataColumn<? extends T> $this$drop, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$drop, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return FilterKt.filter($this$drop, arg_0 -> DropKt.drop$lambda$0(predicate, arg_0));
    }

    @NotNull
    public static final <T> DataColumn<T> drop(@NotNull DataColumn<? extends T> $this$drop, int n) {
        Intrinsics.checkNotNullParameter($this$drop, (String)"<this>");
        return n == 0 ? $this$drop : (n >= BaseColumnKt.getSize((BaseColumn)$this$drop) ? $this$drop.get(CollectionsKt.emptyList()) : $this$drop.get(RangesKt.until((int)n, (int)BaseColumnKt.getSize((BaseColumn)$this$drop))));
    }

    @NotNull
    public static final <T> DataColumn<T> dropLast(@NotNull DataColumn<? extends T> $this$dropLast, int n) {
        Intrinsics.checkNotNullParameter($this$dropLast, (String)"<this>");
        return TakeKt.take($this$dropLast, BaseColumnKt.getSize((BaseColumn)$this$dropLast) - n);
    }

    public static /* synthetic */ DataColumn dropLast$default(DataColumn dataColumn, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return DropKt.dropLast(dataColumn, n);
    }

    @NotNull
    public static final <T> DataFrame<T> drop(@NotNull DataFrame<? extends T> $this$drop, int n) {
        Intrinsics.checkNotNullParameter($this$drop, (String)"<this>");
        if (!(n >= 0)) {
            boolean bl = false;
            String string = "Requested rows count " + n + " is less than zero.";
            throw new IllegalArgumentException(string.toString());
        }
        return DataFrameGetKt.getRows($this$drop, RangesKt.until((int)RangesKt.coerceAtMost((int)n, (int)DataFrameKt.getNrow($this$drop)), (int)DataFrameKt.getNrow($this$drop)));
    }

    @NotNull
    public static final <T> DataFrame<T> dropLast(@NotNull DataFrame<? extends T> $this$dropLast, int n) {
        Intrinsics.checkNotNullParameter($this$dropLast, (String)"<this>");
        if (!(n >= 0)) {
            boolean bl = false;
            String string = "Requested rows count " + n + " is less than zero.";
            throw new IllegalArgumentException(string.toString());
        }
        return TakeKt.take($this$dropLast, RangesKt.coerceAtLeast((int)(DataFrameKt.getNrow($this$dropLast) - n), (int)0));
    }

    public static /* synthetic */ DataFrame dropLast$default(DataFrame dataFrame, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return DropKt.dropLast(dataFrame, n);
    }

    @NotNull
    public static final <T> DataFrame<T> drop(@NotNull DataFrame<? extends T> $this$drop, @NotNull Function2<? super DataRow<? extends T>, ? super DataRow<? extends T>, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$drop, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return FilterKt.filter($this$drop, (arg_0, arg_1) -> DropKt.drop$lambda$3(predicate, arg_0, arg_1));
    }

    @NotNull
    public static final <T> DataFrame<T> dropWhile(@NotNull DataFrame<? extends T> $this$dropWhile, @NotNull Function2<? super DataRow<? extends T>, ? super DataRow<? extends T>, Boolean> predicate) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$dropWhile, (String)"<this>");
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                object = FirstKt.firstOrNull($this$dropWhile, (arg_0, arg_1) -> DropKt.dropWhile$lambda$4(predicate, arg_0, arg_1));
                if (object == null) break block2;
                DataRow<? extends T> it = object;
                boolean bl = false;
                DataFrame<? extends T> dataFrame = DropKt.drop($this$dropWhile, DataRowKt.getIndex(it));
                object = dataFrame;
                if (dataFrame != null) break block3;
            }
            object = $this$dropWhile;
        }
        return object;
    }

    private static final boolean drop$lambda$0(Function1 $predicate, Object it) {
        return (Boolean)$predicate.invoke(it) == false;
    }

    private static final boolean drop$lambda$3(Function2 $predicate, DataRow $this$filter, DataRow it) {
        Intrinsics.checkNotNullParameter((Object)$this$filter, (String)"$this$filter");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)$predicate.invoke((Object)it, (Object)it) == false;
    }

    private static final boolean dropWhile$lambda$4(Function2 $predicate, DataRow $this$firstOrNull, DataRow it) {
        Intrinsics.checkNotNullParameter((Object)$this$firstOrNull, (String)"$this$firstOrNull");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)$predicate.invoke((Object)it, (Object)it) == false;
    }
}

