/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.HierarchicType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.TypeContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemberCollectionContextImpl {
    private static final Logger logger = LoggerFactory.getLogger(MemberCollectionContextImpl.class);
    private final ResolvedType schemaTargetType;
    private final SchemaGeneratorConfig generatorConfig;
    private final TypeContext typeContext;
    private final Map<String, MemberScope<?, ?>> collectedProperties = new LinkedHashMap();
    private final Set<String> requiredPropertyNames = new HashSet<String>();

    public MemberCollectionContextImpl(ResolvedType schemaTargetType, SchemaGeneratorConfig generatorConfig, TypeContext typeContext) {
        this.schemaTargetType = schemaTargetType;
        this.generatorConfig = generatorConfig;
        this.typeContext = typeContext;
    }

    public List<MemberScope<?, ?>> getSortedProperties() {
        return this.collectedProperties.values().stream().sorted(this.generatorConfig::sortProperties).collect(Collectors.toList());
    }

    public Set<String> getRequiredPropertyNames() {
        return Collections.unmodifiableSet(this.requiredPropertyNames);
    }

    public void collectProperties() {
        logger.debug("collecting non-static fields and methods from {}", (Object)this.schemaTargetType);
        ResolvedTypeWithMembers typeToCollectMembersFrom = this.typeContext.resolveWithMembers(this.schemaTargetType);
        MemberScope.DeclarationDetails declarationDetails = new MemberScope.DeclarationDetails(this.schemaTargetType, typeToCollectMembersFrom);
        this.collectFields(typeToCollectMembersFrom.getMemberFields(), declarationDetails);
        this.collectMethods(typeToCollectMembersFrom.getMemberMethods(), declarationDetails);
        if (this.generatorConfig.shouldIncludeStaticFields() || this.generatorConfig.shouldIncludeStaticMethods()) {
            for (HierarchicType singleHierarchy : typeToCollectMembersFrom.allTypesAndOverrides()) {
                this.collectStaticMembers(singleHierarchy);
            }
        }
    }

    private void collectStaticMembers(HierarchicType singleHierarchy) {
        ResolvedType hierarchyType = singleHierarchy.getType();
        logger.debug("collecting static fields and methods from {}", (Object)hierarchyType);
        ResolvedTypeWithMembers hierarchyTypeWithMembers = this.typeContext.resolveWithMembers(hierarchyType);
        MemberScope.DeclarationDetails declarationDetails = new MemberScope.DeclarationDetails(this.schemaTargetType, hierarchyTypeWithMembers);
        if (this.generatorConfig.shouldIncludeStaticFields()) {
            this.collectFields(hierarchyTypeWithMembers.getStaticFields(), declarationDetails);
        }
        if (this.generatorConfig.shouldIncludeStaticMethods()) {
            this.collectMethods(hierarchyTypeWithMembers.getStaticMethods(), declarationDetails);
        }
    }

    private void collectFields(ResolvedField[] fields, MemberScope.DeclarationDetails declarationDetails) {
        Stream.of(fields).map(declaredField -> this.typeContext.createFieldScope((ResolvedField)declaredField, declarationDetails)).map(this::getMemberWithNameOverride).filter(fieldScope -> !this.generatorConfig.shouldIgnore((FieldScope)fieldScope)).forEach(this::collect);
    }

    private void collectMethods(ResolvedMethod[] methods2, MemberScope.DeclarationDetails declarationDetails) {
        Stream.of(methods2).map(declaredMethod -> this.typeContext.createMethodScope((ResolvedMethod)declaredMethod, declarationDetails)).map(this::getMemberWithNameOverride).filter(methodScope -> !this.generatorConfig.shouldIgnore((MethodScope)methodScope)).forEach(this::collect);
    }

    public void collect(MemberScope<?, ?> member) {
        String propertyName = member.getSchemaPropertyName();
        if (member.isFakeContainerItemScope()) {
            this.collectedProperties.put(propertyName, member);
            return;
        }
        this.registerIfRequired(member);
        if (this.collectedProperties.containsKey(propertyName)) {
            logger.debug("ignoring overridden {}.{}", (Object)member.getDeclaringType(), (Object)member.getDeclaredName());
        } else {
            this.collectedProperties.put(propertyName, member);
        }
    }

    private <M extends MemberScope<?, ?>> M getMemberWithNameOverride(M member) {
        String propertyNameOverride = member.getContext().performActionOnMember(member, this.generatorConfig::resolvePropertyNameOverride, this.generatorConfig::resolvePropertyNameOverride);
        if (propertyNameOverride == null) {
            return member;
        }
        return (M)member.withOverriddenName(propertyNameOverride);
    }

    private void registerIfRequired(MemberScope<?, ?> member) {
        if (member.getContext().performActionOnMember(member, this.generatorConfig::isRequired, this.generatorConfig::isRequired).booleanValue()) {
            this.requiredPropertyNames.add(member.getSchemaPropertyName());
        }
    }
}

