/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.jackson;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.github.victools.jsonschema.generator.AnnotationHelper;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.CustomPropertyDefinition;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;

public class JsonIdentityReferenceDefinitionProvider
implements CustomDefinitionProviderV2 {
    @Override
    public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
        if (javaType == null) {
            return null;
        }
        return this.getIdentityReferenceType(javaType, context.getTypeContext()).map(context::createDefinitionReference).map(CustomDefinition::new).orElse(null);
    }

    public CustomPropertyDefinition provideCustomPropertySchemaDefinition(MemberScope<?, ?> scope, SchemaGenerationContext context) {
        return this.getIdentityReferenceType(scope).map(context::createDefinitionReference).map(CustomPropertyDefinition::new).orElse(null);
    }

    public Optional<ResolvedType> getIdentityReferenceType(ResolvedType javaType, TypeContext typeContext) {
        JsonIdentityReference referenceAnnotation = AnnotationHelper.resolveAnnotation(javaType.getErasedType(), JsonIdentityReference.class, JacksonModule.NESTED_ANNOTATION_CHECK).orElse(null);
        return this.getIdentityReferenceType(referenceAnnotation, javaType, typeContext);
    }

    public Optional<ResolvedType> getIdentityReferenceType(MemberScope<?, ?> scope) {
        JsonIdentityReference referenceAnnotation = scope.getContainerItemAnnotationConsideringFieldAndGetterIfSupported(JsonIdentityReference.class, JacksonModule.NESTED_ANNOTATION_CHECK);
        if (referenceAnnotation == null) {
            referenceAnnotation = scope.getAnnotationConsideringFieldAndGetter(JsonIdentityReference.class, JacksonModule.NESTED_ANNOTATION_CHECK);
        }
        return this.getIdentityReferenceType(referenceAnnotation, scope.getType(), scope.getContext());
    }

    private Optional<ResolvedType> getIdentityReferenceType(JsonIdentityReference referenceAnnotation, ResolvedType javaType, TypeContext typeContext) {
        if (referenceAnnotation == null || !referenceAnnotation.alwaysAsId()) {
            return Optional.empty();
        }
        ResolvedType typeWithIdentityInfoAnnotation = typeContext.getTypeWithAnnotation(javaType, JsonIdentityInfo.class, JacksonModule.NESTED_ANNOTATION_CHECK);
        if (typeWithIdentityInfoAnnotation == null) {
            return Optional.empty();
        }
        JsonIdentityInfo identityInfoAnnotation = typeContext.getAnnotationFromList(JsonIdentityInfo.class, Arrays.asList(typeWithIdentityInfoAnnotation.getErasedType().getAnnotations()), JacksonModule.NESTED_ANNOTATION_CHECK);
        ResolvedType identityTypeFromGenerator = typeContext.getTypeParameterFor(typeContext.resolve(identityInfoAnnotation.generator(), new Type[0]), ObjectIdGenerator.class, 0);
        if (identityTypeFromGenerator == null || identityTypeFromGenerator.getErasedType() == Object.class) {
            String idPropertyName = identityInfoAnnotation.property();
            ResolvedField[] eligibleFields = typeContext.resolveWithMembers(typeWithIdentityInfoAnnotation).getMemberFields();
            Optional<ResolvedType> identityTypeFromProperty = Stream.of(eligibleFields).filter(field -> field.getName().equals(idPropertyName)).map(ResolvedMember::getType).findFirst();
            if (identityTypeFromProperty.isPresent()) {
                return identityTypeFromProperty;
            }
        }
        return Optional.ofNullable(identityTypeFromGenerator);
    }
}

