/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.frontend.compose.ui.viewModels;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ml.llm.agents.frontend.compose.model.Attachment;
import com.intellij.ml.llm.agents.frontend.compose.model.ChatSessionContext;
import com.intellij.ml.llm.agents.frontend.compose.ui.components.utils.FileOperationsKt;
import com.intellij.ml.llm.agents.frontend.compose.ui.viewModels.AgentMessageBlockViewModel;
import com.intellij.ml.llm.agents.frontend.compose.ui.viewModels.ChatMessageViewModel;
import com.intellij.ml.llm.chat.shared.ChatSessionAgent;
import com.intellij.ml.llm.chat.shared.ChatSessionAgentStateChanged;
import com.intellij.ml.llm.chat.shared.ChatSessionAgentStatusChanged;
import com.intellij.ml.llm.chat.shared.ChatSessionEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionEventId;
import com.intellij.ml.llm.chat.shared.ChatSessionFailureEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionId;
import com.intellij.ml.llm.chat.shared.ChatSessionMessageBlockEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionMessageEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionPlanUpdatedEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionResponseReceived;
import com.intellij.ml.llm.chat.shared.ChatSessionRollbackEvents;
import com.intellij.ml.llm.chat.shared.ChatSessionUserPromptAttachment;
import com.intellij.ml.llm.chat.shared.ChatSessionUserPromptEvent;
import com.intellij.ml.llm.chat.shared.rpc.AIAssistantChatSessionApi;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ8\u0010\u001f\u001a\u00020\u001a*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u001a*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0002J\u0018\u0010%\u001a\u00020\u001a*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0002J(\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u000fH\u0002J\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0015H\u0002J\u001c\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u001a0+2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ml/llm/agents/frontend/compose/ui/viewModels/ChatMessageUpdatesManager;", "", "viewModelsParentScope", "Lkotlinx/coroutines/CoroutineScope;", "chatSessionContext", "Lcom/intellij/ml/llm/agents/frontend/compose/model/ChatSessionContext;", "availableAgents", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lcom/intellij/ml/llm/chat/shared/ChatSessionAgent;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/ml/llm/agents/frontend/compose/model/ChatSessionContext;Lkotlinx/coroutines/flow/StateFlow;)V", "_messageViewModels", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lkotlinx/collections/immutable/PersistentList;", "Lcom/intellij/ml/llm/agents/frontend/compose/ui/viewModels/ChatMessageViewModel;", "messageViewModels", "getMessageViewModels", "()Lkotlinx/coroutines/flow/StateFlow;", "messageViewModelByEventId", "", "Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;", "revertedViewModelToEventId", "failureMessageEventIds", "", "updateViewModels", "", "project", "Lcom/intellij/openapi/project/Project;", "chatSessionEvent", "Lcom/intellij/ml/llm/chat/shared/ChatSessionEvent;", "update", "event", "Lcom/intellij/ml/llm/chat/shared/ChatSessionMessageEvent;", "chatSessionId", "Lcom/intellij/ml/llm/chat/shared/ChatSessionId;", "removeRevertedMessages", "removeFailureMessages", "addRemembering", "eventId", "messageViewModel", "rollbackAction", "openAttachmentAction", "Lkotlin/Function1;", "Lcom/intellij/ml/llm/agents/frontend/compose/model/Attachment;", "intellij.ml.llm.agents.frontend"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChatMessageUpdatesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageUpdatesManager.kt\ncom/intellij/ml/llm/agents/frontend/compose/ui/viewModels/ChatMessageUpdatesManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,185:1\n543#2,6:186\n543#2,6:192\n1869#2,2:198\n669#2,11:202\n669#2,11:213\n1563#2:224\n1634#2,3:225\n1869#2,2:228\n827#2:233\n855#2,2:234\n1869#2,2:238\n827#2:243\n855#2,2:244\n1#3:200\n13#4:201\n230#5,3:230\n233#5,2:236\n230#5,3:240\n233#5,2:246\n*S KotlinDebug\n*F\n+ 1 ChatMessageUpdatesManager.kt\ncom/intellij/ml/llm/agents/frontend/compose/ui/viewModels/ChatMessageUpdatesManager\n*L\n54#1:186,6\n58#1:192,6\n59#1:198,2\n108#1:202,11\n112#1:213,11\n115#1:224\n115#1:225,3\n143#1:228,2\n147#1:233\n147#1:234,2\n153#1:238,2\n157#1:243\n157#1:244,2\n87#1:201\n146#1:230,3\n146#1:236,2\n156#1:240,3\n156#1:246,2\n*E\n"})
public final class ChatMessageUpdatesManager {
    @NotNull
    private final CoroutineScope viewModelsParentScope;
    @NotNull
    private final ChatSessionContext chatSessionContext;
    @NotNull
    private final StateFlow<List<ChatSessionAgent>> availableAgents;
    @NotNull
    private final MutableStateFlow<PersistentList<ChatMessageViewModel>> _messageViewModels;
    @NotNull
    private final StateFlow<PersistentList<ChatMessageViewModel>> messageViewModels;
    @NotNull
    private final Map<ChatSessionEventId, ChatMessageViewModel> messageViewModelByEventId;
    @NotNull
    private final Map<ChatMessageViewModel, ChatSessionEventId> revertedViewModelToEventId;
    @NotNull
    private final Set<ChatSessionEventId> failureMessageEventIds;
    public static final int $stable = 8;

    public ChatMessageUpdatesManager(@NotNull CoroutineScope viewModelsParentScope, @NotNull ChatSessionContext chatSessionContext, @NotNull StateFlow<? extends List<ChatSessionAgent>> availableAgents) {
        Intrinsics.checkNotNullParameter((Object)viewModelsParentScope, (String)"viewModelsParentScope");
        Intrinsics.checkNotNullParameter((Object)chatSessionContext, (String)"chatSessionContext");
        Intrinsics.checkNotNullParameter(availableAgents, (String)"availableAgents");
        this.viewModelsParentScope = viewModelsParentScope;
        this.chatSessionContext = chatSessionContext;
        this.availableAgents = availableAgents;
        this._messageViewModels = StateFlowKt.MutableStateFlow((Object)ExtensionsKt.persistentListOf());
        this.messageViewModels = FlowKt.asStateFlow(this._messageViewModels);
        this.messageViewModelByEventId = new LinkedHashMap();
        this.revertedViewModelToEventId = new LinkedHashMap();
        this.failureMessageEventIds = new LinkedHashSet();
    }

    @NotNull
    public final StateFlow<PersistentList<ChatMessageViewModel>> getMessageViewModels() {
        return this.messageViewModels;
    }

    public final void updateViewModels(@NotNull Project project, @NotNull ChatSessionEvent chatSessionEvent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chatSessionEvent, (String)"chatSessionEvent");
        ChatSessionEvent chatSessionEvent2 = chatSessionEvent;
        if (chatSessionEvent2 instanceof ChatSessionMessageEvent) {
            this.update(this._messageViewModels, project, (ChatSessionMessageEvent)chatSessionEvent, this.viewModelsParentScope, this.chatSessionContext.getSessionId());
        } else if (chatSessionEvent2 instanceof ChatSessionRollbackEvents) {
            int n;
            int eventId = ((ChatSessionRollbackEvents)chatSessionEvent).getFrom().getId();
            if (eventId <= (n = ((ChatSessionRollbackEvents)chatSessionEvent).getTo().getId())) {
                while (true) {
                    if (this.messageViewModelByEventId.get(new ChatSessionEventId(eventId)) != null) {
                        ChatMessageViewModel revertedViewModel;
                        boolean bl = false;
                        revertedViewModel.updateReverted(true);
                        this.revertedViewModelToEventId.put(revertedViewModel, new ChatSessionEventId(eventId));
                    }
                    if (eventId != n) {
                        ++eventId;
                        continue;
                    }
                    break;
                }
            }
        } else if (chatSessionEvent2 instanceof ChatSessionResponseReceived) {
            StateFlow<List<AgentMessageBlockViewModel<?>>> lastAgentMessage;
            Object object;
            Object var6_15;
            block18: {
                Object v2;
                ChatMessageViewModel.PromptViewModel lastPrompt;
                Object v0;
                block17: {
                    List $this$lastOrNull$iv = (List)this._messageViewModels.getValue();
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        ChatMessageViewModel it = (ChatMessageViewModel)element$iv;
                        boolean bl = false;
                        if (!(it instanceof ChatMessageViewModel.PromptViewModel)) continue;
                        v0 = element$iv;
                        break block17;
                    }
                    v0 = null;
                }
                Object var5_7 = v0;
                ChatMessageViewModel.PromptViewModel promptViewModel = lastPrompt = var5_7 instanceof ChatMessageViewModel.PromptViewModel ? (ChatMessageViewModel.PromptViewModel)var5_7 : null;
                if (promptViewModel != null) {
                    promptViewModel.markAsResponded();
                }
                List $this$lastOrNull$iv = (List)this._messageViewModels.getValue();
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    ChatMessageViewModel it = (ChatMessageViewModel)element$iv;
                    boolean bl = false;
                    if (!(it instanceof ChatMessageViewModel.AgentMessageViewModel)) continue;
                    v2 = element$iv;
                    break block18;
                }
                v2 = var6_15 = null;
            }
            if ((object = (lastAgentMessage = var6_15 instanceof ChatMessageViewModel.AgentMessageViewModel ? (StateFlow<List<AgentMessageBlockViewModel<?>>>)var6_15 : null)) != null && (object = object.getBlocks()) != null && (object = (List)object.getValue()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AgentMessageBlockViewModel it = (AgentMessageBlockViewModel)element$iv;
                    boolean bl = false;
                    it.clearMenuItems();
                }
            }
        } else if (!(chatSessionEvent2 instanceof ChatSessionPlanUpdatedEvent || chatSessionEvent2 instanceof ChatSessionAgentStatusChanged || chatSessionEvent2 instanceof ChatSessionAgentStateChanged)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void update(MutableStateFlow<PersistentList<ChatMessageViewModel>> $this$update, Project project, ChatSessionMessageEvent event, CoroutineScope viewModelsParentScope, ChatSessionId chatSessionId) {
        PersistentList<ChatMessageViewModel> persistentList;
        Object object;
        MutableStateFlow<PersistentList<ChatMessageViewModel>> messageViewModels = $this$update;
        ChatMessageViewModel viewModelByEventId = this.messageViewModelByEventId.get(event.getId());
        ChatMessageViewModel chatMessageViewModel = viewModelByEventId;
        if (chatMessageViewModel == null) {
            if (event instanceof ChatSessionMessageBlockEvent) {
                object = CollectionsKt.lastOrNull((List)((List)messageViewModels.getValue()));
                ChatMessageViewModel it = (ChatMessageViewModel)object;
                boolean bl = false;
                chatMessageViewModel = (ChatMessageViewModel)(it instanceof ChatMessageViewModel.AgentMessageViewModel ? object : null);
            } else {
                chatMessageViewModel = null;
            }
        }
        ChatMessageViewModel viewModelToBeUpdated = chatMessageViewModel;
        MutableStateFlow<PersistentList<ChatMessageViewModel>> mutableStateFlow = messageViewModels;
        ChatMessageViewModel chatMessageViewModel2 = viewModelToBeUpdated;
        if (chatMessageViewModel2 instanceof ChatMessageViewModel.AgentMessageViewModel) {
            if (event instanceof ChatSessionMessageBlockEvent) {
                ((ChatMessageViewModel.AgentMessageViewModel)viewModelToBeUpdated).updateMessageBlocks((ChatSessionMessageBlockEvent)event);
                this.messageViewModelByEventId.put(((ChatSessionMessageBlockEvent)event).getId(), viewModelToBeUpdated);
            } else {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ChatMessageUpdatesManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Update of " + Reflection.getOrCreateKotlinClass(viewModelToBeUpdated.getClass()).getSimpleName() + " by " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " is not accounted for");
            }
            persistentList = (PersistentList)messageViewModels.getValue();
        } else if (chatMessageViewModel2 instanceof ChatMessageViewModel.PromptViewModel) {
            if (event instanceof ChatSessionUserPromptEvent) {
                ((ChatMessageViewModel.PromptViewModel)viewModelToBeUpdated).updatePrompt((ChatSessionUserPromptEvent)event);
                this.messageViewModelByEventId.put(((ChatSessionUserPromptEvent)event).getId(), viewModelToBeUpdated);
            }
            persistentList = (PersistentList<ChatMessageViewModel>)messageViewModels.getValue();
        } else if (chatMessageViewModel2 instanceof ChatMessageViewModel.FailureMessageViewModel) {
            if (event instanceof ChatSessionFailureEvent) {
                ((ChatMessageViewModel.FailureMessageViewModel)viewModelToBeUpdated).updateMessage((ChatSessionFailureEvent)event);
                this.messageViewModelByEventId.put(((ChatSessionFailureEvent)event).getId(), viewModelToBeUpdated);
                this.failureMessageEventIds.add(((ChatSessionFailureEvent)event).getId());
            }
            persistentList = (PersistentList)messageViewModels.getValue();
        } else {
            if (chatMessageViewModel2 != null) throw new NoWhenBranchMatchedException();
            object = event;
            if (object instanceof ChatSessionMessageBlockEvent) {
                ChatSessionAgent chatSessionAgent;
                List list = (List)this.availableAgents.getValue();
                if (list != null) {
                    Object v5;
                    MutableStateFlow<PersistentList<ChatMessageViewModel>> mutableStateFlow2;
                    block26: {
                        void $this$singleOrNull$iv;
                        Iterable iterable = list;
                        mutableStateFlow2 = mutableStateFlow;
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (Object element$iv : $this$singleOrNull$iv) {
                            ChatSessionAgent it = (ChatSessionAgent)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)((ChatSessionMessageBlockEvent)event).getAgentId())) continue;
                            if (found$iv) {
                                v5 = null;
                                break block26;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v5 = !found$iv ? null : single$iv;
                    }
                    v6 = mutableStateFlow2;
                    chatSessionAgent = v5;
                } else {
                    chatSessionAgent = null;
                }
                currentAgent = chatSessionAgent;
                persistentList = this.addRemembering((PersistentList<? extends ChatMessageViewModel>)((PersistentList)messageViewModels.getValue()), ((ChatSessionMessageBlockEvent)event).getId(), new ChatMessageViewModel.AgentMessageViewModel(viewModelsParentScope, chatSessionId, currentAgent));
            } else if (object instanceof ChatSessionUserPromptEvent) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ChatSessionAgent chatSessionAgent;
                Object single$iv;
                MutableStateFlow<PersistentList<ChatMessageViewModel>> mutableStateFlow3;
                Iterable $this$singleOrNull$iv;
                List list = (List)this.availableAgents.getValue();
                if (list != null) {
                    Object v9;
                    block27: {
                        $this$singleOrNull$iv = list;
                        mutableStateFlow3 = mutableStateFlow;
                        boolean $i$f$singleOrNull = false;
                        single$iv = null;
                        boolean found$iv = false;
                        for (Object element$iv : $this$singleOrNull$iv) {
                            ChatSessionAgent it = (ChatSessionAgent)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)((ChatSessionUserPromptEvent)event).getAgentId())) continue;
                            if (found$iv) {
                                v9 = null;
                                break block27;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v9 = !found$iv ? null : single$iv;
                    }
                    mutableStateFlow = mutableStateFlow3;
                    chatSessionAgent = v9;
                } else {
                    chatSessionAgent = null;
                }
                currentAgent = chatSessionAgent;
                this.removeRevertedMessages(messageViewModels);
                this.removeFailureMessages(messageViewModels);
                $this$singleOrNull$iv = ((ChatSessionUserPromptEvent)event).getAttachments();
                mutableStateFlow3 = mutableStateFlow;
                boolean $i$f$map = false;
                single$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ChatSessionUserPromptAttachment bl = (ChatSessionUserPromptAttachment)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(new Attachment(it.getName(), IconIdKt.icon((IconId)it.getIcon()), it.getHint(), FileOperationsKt.urlToVirtualFile(it.getUrl())));
                }
                v6 = mutableStateFlow3;
                List attachments = (List)destination$iv$iv;
                ChatMessageViewModel.PromptViewModel promptViewModel = new ChatMessageViewModel.PromptViewModel(chatSessionId, ((ChatSessionUserPromptEvent)event).getPrompt(), (Function0<Unit>)((Function0)() -> ChatMessageUpdatesManager.update$lambda$4(this, chatSessionId, event)), attachments, this.openAttachmentAction(project));
                persistentList = this.addRemembering(this.addRemembering((PersistentList<? extends ChatMessageViewModel>)((PersistentList)messageViewModels.getValue()), ((ChatSessionUserPromptEvent)event).getId(), promptViewModel), ChatSessionEventId.Companion.getNONE(), new ChatMessageViewModel.AgentMessageViewModel(viewModelsParentScope, chatSessionId, currentAgent));
            } else {
                if (!(object instanceof ChatSessionFailureEvent)) throw new NoWhenBranchMatchedException();
                this.failureMessageEventIds.add(((ChatSessionFailureEvent)event).getId());
                persistentList = this.addRemembering((PersistentList<? extends ChatMessageViewModel>)((PersistentList)messageViewModels.getValue()), ((ChatSessionFailureEvent)event).getId(), new ChatMessageViewModel.FailureMessageViewModel(chatSessionId, ((ChatSessionFailureEvent)event).getMessage()));
            }
        }
        mutableStateFlow.setValue((Object)persistentList);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeRevertedMessages(MutableStateFlow<PersistentList<ChatMessageViewModel>> $this$removeRevertedMessages) {
        Collection destination$iv$iv;
        PersistentList nextValue$iv;
        Object prevValue$iv;
        Iterable $this$forEach$iv = this.revertedViewModelToEventId.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatSessionEventId eventId = (ChatSessionEventId)element$iv;
            boolean bl = false;
            this.messageViewModelByEventId.remove(eventId);
        }
        MutableStateFlow<PersistentList<ChatMessageViewModel>> $this$update$iv = $this$removeRevertedMessages;
        boolean $i$f$update = false;
        do {
            void $this$filterNotTo$iv$iv;
            prevValue$iv = $this$update$iv.getValue();
            PersistentList it = (PersistentList)prevValue$iv;
            boolean bl = false;
            Iterable $this$filterNot$iv = (Iterable)it;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ChatMessageViewModel it2 = (ChatMessageViewModel)element$iv$iv;
                boolean bl2 = false;
                if (this.revertedViewModelToEventId.containsKey(it2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ExtensionsKt.toPersistentList((Iterable)((List)destination$iv$iv)))));
        this.revertedViewModelToEventId.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void removeFailureMessages(MutableStateFlow<PersistentList<ChatMessageViewModel>> $this$removeFailureMessages) {
        Collection destination$iv$iv;
        PersistentList nextValue$iv;
        Object prevValue$iv;
        Iterable $this$forEach$iv = this.failureMessageEventIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatSessionEventId eventId = (ChatSessionEventId)element$iv;
            boolean bl = false;
            this.messageViewModelByEventId.remove(eventId);
        }
        MutableStateFlow<PersistentList<ChatMessageViewModel>> $this$update$iv = $this$removeFailureMessages;
        boolean $i$f$update = false;
        do {
            void $this$filterNotTo$iv$iv;
            prevValue$iv = $this$update$iv.getValue();
            PersistentList it = (PersistentList)prevValue$iv;
            boolean bl = false;
            Iterable $this$filterNot$iv = (Iterable)it;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ChatMessageViewModel it2 = (ChatMessageViewModel)element$iv$iv;
                boolean bl2 = false;
                if (it2 instanceof ChatMessageViewModel.FailureMessageViewModel) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ExtensionsKt.toPersistentList((Iterable)((List)destination$iv$iv)))));
        this.failureMessageEventIds.clear();
    }

    private final PersistentList<ChatMessageViewModel> addRemembering(PersistentList<? extends ChatMessageViewModel> $this$addRemembering, ChatSessionEventId eventId, ChatMessageViewModel messageViewModel) {
        PersistentList persistentList;
        PersistentList it = persistentList = $this$addRemembering.add((Object)messageViewModel);
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)eventId, (Object)ChatSessionEventId.Companion.getNONE())) {
            this.messageViewModelByEventId.put(eventId, messageViewModel);
        }
        return persistentList;
    }

    private final void rollbackAction(ChatSessionId chatSessionId, ChatSessionEventId eventId) {
        BuildersKt.launch$default((CoroutineScope)this.viewModelsParentScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(chatSessionId, eventId, null){
            int label;
            final /* synthetic */ ChatSessionId $chatSessionId;
            final /* synthetic */ ChatSessionEventId $eventId;
            {
                this.$chatSessionId = $chatSessionId;
                this.$eventId = $eventId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = AIAssistantChatSessionApi.Companion.getInstance((Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = ((AIAssistantChatSessionApi)v0).rollbackResult(this.$chatSessionId, this.$eventId, (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Function1<Attachment, Unit> openAttachmentAction(Project project) {
        return arg_0 -> ChatMessageUpdatesManager.openAttachmentAction$lambda$0(project, arg_0);
    }

    private static final Unit update$lambda$4(ChatMessageUpdatesManager this$0, ChatSessionId $chatSessionId, ChatSessionMessageEvent $event) {
        this$0.rollbackAction($chatSessionId, ((ChatSessionUserPromptEvent)$event).getId());
        return Unit.INSTANCE;
    }

    private static final Unit openAttachmentAction$lambda$0(Project $project, Attachment attachment) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
            VirtualFile virtualFile = attachment.getFile();
            if (virtualFile == null) break block1;
            VirtualFile file = virtualFile;
            boolean bl = false;
            if (file.isValid()) {
                FileEditorManager.getInstance((Project)$project).openFile(file, true);
            }
        }
        return Unit.INSTANCE;
    }
}

