/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp;

import com.agentclientprotocol.transport.StdioTransport;
import com.intellij.ml.llm.agents.acp.diagnostic.AcpLoggingInputStream;
import com.intellij.ml.llm.agents.acp.diagnostic.AcpLoggingOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.io.CoreKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/agents/acp/AcpTransportUtil;", "", "<init>", "()V", "createLoggingStdioTransport", "Lcom/agentclientprotocol/transport/StdioTransport;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "process", "Ljava/lang/Process;", "intellij.ml.llm.agents.acp"})
public final class AcpTransportUtil {
    @NotNull
    public static final AcpTransportUtil INSTANCE = new AcpTransportUtil();

    private AcpTransportUtil() {
    }

    @NotNull
    public final StdioTransport createLoggingStdioTransport(@NotNull CoroutineScope coroutineScope, @NotNull Process process2) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getIO();
        InputStream inputStream = process2.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Source source = CoreKt.buffered((RawSource)JvmCoreKt.asSource((InputStream)new AcpLoggingInputStream(inputStream)));
        OutputStream outputStream = process2.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        return new StdioTransport(coroutineScope, coroutineDispatcher, source, CoreKt.buffered((RawSink)JvmCoreKt.asSink((OutputStream)new AcpLoggingOutputStream(outputStream))), null, 16, null);
    }
}

