/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.client;

import com.intellij.ml.llm.agents.acp.client.AcpSessionLifecycleManager;
import com.intellij.ml.llm.agents.acp.client.AcpSessionLifecycleManagerKt;
import com.intellij.ml.llm.agents.acp.config.AgentServerConfig;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentConfigurationListener;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentRegistry;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.impl.ChatSessionImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J.\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/AcpSessionLifecycleManagerRegistry;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "managers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/agents/acp/client/AcpSessionLifecycleManagerRegistry$AgentAndChatId;", "Lcom/intellij/ml/llm/agents/acp/client/AcpSessionLifecycleManager;", "handleAgentConfigurationChange", "", "agentId", "", "agentName", "newConfig", "Lcom/intellij/ml/llm/agents/acp/config/AgentServerConfig;", "getOrCreate", "config", "chat", "Lcom/intellij/ml/llm/core/chat/session/impl/ChatSessionImpl;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "dispose", "AgentAndChatId", "Companion", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpSessionLifecycleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpSessionLifecycleManager.kt\ncom/intellij/ml/llm/agents/acp/client/AcpSessionLifecycleManagerRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n774#2:344\n865#2,2:345\n1869#2,2:347\n1869#2,2:352\n72#3,2:349\n1#4:351\n*S KotlinDebug\n*F\n+ 1 AcpSessionLifecycleManager.kt\ncom/intellij/ml/llm/agents/acp/client/AcpSessionLifecycleManagerRegistry\n*L\n292#1:344\n292#1:345,2\n302#1:347,2\n333#1:352,2\n322#1:349,2\n322#1:351\n*E\n"})
public final class AcpSessionLifecycleManagerRegistry
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<AgentAndChatId, AcpSessionLifecycleManager> managers;

    public AcpSessionLifecycleManagerRegistry(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.managers = new ConcurrentHashMap();
        AcpSessionLifecycleManagerKt.access$getLogger$p().info("Initialized AcpSessionLifecycleManagerRegistry for project: " + this.project.getName());
        AcpAgentRegistry registry = AcpAgentRegistry.Companion.getInstance();
        registry.addListener(new AcpAgentConfigurationListener(){

            @Override
            public void agentConfigurationChanged(String agentId, String agentName, AgentServerConfig oldConfig, AgentServerConfig newConfig) {
                Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
                Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
                this.handleAgentConfigurationChange(agentId, agentName, newConfig);
            }
        }, this);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleAgentConfigurationChange(String agentId, String agentName, AgentServerConfig newConfig) {
        void $this$filterTo$iv$iv;
        AcpSessionLifecycleManagerKt.access$getLogger$p().info("Handling configuration change for agent '" + agentName + "' (id: " + agentId + ")");
        if (newConfig == null) {
            return;
        }
        Set set = this.managers.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AgentAndChatId it = (AgentAndChatId)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getAgentId(), (Object)agentId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List managersToRemove = (List)destination$iv$iv;
        if (managersToRemove.isEmpty()) {
            AcpSessionLifecycleManagerKt.access$getLogger$p().info("No session managers found for agent '" + agentName + "'");
            return;
        }
        AcpSessionLifecycleManagerKt.access$getLogger$p().info("Removing " + managersToRemove.size() + " session manager(s) for agent '" + agentName + "'");
        Iterable $this$forEach$iv = managersToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AcpSessionLifecycleManager manager;
            AgentAndChatId key = (AgentAndChatId)element$iv;
            boolean bl = false;
            if (this.managers.remove(key) == null) continue;
            boolean bl2 = false;
            AcpSessionLifecycleManagerKt.access$getLogger$p().info("Disposing session manager for agent '" + agentName + "' in chat " + key.getChatId());
            manager.dispose();
        }
        AcpSessionLifecycleManagerKt.access$getLogger$p().info("Finished cleaning up session managers for agent '" + agentName + "'");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AcpSessionLifecycleManager getOrCreate(@NotNull String agentId, @NotNull String agentName, @NotNull AgentServerConfig config, @NotNull ChatSessionImpl chat, @NotNull CoroutineScope coroutineScope) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        AgentAndChatId agentAndChatId = new AgentAndChatId(agentId, chat.getUid());
        AcpSessionLifecycleManager acpSessionLifecycleManager = this.managers.get(agentAndChatId);
        if (acpSessionLifecycleManager != null) {
            acpSessionLifecycleManager.getOrCreateAgentClient();
        }
        ConcurrentMap concurrentMap = this.managers;
        AgentAndChatId key$iv = agentAndChatId;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            AcpSessionLifecycleManager default$iv = new AcpSessionLifecycleManager(this.project, agentId, agentName, config, coroutineScope, (ChatSession)chat);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (AcpSessionLifecycleManager)object;
    }

    public void dispose() {
        AcpSessionLifecycleManagerKt.access$getLogger$p().info("Disposing AcpSessionLifecycleManagerRegistry for project: " + this.project.getName());
        Collection<AcpSessionLifecycleManager> collection = this.managers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AcpSessionLifecycleManager it = (AcpSessionLifecycleManager)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.managers.clear();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/AcpSessionLifecycleManagerRegistry$AgentAndChatId;", "", "agentId", "", "chatId", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getAgentId", "()Ljava/lang/String;", "getChatId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.agents.acp"})
    private static final class AgentAndChatId {
        @NotNull
        private final String agentId;
        @NotNull
        private final String chatId;

        public AgentAndChatId(@NotNull String agentId, @NotNull String chatId) {
            Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
            Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
            this.agentId = agentId;
            this.chatId = chatId;
        }

        @NotNull
        public final String getAgentId() {
            return this.agentId;
        }

        @NotNull
        public final String getChatId() {
            return this.chatId;
        }

        @NotNull
        public final String component1() {
            return this.agentId;
        }

        @NotNull
        public final String component2() {
            return this.chatId;
        }

        @NotNull
        public final AgentAndChatId copy(@NotNull String agentId, @NotNull String chatId) {
            Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
            Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
            return new AgentAndChatId(agentId, chatId);
        }

        public static /* synthetic */ AgentAndChatId copy$default(AgentAndChatId agentAndChatId, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = agentAndChatId.agentId;
            }
            if ((n & 2) != 0) {
                string2 = agentAndChatId.chatId;
            }
            return agentAndChatId.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "AgentAndChatId(agentId=" + this.agentId + ", chatId=" + this.chatId + ")";
        }

        public int hashCode() {
            int result2 = this.agentId.hashCode();
            result2 = result2 * 31 + this.chatId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AgentAndChatId)) {
                return false;
            }
            AgentAndChatId agentAndChatId = (AgentAndChatId)other;
            if (!Intrinsics.areEqual((Object)this.agentId, (Object)agentAndChatId.agentId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.chatId, (Object)agentAndChatId.chatId);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/AcpSessionLifecycleManagerRegistry$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/agents/acp/client/AcpSessionLifecycleManagerRegistry;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AcpSessionLifecycleManagerRegistry getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(AcpSessionLifecycleManagerRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (AcpSessionLifecycleManagerRegistry)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

