/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.client;

import com.agentclientprotocol.model.ContentBlock;
import com.agentclientprotocol.model.PermissionOption;
import com.agentclientprotocol.model.PlanEntry;
import com.agentclientprotocol.model.PlanEntryStatus;
import com.agentclientprotocol.model.SessionUpdate;
import com.agentclientprotocol.model.ToolCallContent;
import com.agentclientprotocol.model.ToolCallLocation;
import com.agentclientprotocol.model.ToolCallStatus;
import com.agentclientprotocol.model.ToolKind;
import com.intellij.ml.llm.agents.A2UXEvent;
import com.intellij.ml.llm.agents.acp.client.AcpEvent;
import com.intellij.ml.llm.agents.acp.client.AcpToA2UXConverterKt;
import com.intellij.ml.llm.agents.acp.client.ChunkBuffer;
import com.intellij.ml.llm.agents.acp.client.ToolCallWrapper;
import com.intellij.ml.llm.agents.acp.support.FileUtilKt;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.a2ux.api.AgentEvent;
import org.jetbrains.a2ux.api.AgentFailureEvent;
import org.jetbrains.a2ux.api.AgentPlanUpdatedEvent;
import org.jetbrains.a2ux.api.ApproveInputRequest;
import org.jetbrains.a2ux.api.ChoiceInputRequest;
import org.jetbrains.a2ux.api.ChoiceOption;
import org.jetbrains.a2ux.api.ChoiceRequestUpdatedEvent;
import org.jetbrains.a2ux.api.File;
import org.jetbrains.a2ux.api.FileChange;
import org.jetbrains.a2ux.api.FileChangesBlockUpdatedEvent;
import org.jetbrains.a2ux.api.FileContent;
import org.jetbrains.a2ux.api.ItemStatus;
import org.jetbrains.a2ux.api.MarkdownBlockUpdatedEvent;
import org.jetbrains.a2ux.api.PlanItem;
import org.jetbrains.a2ux.api.ResultBlockUpdatedEvent;
import org.jetbrains.a2ux.api.StepStatus;
import org.jetbrains.a2ux.api.TerminalBlockUpdatedEvent;
import org.jetbrains.a2ux.api.TextFileContent;
import org.jetbrains.a2ux.api.ToolBlockUpdatedEvent;
import org.jetbrains.a2ux.api.ViewFilesBlockUpdatedEvent;
import org.jetbrains.a2ux.extensions.A2uxTaskState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u0017H\u0002J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u0018H\u0002J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u0019H\u0002J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u001aH\u0002J\f\u0010\u0016\u001a\u00020\u001b*\u00020\u001cH\u0002J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u000bH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/AcpToA2UXConverter;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "chunkBuffer", "Lcom/intellij/ml/llm/agents/acp/client/ChunkBuffer;", "toolCallsMap", "", "", "Lcom/intellij/ml/llm/agents/acp/client/ToolCallWrapper;", "value", "", "isFinished", "()Z", "process", "", "Lcom/intellij/ml/llm/agents/A2UXEvent;", "event", "Lcom/intellij/ml/llm/agents/acp/client/AcpEvent;", "withEventsFromBuffer", "convert", "Lcom/intellij/ml/llm/agents/acp/client/AcpEvent$SessionRequestPermission;", "Lcom/agentclientprotocol/model/SessionUpdate$AvailableCommandsUpdate;", "Lcom/agentclientprotocol/model/SessionUpdate$CurrentModeUpdate;", "Lcom/agentclientprotocol/model/SessionUpdate$PlanUpdate;", "Lorg/jetbrains/a2ux/api/ItemStatus;", "Lcom/agentclientprotocol/model/PlanEntryStatus;", "extractText", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpToA2UXConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpToA2UXConverter.kt\ncom/intellij/ml/llm/agents/acp/client/AcpToA2UXConverter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n382#2,7:228\n382#2,7:235\n382#2,7:242\n1563#3:249\n1634#3,3:250\n1563#3:253\n1634#3,3:254\n1563#3:258\n1634#3,3:259\n1563#3:262\n1634#3,3:263\n1761#3,3:266\n808#3,11:269\n1563#3:280\n1634#3,3:281\n1761#3,3:284\n808#3,11:287\n1563#3:298\n1634#3,3:299\n1#4:257\n*S KotlinDebug\n*F\n+ 1 AcpToA2UXConverter.kt\ncom/intellij/ml/llm/agents/acp/client/AcpToA2UXConverter\n*L\n64#1:228,7\n69#1:235,7\n79#1:242,7\n85#1:249\n85#1:250,3\n103#1:253\n103#1:254,3\n126#1:258\n126#1:259,3\n130#1:262\n130#1:263,3\n135#1:266,3\n137#1:269,11\n137#1:280\n137#1:281,3\n152#1:284,3\n178#1:287,11\n178#1:298\n178#1:299,3\n*E\n"})
public final class AcpToA2UXConverter {
    @NotNull
    private final Project project;
    @NotNull
    private final ChunkBuffer chunkBuffer;
    @NotNull
    private final Map<String, ToolCallWrapper> toolCallsMap;
    private boolean isFinished;

    public AcpToA2UXConverter(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.chunkBuffer = new ChunkBuffer();
        this.toolCallsMap = new LinkedHashMap();
    }

    public final boolean isFinished() {
        return this.isFinished;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<A2UXEvent> process(@NotNull AcpEvent event2) {
        List<A2UXEvent> list;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (this.isFinished) {
            throw new IllegalStateException("Already finished");
        }
        AcpEvent acpEvent = event2;
        if (acpEvent instanceof AcpEvent.SessionConnectionFailed) {
            this.isFinished = true;
            String string = ((AcpEvent.SessionConnectionFailed)event2).getMessage();
            if (string == null) {
                string = "Session connection failed";
            }
            return this.withEventsFromBuffer(CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new AgentFailureEvent(string), A2uxTaskState.FAILED)));
        }
        if (acpEvent instanceof AcpEvent.SessionPromptFinished) {
            this.isFinished = true;
            return this.withEventsFromBuffer(CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new ResultBlockUpdatedEvent(null, null, null, "", CollectionsKt.emptyList(), 7, null), A2uxTaskState.COMPLETED)));
        }
        if (acpEvent instanceof AcpEvent.CustomAgentEvent) {
            return this.withEventsFromBuffer(CollectionsKt.listOf((Object)new A2UXEvent(((AcpEvent.CustomAgentEvent)event2).getAgentEvent(), A2uxTaskState.IN_PROGRESS)));
        }
        if (acpEvent instanceof AcpEvent.SessionRequestPermission) {
            return this.withEventsFromBuffer(this.convert((AcpEvent.SessionRequestPermission)event2));
        }
        if (!(acpEvent instanceof AcpEvent.AcpSessionUpdate)) {
            throw new NoWhenBranchMatchedException();
        }
        SessionUpdate sessionUpdate = ((AcpEvent.AcpSessionUpdate)event2).getSessionUpdate();
        acpEvent = sessionUpdate;
        if (acpEvent instanceof SessionUpdate.AgentMessageChunk || acpEvent instanceof SessionUpdate.AgentThoughtChunk || acpEvent instanceof SessionUpdate.UserMessageChunk) {
            list = this.chunkBuffer.processChunkableUpdate(sessionUpdate);
        } else if (acpEvent instanceof SessionUpdate.AvailableCommandsUpdate) {
            list = this.withEventsFromBuffer(this.convert((SessionUpdate.AvailableCommandsUpdate)sessionUpdate));
        } else if (acpEvent instanceof SessionUpdate.CurrentModeUpdate) {
            list = this.withEventsFromBuffer(this.convert((SessionUpdate.CurrentModeUpdate)sessionUpdate));
        } else if (acpEvent instanceof SessionUpdate.PlanUpdate) {
            list = this.withEventsFromBuffer(this.convert((SessionUpdate.PlanUpdate)sessionUpdate));
        } else if (acpEvent instanceof SessionUpdate.ToolCall) {
            Object object;
            void $this$getOrPut$iv;
            Map<String, ToolCallWrapper> map2 = this.toolCallsMap;
            String key$iv = ((SessionUpdate.ToolCall)sessionUpdate).getToolCallId-DimCYko();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ToolCallWrapper answer$iv = new ToolCallWrapper(((SessionUpdate.ToolCall)sessionUpdate).getToolCallId-DimCYko(), null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ToolCallWrapper wrapper = (ToolCallWrapper)object;
            wrapper.updateFrom((SessionUpdate.ToolCall)sessionUpdate);
            list = this.withEventsFromBuffer(this.convert(wrapper));
        } else if (acpEvent instanceof SessionUpdate.ToolCallUpdate) {
            ToolCallWrapper toolCallWrapper;
            Map<String, ToolCallWrapper> $this$getOrPut$iv = this.toolCallsMap;
            String key$iv = ((SessionUpdate.ToolCallUpdate)sessionUpdate).getToolCallId-DimCYko();
            boolean $i$f$getOrPut = false;
            ToolCallWrapper value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ToolCallWrapper answer$iv = new ToolCallWrapper(((SessionUpdate.ToolCallUpdate)sessionUpdate).getToolCallId-DimCYko(), null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                toolCallWrapper = answer$iv;
            } else {
                toolCallWrapper = value$iv;
            }
            ToolCallWrapper wrapper = toolCallWrapper;
            wrapper.updateFrom((SessionUpdate.ToolCallUpdate)sessionUpdate);
            list = this.withEventsFromBuffer(this.convert(wrapper));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final List<A2UXEvent> withEventsFromBuffer(List<A2UXEvent> $this$withEventsFromBuffer) {
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)this.chunkBuffer.flush()), (Iterable)$this$withEventsFromBuffer);
    }

    /*
     * WARNING - void declaration
     */
    private final List<A2UXEvent> convert(AcpEvent.SessionRequestPermission $this$convert) {
        Object object;
        Object answer$iv;
        void $this$getOrPut$iv;
        List list;
        List $this$convert_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Map<String, ToolCallWrapper> map2 = this.toolCallsMap;
        String key$iv = $this$convert.getToolCall().getToolCallId-DimCYko();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl2 = false;
            answer$iv = new ToolCallWrapper($this$convert.getToolCall().getToolCallId-DimCYko(), null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ToolCallWrapper context2 = (ToolCallWrapper)object;
        context2.updateFrom($this$convert.getToolCall());
        $this$convert_u24lambda_u240.addAll((Collection)this.convert(context2));
        String requestStepId = AcpToA2UXConverterKt.getPermissionStepId-yCh-2Ps(context2.getToolCallId-DimCYko());
        if ($this$convert.getToolCall().getStatus() != ToolCallStatus.COMPLETED) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$convert.getOptions();
            boolean $i$f$map = false;
            answer$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PermissionOption permissionOption = (PermissionOption)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new ChoiceOption(it.getOptionId-w2So5B0(), it.getName()));
            }
            List options = (List)destination$iv$iv;
            ChoiceInputRequest choiceInputRequest = new ChoiceInputRequest(context2.getToolCallId-DimCYko(), options);
            ToolCallStatus toolCallStatus = context2.getStatus();
            if (toolCallStatus == null || (toolCallStatus = AcpToA2UXConverterKt.access$convert(toolCallStatus)) == null) {
                toolCallStatus = StepStatus.IN_PROGRESS;
            }
            $this$convert_u24lambda_u240.add(new A2UXEvent((AgentEvent)new ChoiceRequestUpdatedEvent(requestStepId, null, "", choiceInputRequest, (StepStatus)toolCallStatus, 2, null), A2uxTaskState.INPUT_REQUIRED));
        }
        return CollectionsKt.build((List)list);
    }

    private final List<A2UXEvent> convert(SessionUpdate.AvailableCommandsUpdate $this$convert) {
        return CollectionsKt.emptyList();
    }

    private final List<A2UXEvent> convert(SessionUpdate.CurrentModeUpdate $this$convert) {
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final List<A2UXEvent> convert(SessionUpdate.PlanUpdate $this$convert) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$convert.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PlanEntry planEntry = (PlanEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PlanItem(this.convert(it.getStatus()), it.getContent()));
        }
        List items2 = (List)destination$iv$iv;
        return CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new AgentPlanUpdatedEvent(items2), A2uxTaskState.IN_PROGRESS));
    }

    private final ItemStatus convert(PlanEntryStatus $this$convert) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$convert.ordinal()]) {
            case 1 -> ItemStatus.PENDING;
            case 2 -> ItemStatus.IN_PROGRESS;
            case 3 -> ItemStatus.DONE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<A2UXEvent> convert(ToolCallWrapper $this$convert) {
        CharSequence charSequence;
        String markdownText;
        A2uxTaskState taskState;
        block37: {
            block40: {
                boolean bl;
                block35: {
                    ToolCallContent it;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    block39: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        void $this$filterIsInstanceTo$iv$iv;
                        Iterable element$iv2;
                        block38: {
                            boolean bl2;
                            block34: {
                                block36: {
                                    List filePaths;
                                    Iterable $this$map$iv2;
                                    List<ToolCallLocation> list;
                                    ToolCallStatus toolCallStatus = $this$convert.getStatus();
                                    taskState = switch (toolCallStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$1[toolCallStatus.ordinal()]) {
                                        case 1, 2 -> A2uxTaskState.IN_PROGRESS;
                                        case 3, 4 -> null;
                                        case -1 -> A2uxTaskState.IN_PROGRESS;
                                        default -> throw new NoWhenBranchMatchedException();
                                    };
                                    markdownText = this.extractText($this$convert);
                                    if ($this$convert.getKind() != ToolKind.READ && $this$convert.getKind() != ToolKind.SEARCH) break block36;
                                    List<ToolCallLocation> it2 = list = $this$convert.getLocations();
                                    boolean bl3 = false;
                                    List<Object> list2 = !((Collection)it2).isEmpty() ? list : null;
                                    if (list2 != null) {
                                        void $this$mapTo$iv$iv2;
                                        $this$map$iv2 = list2;
                                        boolean $i$f$map = false;
                                        Iterable iterable = $this$map$iv2;
                                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                        boolean $i$f$mapTo = false;
                                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                            void it3;
                                            ToolCallLocation toolCallLocation = (ToolCallLocation)item$iv$iv;
                                            Collection collection = destination$iv$iv;
                                            boolean bl4 = false;
                                            collection.add(it3.getPath());
                                        }
                                        v3 = (List)destination$iv$iv;
                                    } else {
                                        v3 = filePaths = CollectionsKt.listOfNotNull((Object)$this$convert.getFilePath());
                                    }
                                    if (!((Collection)filePaths).isEmpty()) {
                                        Collection<File> collection;
                                        void $this$mapTo$iv$iv3;
                                        void $this$map$iv3;
                                        Iterable iterable = filePaths;
                                        StepStatus stepStatus = null;
                                        ApproveInputRequest approveInputRequest = null;
                                        List list3 = null;
                                        String string = $this$convert.getToolCallId-DimCYko();
                                        boolean $i$f$map = false;
                                        $this$map$iv2 = $this$map$iv3;
                                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                                        boolean $i$f$mapTo = false;
                                        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                                            void it4;
                                            String string2 = (String)item$iv$iv;
                                            collection = destination$iv$iv;
                                            boolean bl5 = false;
                                            collection.add(new File(FileUtilKt.relativizePath(this.project, (String)it4)));
                                        }
                                        collection = (List)destination$iv$iv;
                                        DefaultConstructorMarker defaultConstructorMarker = null;
                                        int n = 14;
                                        String string3 = markdownText;
                                        Collection<File> collection2 = collection;
                                        StepStatus stepStatus2 = stepStatus;
                                        ApproveInputRequest approveInputRequest2 = approveInputRequest;
                                        List list4 = list3;
                                        String string4 = string;
                                        DefaultConstructorMarker defaultConstructorMarker2 = null;
                                        int n2 = 2;
                                        A2uxTaskState a2uxTaskState = null;
                                        AgentEvent agentEvent = (AgentEvent)new ViewFilesBlockUpdatedEvent(string4, list4, approveInputRequest2, stepStatus2, collection2, string3, n, defaultConstructorMarker);
                                        return CollectionsKt.listOf((Object)new A2UXEvent(agentEvent, a2uxTaskState, n2, defaultConstructorMarker2));
                                    }
                                    break block37;
                                }
                                if ($this$convert.getKind() == ToolKind.EDIT) break block38;
                                $this$any$iv = $this$convert.getContent();
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Iterable element$iv2 : $this$any$iv) {
                                        it = (ToolCallContent)element$iv2;
                                        boolean bl6 = false;
                                        if (!(it instanceof ToolCallContent.Diff)) continue;
                                        bl2 = true;
                                        break block34;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) break block39;
                        }
                        Iterable $this$filterIsInstance$iv = $this$convert.getContent();
                        boolean $i$f$filterIsInstance = false;
                        element$iv2 = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof ToolCallContent.Diff)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterIsInstance$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            String relativePath;
                            String string;
                            TextFileContent textFileContent;
                            void diff2;
                            ToolCallContent.Diff it4 = (ToolCallContent.Diff)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl7 = false;
                            if (diff2.getOldText() != null) {
                                String it5;
                                boolean bl8 = false;
                                textFileContent = new TextFileContent(it5);
                            } else {
                                textFileContent = null;
                            }
                            TextFileContent beforeContent = textFileContent;
                            TextFileContent afterContent = new TextFileContent(diff2.getNewText());
                            String bl8 = string = (relativePath = FileUtilKt.relativizePath(this.project, diff2.getPath()));
                            FileContent fileContent = (FileContent)afterContent;
                            FileContent fileContent2 = (FileContent)beforeContent;
                            boolean bl9 = false;
                            boolean bl10 = beforeContent != null;
                            String string5 = relativePath;
                            String string6 = bl10 ? string : null;
                            FileContent fileContent3 = fileContent;
                            FileContent fileContent4 = fileContent2;
                            collection.add(new FileChange(fileContent4, fileContent3, string6, string5));
                        }
                        List changes2 = (List)destination$iv$iv;
                        ToolCallStatus toolCallStatus = $this$convert.getStatus();
                        return CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new FileChangesBlockUpdatedEvent($this$convert.getToolCallId-DimCYko(), null, null, (StepStatus)(toolCallStatus != null ? AcpToA2UXConverterKt.access$convert(toolCallStatus) : null), changes2, markdownText, 6, null), taskState));
                    }
                    if ($this$convert.getKind() == ToolKind.EXECUTE) break block40;
                    $this$any$iv = $this$convert.getContent();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Iterable element$iv2 : $this$any$iv) {
                            it = (ToolCallContent)element$iv2;
                            boolean bl11 = false;
                            if (!(it instanceof ToolCallContent.Terminal)) continue;
                            bl = true;
                            break block35;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block37;
            }
            charSequence = $this$convert.getToolCallId-DimCYko();
            String string = $this$convert.getCommand();
            if (string == null) {
                string = $this$convert.getTitle();
            }
            String string7 = string;
            ToolCallStatus toolCallStatus = $this$convert.getStatus();
            StepStatus stepStatus = toolCallStatus != null ? AcpToA2UXConverterKt.access$convert(toolCallStatus) : null;
            String string8 = $this$convert.getOutput();
            String string9 = AcpToA2UXConverterKt.takeIfNotOutput(markdownText);
            return CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new TerminalBlockUpdatedEvent((String)charSequence, null, null, null, null, stepStatus, string7, string8, string9, 30, null), taskState));
        }
        if (markdownText != null) {
            return CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new MarkdownBlockUpdatedEvent($this$convert.getToolCallId-DimCYko(), null, $this$convert.getTitle() + "\n" + markdownText, 2, null), taskState));
        }
        charSequence = $this$convert.getTitle();
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = $this$convert.getToolCallId-DimCYko();
            String string10 = $this$convert.getTitle();
            if (string10 == null) {
                string10 = "";
            }
            return CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new ToolBlockUpdatedEvent(string, null, string10, null, null, null, null, null, 250, null), A2uxTaskState.IN_PROGRESS));
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final String extractText(ToolCallWrapper $this$extractText) {
        String string;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$extractText.getContent();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ToolCallContent.Content)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ToolCallContent.Content content2 = (ToolCallContent.Content)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getContent());
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ContentBlock.Text)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String it = string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, AcpToA2UXConverter::extractText$lambda$1, (int)30, null);
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)it) ? string : null;
    }

    private static final CharSequence extractText$lambda$1(ContentBlock.Text it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PlanEntryStatus.values().length];
            try {
                nArray[PlanEntryStatus.PENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlanEntryStatus.IN_PROGRESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlanEntryStatus.COMPLETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ToolCallStatus.values().length];
            try {
                nArray[ToolCallStatus.PENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolCallStatus.IN_PROGRESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolCallStatus.COMPLETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolCallStatus.FAILED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

