/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.process;

import com.intellij.ml.llm.agents.acp.AcpBundle;
import com.intellij.ml.llm.agents.acp.config.AgentServerConfig;
import com.intellij.ml.llm.agents.acp.process.AcpChatNotificationServiceKt;
import com.intellij.ml.llm.agents.acp.process.AcpProcessHandlerService;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentConfigurationListener;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentRegistry;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSessionHost;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatCustomNotificationViewModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\b\u0010\u0013\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/agents/acp/process/AcpChatNotificationService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "handleAgentConfigurationChange", "", "agentId", "", "agentName", "oldConfig", "Lcom/intellij/ml/llm/agents/acp/config/AgentServerConfig;", "newConfig", "showChatNotification", "chatId", "message", "dispose", "Companion", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpChatNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpChatNotificationService.kt\ncom/intellij/ml/llm/agents/acp/process/AcpChatNotificationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1869#2,2:125\n*S KotlinDebug\n*F\n+ 1 AcpChatNotificationService.kt\ncom/intellij/ml/llm/agents/acp/process/AcpChatNotificationService\n*L\n89#1:125,2\n*E\n"})
public final class AcpChatNotificationService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;

    public AcpChatNotificationService(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        AcpChatNotificationServiceKt.access$getLogger$p().info("Initialized AcpChatNotificationService for project: " + this.project.getName());
        AcpAgentRegistry registry = AcpAgentRegistry.Companion.getInstance();
        registry.addListener(new AcpAgentConfigurationListener(){

            @Override
            public void agentConfigurationChanged(String agentId, String agentName, AgentServerConfig oldConfig, AgentServerConfig newConfig) {
                Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
                Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
                this.handleAgentConfigurationChange(agentId, agentName, oldConfig, newConfig);
            }
        }, this);
        AcpChatNotificationServiceKt.access$getLogger$p().info("Registered configuration change listener for project: " + this.project.getName());
    }

    private final void handleAgentConfigurationChange(String agentId, String agentName, AgentServerConfig oldConfig, AgentServerConfig newConfig) {
        String string;
        AcpChatNotificationServiceKt.access$getLogger$p().info("Handling configuration change for agent '" + agentName + "' (id: " + agentId + ")");
        AcpProcessHandlerService processHandlerService = AcpProcessHandlerService.Companion.getInstance(this.project);
        Set<String> affectedChatIds = processHandlerService.getChatIdsForAgent(agentId);
        if (affectedChatIds.isEmpty()) {
            AcpChatNotificationServiceKt.access$getLogger$p().info("No active chats found for agent '" + agentName + "'");
            return;
        }
        AcpChatNotificationServiceKt.access$getLogger$p().info("Found " + affectedChatIds.size() + " chat(s) using agent '" + agentName + "'");
        processHandlerService.stopAllForAgent(agentId);
        if (oldConfig == null && newConfig != null) {
            var8_7 = new Object[]{agentName};
            string = AcpBundle.INSTANCE.message("acp.notification.agent.added", var8_7);
        } else if (oldConfig != null && newConfig == null) {
            var8_7 = new Object[]{agentName};
            string = AcpBundle.INSTANCE.message("acp.notification.agent.removed", var8_7);
        } else {
            var8_7 = new Object[]{agentName};
            string = AcpBundle.INSTANCE.message("acp.notification.agent.updated", var8_7);
        }
        String notificationMessage = string;
        Iterable $this$forEach$iv = affectedChatIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String chatId = (String)element$iv;
            boolean bl = false;
            this.showChatNotification(chatId, notificationMessage);
        }
    }

    private final void showChatNotification(String chatId, String message) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, message, chatId, null){
            int label;
            final /* synthetic */ AcpChatNotificationService this$0;
            final /* synthetic */ String $message;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                this.$chatId = $chatId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            var3_2 = ChatSessionHost.Companion.getInstance(AcpChatNotificationService.access$getProject$p(this.this$0)).getAllChats();
                            var4_3 = this.$chatId;
                            var5_4 = var3_2;
                            for (T var7_6 : var5_4) {
                                it = (ChatSession)var7_6;
                                $i$a$-find-AcpChatNotificationService$showChatNotification$1$chatSession$1 = false;
                                if (!Intrinsics.areEqual((Object)it.getUid(), (Object)var4_3)) continue;
                                v0 = var7_6;
                                ** GOTO lbl18
                            }
                            v0 = null;
lbl18:
                            // 2 sources

                            if ((v1 = (chatSession = (ChatSession)v0)) != null && (v1 = v1.getCustomNotification()) != null) {
                                AIAssistantChatCustomNotificationViewModel.show$default((AIAssistantChatCustomNotificationViewModel)v1, (String)this.$message, null, null, null, null, (int)30, null);
                            }
                            if (chatSession == null) {
                                AcpChatNotificationServiceKt.access$getLogger$p().warn("Chat session not found for id: " + this.$chatId);
                            }
                        }
                        catch (Exception e) {
                            AcpChatNotificationServiceKt.access$getLogger$p().error("Failed to show notification in chat " + this.$chatId, (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public void dispose() {
        AcpChatNotificationServiceKt.access$getLogger$p().info("Disposing AcpChatNotificationService for project: " + this.project.getName());
    }

    public static final /* synthetic */ Project access$getProject$p(AcpChatNotificationService $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/agents/acp/process/AcpChatNotificationService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/agents/acp/process/AcpChatNotificationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AcpChatNotificationService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(AcpChatNotificationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (AcpChatNotificationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

