/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.process;

import com.intellij.ml.llm.agents.acp.config.AgentServerConfig;
import com.intellij.ml.llm.agents.acp.process.AcpProcessHandlerServiceKt;
import com.intellij.ml.llm.agents.acp.process.ConfigurableAcpProcessHandler;
import com.intellij.ml.llm.agents.acp.process.ProcessKey;
import com.intellij.ml.llm.agents.acp.process.ProcessStatistics;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JS\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b0\u0017J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010J\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010J\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010 \u001a\u00020\u001bJ\u0006\u0010!\u001a\u00020\"J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100$2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010%\u001a\u00020\u001bH\u0002J\b\u0010&\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/ml/llm/agents/acp/process/AcpProcessHandlerService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "processHandlers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/agents/acp/process/ProcessKey;", "Lcom/intellij/ml/llm/agents/acp/process/ConfigurableAcpProcessHandler;", "cleanupJob", "Lkotlinx/coroutines/Job;", "getOrCreateProcessHandler", "agentId", "", "agentName", "chat", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "config", "Lcom/intellij/ml/llm/agents/acp/config/AgentServerConfig;", "handleError", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "error", "", "getProcessHandler", "chatId", "stopProcessHandler", "stopAllForAgent", "stopAll", "getStatistics", "Lcom/intellij/ml/llm/agents/acp/process/ProcessStatistics;", "getChatIdsForAgent", "", "cleanupDeadProcesses", "dispose", "Companion", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpProcessHandlerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpProcessHandlerService.kt\ncom/intellij/ml/llm/agents/acp/process/AcpProcessHandlerService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,293:1\n1#2:294\n774#3:295\n865#3,2:296\n1869#3,2:298\n1869#3,2:300\n1788#3,4:302\n774#3:306\n865#3,2:307\n1563#3:309\n1634#3,3:310\n774#3:313\n865#3,2:314\n1563#3:316\n1634#3,3:317\n1869#3,2:320\n*S KotlinDebug\n*F\n+ 1 AcpProcessHandlerService.kt\ncom/intellij/ml/llm/agents/acp/process/AcpProcessHandlerService\n*L\n165#1:295\n165#1:296,2\n167#1:298,2\n191#1:300,2\n209#1:302,4\n227#1:306\n227#1:307,2\n228#1:309\n228#1:310,3\n237#1:313\n237#1:314,2\n238#1:316\n238#1:317,3\n242#1:320,2\n*E\n"})
public final class AcpProcessHandlerService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<ProcessKey, ConfigurableAcpProcessHandler> processHandlers;
    @NotNull
    private final Job cleanupJob;

    public AcpProcessHandlerService(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        this.processHandlers = new ConcurrentHashMap();
        this.cleanupJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AcpProcessHandlerService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 2 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                            if (v0 == var3_3) {
                                return var3_3;
                            }
                            ** GOTO lbl18
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        AcpProcessHandlerService.access$cleanupDeadProcesses(this.this$0);
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Initialized ConfigurableAcpProcessHandlerService for project: " + this.project.getName());
    }

    @Nullable
    public final ConfigurableAcpProcessHandler getOrCreateProcessHandler(@NotNull String agentId, @NotNull String agentName, @NotNull ChatSession chat, @NotNull AgentServerConfig config, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super String, Unit> handleError) {
        ConfigurableAcpProcessHandler configurableAcpProcessHandler;
        Path projectDir;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(handleError, (String)"handleError");
        ProcessKey key = new ProcessKey(agentId, chat.getUid());
        String chatId = chat.getUid();
        ConfigurableAcpProcessHandler configurableAcpProcessHandler2 = this.processHandlers.get(key);
        if (configurableAcpProcessHandler2 != null) {
            ConfigurableAcpProcessHandler handler2 = configurableAcpProcessHandler2;
            boolean bl = false;
            if (handler2.isRunning()) {
                AcpProcessHandlerServiceKt.access$getLogger$p().info("Reusing existing process handler for agent '" + agentName + "' in chat " + chatId);
                return handler2;
            }
            AcpProcessHandlerServiceKt.access$getLogger$p().info("Existing process handler for agent '" + agentName + "' is not running, creating new one");
            this.processHandlers.remove(key);
        }
        List<String> errors = ConfigurableAcpProcessHandler.Companion.validateConfig(config);
        if (!((Collection)errors).isEmpty()) {
            String message = "Invalid configuration for agent '" + agentName + "': " + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            AcpProcessHandlerServiceKt.access$getLogger$p().error(message);
            handleError.invoke((Object)message);
            return null;
        }
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)this.project);
        Path path = projectDir = virtualFile2 != null ? virtualFile2.toNioPath() : null;
        if (projectDir == null) {
            String message = "Cannot determine project directory for agent '" + agentName + "'";
            AcpProcessHandlerServiceKt.access$getLogger$p().error(message);
            handleError.invoke((Object)message);
            return null;
        }
        String agentSanitizedName = StringsKt.substringAfterLast$default((String)StringsKt.substringAfterLast$default((String)config.getCommand(), (String)"/", null, (int)2, null), (String)"\\", null, (int)2, null);
        try {
            AcpProcessHandlerServiceKt.access$getLogger$p().info("Starting new process for agent '" + agentName + "' in chat " + chatId);
            ConfigurableAcpProcessHandler handler3 = ConfigurableAcpProcessHandler.Companion.startProcess(agentName, config, projectDir, coroutineScope, handleError);
            ((Map)this.processHandlers).put(key, handler3);
            AcpProcessHandlerServiceKt.access$getLogger$p().info("Successfully created and registered process handler for agent '" + agentName + "' in chat " + chatId);
            AIAssistantChatEventLogger.logAcpAgentStarted((ChatSession)chat, (String)agentSanitizedName);
            configurableAcpProcessHandler = handler3;
        }
        catch (Exception e) {
            AcpProcessHandlerServiceKt.access$getLogger$p().error("Failed to start process for agent '" + agentName + "' in chat " + chatId, (Throwable)e);
            AIAssistantChatEventLogger.logAcpAgentFailed((ChatSession)chat, (String)agentSanitizedName);
            handleError.invoke((Object)("Failed to start process for agent '" + agentName + "': " + e.getMessage()));
            configurableAcpProcessHandler = null;
        }
        return configurableAcpProcessHandler;
    }

    @Nullable
    public final ConfigurableAcpProcessHandler getProcessHandler(@NotNull String agentId, @NotNull String chatId) {
        ConfigurableAcpProcessHandler configurableAcpProcessHandler;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        ProcessKey key = new ProcessKey(agentId, chatId);
        ConfigurableAcpProcessHandler configurableAcpProcessHandler2 = this.processHandlers.get(key);
        if (configurableAcpProcessHandler2 != null) {
            ConfigurableAcpProcessHandler configurableAcpProcessHandler3;
            ConfigurableAcpProcessHandler it = configurableAcpProcessHandler3 = configurableAcpProcessHandler2;
            boolean bl = false;
            configurableAcpProcessHandler = it.isRunning() ? configurableAcpProcessHandler3 : null;
        } else {
            configurableAcpProcessHandler = null;
        }
        return configurableAcpProcessHandler;
    }

    public final void stopProcessHandler(@NotNull String agentId, @NotNull String chatId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        ProcessKey key = new ProcessKey(agentId, chatId);
        ConfigurableAcpProcessHandler configurableAcpProcessHandler = this.processHandlers.remove(key);
        if (configurableAcpProcessHandler != null) {
            ConfigurableAcpProcessHandler handler2 = configurableAcpProcessHandler;
            boolean bl = false;
            AcpProcessHandlerServiceKt.access$getLogger$p().info("Stopping process handler for agent " + agentId + " in chat " + chatId);
            try {
                handler2.stopServer();
                AcpProcessHandlerServiceKt.access$getLogger$p().info("Successfully stopped process handler for agent " + agentId + " in chat " + chatId);
            }
            catch (Exception e) {
                AcpProcessHandlerServiceKt.access$getLogger$p().error("Failed to stop process handler for agent " + agentId + " in chat " + chatId, (Throwable)e);
                throw e;
            }
        } else {
            AcpProcessHandlerService $this$stopProcessHandler_u24lambda_u241 = this;
            boolean bl = false;
            AcpProcessHandlerServiceKt.access$getLogger$p().debug("No process handler found for agent " + agentId + " in chat " + chatId);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void stopAllForAgent(@NotNull String agentId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Set set = this.processHandlers.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProcessKey it = (ProcessKey)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getAgentId(), (Object)agentId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List keysToRemove = (List)destination$iv$iv;
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Stopping all process handlers for agent " + agentId + " (" + keysToRemove.size() + " total)");
        Iterable $this$forEach$iv = keysToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessKey key = (ProcessKey)element$iv;
            boolean bl = false;
            if (this.processHandlers.remove(key) == null) continue;
            boolean bl2 = false;
            try {
                ConfigurableAcpProcessHandler handler2;
                AcpProcessHandlerServiceKt.access$getLogger$p().info("Stopping process handler for agent " + agentId + " in chat " + key.getChatId());
                handler2.stopServer();
                AcpProcessHandlerServiceKt.access$getLogger$p().debug("Successfully stopped process handler for agent " + agentId + " in chat " + key.getChatId());
            }
            catch (Exception e) {
                AcpProcessHandlerServiceKt.access$getLogger$p().error("Failed to stop process handler for agent " + agentId + " in chat " + key.getChatId(), (Throwable)e);
            }
        }
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Finished stopping all process handlers for agent " + agentId);
    }

    public final void stopAll() {
        int totalHandlers = this.processHandlers.size();
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Stopping all process handlers (" + totalHandlers + " total)");
        int successCount = 0;
        int errorCount = 0;
        Collection<ConfigurableAcpProcessHandler> collection = this.processHandlers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurableAcpProcessHandler handler2 = (ConfigurableAcpProcessHandler)element$iv;
            boolean bl = false;
            try {
                handler2.stopServer();
                ++successCount;
            }
            catch (Exception e) {
                ++errorCount;
                AcpProcessHandlerServiceKt.access$getLogger$p().error("Error stopping process handler", (Throwable)e);
            }
        }
        this.processHandlers.clear();
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Finished stopping all process handlers (success: " + successCount + ", errors: " + errorCount + ")");
    }

    @NotNull
    public final ProcessStatistics getStatistics() {
        int n;
        Collection<ConfigurableAcpProcessHandler> collection = this.processHandlers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ConfigurableAcpProcessHandler it = (ConfigurableAcpProcessHandler)element$iv;
                boolean bl = false;
                if (!it.isRunning() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int running = n;
        int total = this.processHandlers.size();
        return new ProcessStatistics(total, running, total - running);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getChatIdsForAgent(@NotNull String agentId) {
        void $this$mapTo$iv$iv;
        ProcessKey it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Set set = this.processHandlers.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProcessKey)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getAgentId(), (Object)agentId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ProcessKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getChatId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanupDeadProcesses() {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        Set<Map.Entry<ProcessKey, ConfigurableAcpProcessHandler>> set = this.processHandlers.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(!((ConfigurableAcpProcessHandler)it.getValue()).isRunning())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ProcessKey)it.getKey());
        }
        List deadKeys = (List)destination$iv$iv;
        if (!((Collection)deadKeys).isEmpty()) {
            AcpProcessHandlerServiceKt.access$getLogger$p().info("Found " + deadKeys.size() + " dead process handler(s), cleaning up");
            Iterable $this$forEach$iv = deadKeys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProcessKey key = (ProcessKey)element$iv;
                boolean bl = false;
                if (this.processHandlers.remove(key) != null) {
                    boolean bl2 = false;
                    try {
                        ConfigurableAcpProcessHandler handler2;
                        handler2.stopServer();
                        AcpProcessHandlerServiceKt.access$getLogger$p().debug("Cleaned up dead process handler for agent " + key.getAgentId() + " in chat " + key.getChatId());
                    }
                    catch (Exception e) {
                        AcpProcessHandlerServiceKt.access$getLogger$p().debug("Error stopping dead process handler for agent " + key.getAgentId(), (Throwable)e);
                    }
                }
            }
        }
    }

    public void dispose() {
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Disposing ConfigurableAcpProcessHandlerService for project: " + this.project.getName());
        Job.DefaultImpls.cancel$default((Job)this.cleanupJob, null, (int)1, null);
        this.stopAll();
        AcpProcessHandlerServiceKt.access$getLogger$p().info("ConfigurableAcpProcessHandlerService disposed successfully");
    }

    public static final /* synthetic */ void access$cleanupDeadProcesses(AcpProcessHandlerService $this) {
        $this.cleanupDeadProcesses();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/agents/acp/process/AcpProcessHandlerService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/agents/acp/process/AcpProcessHandlerService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AcpProcessHandlerService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(AcpProcessHandlerService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (AcpProcessHandlerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

