/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.process;

import com.agentclientprotocol.protocol.Protocol;
import com.agentclientprotocol.protocol.ProtocolOptions;
import com.agentclientprotocol.transport.StdioTransport;
import com.agentclientprotocol.transport.Transport;
import com.intellij.ml.llm.agents.acp.AcpTransportUtil;
import com.intellij.ml.llm.agents.acp.config.AcpConfigurationLoader;
import com.intellij.ml.llm.agents.acp.config.AgentServerConfig;
import com.intellij.ml.llm.agents.acp.process.AcpProcessHandlerKt;
import com.intellij.ml.llm.agents.acp.process.LocalAcpServerProcessHandler;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.io.ProcessKt;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.io.CoreKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import kotlinx.io.Utf8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0001+BJ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001c\u0010\u001f\u001a\u00020\u000f2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u000bH\u0002J\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\tH\u0002J\b\u0010$\u001a\u00020\u000fH\u0002J\b\u0010%\u001a\u00020\u000fH\u0002J\b\u0010&\u001a\u00020\u000fH\u0002J\b\u0010*\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010)\u00a8\u0006,"}, d2={"Lcom/intellij/ml/llm/agents/acp/process/ConfigurableAcpProcessHandler;", "Lcom/intellij/ml/llm/agents/acp/process/LocalAcpServerProcessHandler;", "process", "Ljava/lang/Process;", "projectDir", "Ljava/nio/file/Path;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "agentName", "", "handleError", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "error", "", "<init>", "(Ljava/lang/Process;Ljava/nio/file/Path;Lkotlinx/coroutines/CoroutineScope;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getProjectDir", "()Ljava/nio/file/Path;", "terminated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "processScope", "transport", "Lcom/agentclientprotocol/transport/StdioTransport;", "protocol", "Lcom/agentclientprotocol/protocol/Protocol;", "getProtocol", "()Lcom/agentclientprotocol/protocol/Protocol;", "stderr", "Lkotlinx/io/Source;", "monitorProcessTermination", "appendStdErr", "buffer", "Ljava/lang/StringBuffer;", "line", "initialize", "killProcess", "cleanup", "isRunning", "", "()Z", "stopServer", "Companion", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpProcessHandler.kt\ncom/intellij/ml/llm/agents/acp/process/ConfigurableAcpProcessHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n1#2:278\n*E\n"})
public final class ConfigurableAcpProcessHandler
implements LocalAcpServerProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Process process;
    @NotNull
    private final Path projectDir;
    @NotNull
    private final String agentName;
    @NotNull
    private final AtomicBoolean terminated;
    @NotNull
    private final CoroutineScope processScope;
    @NotNull
    private final StdioTransport transport;
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final Source stderr;
    private static final int STD_ERR_BUFFER_SIZE = 10000;

    public ConfigurableAcpProcessHandler(@NotNull Process process2, @NotNull Path projectDir, @NotNull CoroutineScope cs, @NotNull String agentName, @NotNull Function1<? super String, Unit> handleError) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        Intrinsics.checkNotNullParameter(handleError, (String)"handleError");
        this.process = process2;
        this.projectDir = projectDir;
        this.agentName = agentName;
        this.terminated = new AtomicBoolean(false);
        this.processScope = CoroutineScopeKt.childScope$default((CoroutineScope)cs, (String)("AcpProcessHandler-" + this.agentName), null, (boolean)false, (int)6, null);
        this.transport = AcpTransportUtil.INSTANCE.createLoggingStdioTransport(this.processScope, this.process);
        this.protocol = new Protocol(this.processScope, (Transport)this.transport, new ProtocolOptions(DurationKt.toDuration((int)60, (DurationUnit)DurationUnit.SECONDS), 0L, null, 6, null));
        InputStream inputStream = this.process.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
        this.stderr = CoreKt.buffered((RawSource)JvmCoreKt.asSource((InputStream)inputStream));
        this.initialize();
        this.monitorProcessTermination(handleError);
    }

    @Override
    @NotNull
    public Path getProjectDir() {
        return this.projectDir;
    }

    @Override
    @NotNull
    public Protocol getProtocol() {
        return this.protocol;
    }

    private final void monitorProcessTermination(Function1<? super String, Unit> handleError) {
        StringBuffer stdErrBuffer = new StringBuffer();
        BuildersKt.launch$default((CoroutineScope)this.processScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, stdErrBuffer, handleError, null){
            int label;
            final /* synthetic */ ConfigurableAcpProcessHandler this$0;
            final /* synthetic */ StringBuffer $stdErrBuffer;
            final /* synthetic */ Function1<String, Unit> $handleError;
            {
                this.this$0 = $receiver;
                this.$stdErrBuffer = $stdErrBuffer;
                this.$handleError = $handleError;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = ProcessKt.awaitExit((Process)ConfigurableAcpProcessHandler.access$getProcess$p(this.this$0), (Continuation)((Continuation)this));
                        ** if (v0 != var10_2) goto lbl11
lbl10:
                        // 1 sources

                        return var10_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            exitCode = ((Number)v0).intValue();
                            ConfigurableAcpProcessHandler.access$getTerminated$p(this.this$0).set(true);
                            if (exitCode != 0) ** GOTO lbl22
                            AcpProcessHandlerKt.access$getLogger$p().info("[" + ConfigurableAcpProcessHandler.access$getAgentName$p(this.this$0) + "] Process terminated successfully with exit code: " + exitCode);
                            ** GOTO lbl62
lbl22:
                            // 1 sources

                            try {
                                v1 = ConfigurableAcpProcessHandler.access$getProcess$p(this.this$0).getErrorStream().readAllBytes();
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"readAllBytes(...)");
                                var4_7 = StringsKt.decodeToString((byte[])v1);
                            }
                            catch (Exception e) {
                                var4_7 = "";
                            }
                            err = var4_7;
                            this.$stdErrBuffer.append(err);
                            it = var6_10 = this.$stdErrBuffer.toString();
                            $i$a$-takeIf-ConfigurableAcpProcessHandler$monitorProcessTermination$1$error$1 = false;
                            Intrinsics.checkNotNull((Object)it);
                            v2 = !StringsKt.isBlank((CharSequence)it) != false ? var6_10 : null;
                            if (v2 == null) ** GOTO lbl44
                            it = v2;
                            $i$a$-let-ConfigurableAcpProcessHandler$monitorProcessTermination$1$error$2 = false;
                            v3 = " Process output:\n" + it;
                            v2 = v3;
                            if (v3 != null) ** GOTO lbl45
lbl44:
                            // 2 sources

                            v2 = "";
lbl45:
                            // 2 sources

                            error = v2;
                            this.$handleError.invoke((Object)("Process terminated with exit code: " + exitCode + "." + error));
                            AcpProcessHandlerKt.access$getLogger$p().warn("[" + ConfigurableAcpProcessHandler.access$getAgentName$p(this.this$0) + "] Process terminated with exit code: " + exitCode);
                            ** GOTO lbl62
                        }
                        catch (CancellationException e) {
                            AcpProcessHandlerKt.access$getLogger$p().info("[" + ConfigurableAcpProcessHandler.access$getAgentName$p(this.this$0) + "] Process termination monitoring cancelled");
                            throw e;
                        }
                        catch (Exception e) {
                            AcpProcessHandlerKt.access$getLogger$p().error("[" + ConfigurableAcpProcessHandler.access$getAgentName$p(this.this$0) + "] Process termination monitoring failed", (Throwable)e);
                            ConfigurableAcpProcessHandler.access$killProcess(this.this$0);
                            throw e;
                        }
                    }
                    catch (Throwable var2_6) {
                        throw var2_6;
                    }
                    {
                        finally {
                            ConfigurableAcpProcessHandler.access$cleanup(this.this$0);
                        }
lbl62:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        BuildersKt.launch$default((CoroutineScope)this.processScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, stdErrBuffer, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ConfigurableAcpProcessHandler this$0;
            final /* synthetic */ StringBuffer $stdErrBuffer;
            {
                this.this$0 = $receiver;
                this.$stdErrBuffer = $stdErrBuffer;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            void $this$launch;
                            while (kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                String line = Utf8Kt.readLineStrict$default((Source)ConfigurableAcpProcessHandler.access$getStderr$p(this.this$0), (long)0L, (int)1, null);
                                ConfigurableAcpProcessHandler.access$appendStdErr(this.this$0, this.$stdErrBuffer, line);
                                AcpProcessHandlerKt.access$getLogger$p().warn("[" + ConfigurableAcpProcessHandler.access$getAgentName$p(this.this$0) + "] stderr: " + line);
                            }
                        }
                        catch (CancellationException e) {
                            AcpProcessHandlerKt.access$getLogger$p().debug("[" + ConfigurableAcpProcessHandler.access$getAgentName$p(this.this$0) + "] Stderr reading cancelled");
                            throw e;
                        }
                        catch (Exception e) {
                            AcpProcessHandlerKt.access$getLogger$p().debug("[" + ConfigurableAcpProcessHandler.access$getAgentName$p(this.this$0) + "] Stderr reading failed", (Throwable)e);
                            ConfigurableAcpProcessHandler.access$killProcess(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void appendStdErr(StringBuffer buffer, String line) {
        if (buffer.length() >= 10000) {
            buffer.delete(0, 5000);
        }
        ((Appendable)buffer).append(line).append('\n');
    }

    private final void initialize() {
        this.transport.onError(arg_0 -> ConfigurableAcpProcessHandler.initialize$lambda$0(this, arg_0));
        this.getProtocol().start();
    }

    private final void killProcess() {
        if (this.terminated.compareAndSet(false, true)) {
            AcpProcessHandlerKt.access$getLogger$p().warn("[" + this.agentName + "] Killing process due to error");
            try {
                this.process.destroyForcibly();
            }
            catch (Exception e) {
                AcpProcessHandlerKt.access$getLogger$p().error("[" + this.agentName + "] Error killing process", (Throwable)e);
            }
        }
    }

    private final void cleanup() {
        AcpProcessHandlerKt.access$getLogger$p().debug("[" + this.agentName + "] Cleaning up resources");
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.processScope, null, (int)1, null);
    }

    @Override
    public boolean isRunning() {
        return this.process.isAlive() && !this.terminated.get();
    }

    @Override
    public void stopServer() {
        AcpProcessHandlerKt.access$getLogger$p().info("[" + this.agentName + "] Stopping server");
        if (this.terminated.compareAndSet(false, true)) {
            try {
                Object $this$stopServer_u24lambda_u242;
                Object $this$stopServer_u24lambda_u241;
                Object $this$stopServer_u24lambda_u240;
                this.getProtocol().close();
                ConfigurableAcpProcessHandler configurableAcpProcessHandler = this;
                try {
                    $this$stopServer_u24lambda_u240 = configurableAcpProcessHandler;
                    boolean bl = false;
                    ((ConfigurableAcpProcessHandler)$this$stopServer_u24lambda_u240).process.getInputStream().close();
                    $this$stopServer_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    $this$stopServer_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                configurableAcpProcessHandler = this;
                try {
                    $this$stopServer_u24lambda_u241 = configurableAcpProcessHandler;
                    boolean bl = false;
                    ((ConfigurableAcpProcessHandler)$this$stopServer_u24lambda_u241).process.getOutputStream().close();
                    $this$stopServer_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    $this$stopServer_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                configurableAcpProcessHandler = this;
                try {
                    $this$stopServer_u24lambda_u242 = configurableAcpProcessHandler;
                    boolean bl = false;
                    ((ConfigurableAcpProcessHandler)$this$stopServer_u24lambda_u242).process.getErrorStream().close();
                    $this$stopServer_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    $this$stopServer_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                this.cleanup();
                this.process.destroy();
                if (!this.process.waitFor(5L, TimeUnit.SECONDS)) {
                    AcpProcessHandlerKt.access$getLogger$p().warn("[" + this.agentName + "] Process didn't terminate gracefully, force killing");
                    this.process.destroyForcibly();
                }
            }
            catch (Exception e) {
                AcpProcessHandlerKt.access$getLogger$p().error("[" + this.agentName + "] Error stopping process", (Throwable)e);
                this.process.destroyForcibly();
            }
        }
    }

    private static final Unit initialize$lambda$0(ConfigurableAcpProcessHandler this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AcpProcessHandlerKt.access$getLogger$p().error("[" + this$0.agentName + "] Transport error", it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Process access$getProcess$p(ConfigurableAcpProcessHandler $this) {
        return $this.process;
    }

    public static final /* synthetic */ AtomicBoolean access$getTerminated$p(ConfigurableAcpProcessHandler $this) {
        return $this.terminated;
    }

    public static final /* synthetic */ String access$getAgentName$p(ConfigurableAcpProcessHandler $this) {
        return $this.agentName;
    }

    public static final /* synthetic */ void access$killProcess(ConfigurableAcpProcessHandler $this) {
        $this.killProcess();
    }

    public static final /* synthetic */ void access$cleanup(ConfigurableAcpProcessHandler $this) {
        $this.cleanup();
    }

    public static final /* synthetic */ Source access$getStderr$p(ConfigurableAcpProcessHandler $this) {
        return $this.stderr;
    }

    public static final /* synthetic */ void access$appendStdErr(ConfigurableAcpProcessHandler $this, StringBuffer buffer, String line) {
        $this.appendStdErr(buffer, line);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JI\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0011J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/agents/acp/process/ConfigurableAcpProcessHandler$Companion;", "", "<init>", "()V", "STD_ERR_BUFFER_SIZE", "", "startProcess", "Lcom/intellij/ml/llm/agents/acp/process/ConfigurableAcpProcessHandler;", "agentName", "", "config", "Lcom/intellij/ml/llm/agents/acp/config/AgentServerConfig;", "projectDir", "Ljava/nio/file/Path;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "handleError", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "error", "", "validateConfig", "", "intellij.ml.llm.agents.acp"})
    @SourceDebugExtension(value={"SMAP\nAcpProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpProcessHandler.kt\ncom/intellij/ml/llm/agents/acp/process/ConfigurableAcpProcessHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n1563#2:278\n1634#2,3:279\n*S KotlinDebug\n*F\n+ 1 AcpProcessHandler.kt\ncom/intellij/ml/llm/agents/acp/process/ConfigurableAcpProcessHandler$Companion\n*L\n217#1:278\n217#1:279,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ConfigurableAcpProcessHandler startProcess(@NotNull String agentName, @NotNull AgentServerConfig config, @NotNull Path projectDir, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super String, Unit> handleError) {
            Process process2;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter(handleError, (String)"handleError");
            String expandedCommand = AcpConfigurationLoader.INSTANCE.expandPath(config.getCommand());
            Iterable $this$map$iv = config.getArgs();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(AcpConfigurationLoader.INSTANCE.expandPath((String)it));
            }
            List expandedArgs = (List)destination$iv$iv;
            AcpProcessHandlerKt.access$getLogger$p().info("[" + agentName + "] Starting ACP agent");
            AcpProcessHandlerKt.access$getLogger$p().info("[" + agentName + "]   Command: " + expandedCommand);
            AcpProcessHandlerKt.access$getLogger$p().info("[" + agentName + "]   Args: " + CollectionsKt.joinToString$default((Iterable)expandedArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            AcpProcessHandlerKt.access$getLogger$p().info("[" + agentName + "]   Env vars: " + config.getEnv().size());
            AcpProcessHandlerKt.access$getLogger$p().info("[" + agentName + "]   Working dir: " + ((Object)projectDir).toString());
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)expandedCommand), (Iterable)expandedArgs)).directory(projectDir.toFile());
            Map<String, String> environment = processBuilder.environment();
            Map map2 = EnvironmentUtil.getEnvironmentMap();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvironmentMap(...)");
            environment.putAll(map2);
            if (!config.getEnv().isEmpty()) {
                environment.putAll(config.getEnv());
            }
            try {
                process2 = processBuilder.start();
            }
            catch (Exception e) {
                AcpProcessHandlerKt.access$getLogger$p().error("[" + agentName + "] Failed to start process", (Throwable)e);
                throw e;
            }
            Process process3 = process2;
            AcpProcessHandlerKt.access$getLogger$p().info("[" + agentName + "] Process started with PID: " + process3.pid());
            Intrinsics.checkNotNull((Object)process3);
            return new ConfigurableAcpProcessHandler(process3, projectDir, coroutineScope, agentName, handleError);
        }

        @NotNull
        public final List<String> validateConfig(@NotNull AgentServerConfig config) {
            String expandedCommand;
            Path commandPath;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            List errors = new ArrayList();
            if (StringsKt.isBlank((CharSequence)config.getCommand())) {
                errors.add("Command cannot be empty");
            }
            if (!(commandPath = Paths.get(expandedCommand = AcpConfigurationLoader.INSTANCE.expandPath(config.getCommand()), new String[0])).isAbsolute()) {
                AcpProcessHandlerKt.access$getLogger$p().debug("Command '" + expandedCommand + "' is not absolute, will search in PATH");
            } else if (!Files.exists(commandPath, new LinkOption[0])) {
                errors.add("Command executable not found: " + expandedCommand);
            }
            return errors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

