/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.registry;

import com.intellij.ml.llm.agents.ChatAgent;
import com.intellij.ml.llm.agents.acp.config.AcpConfiguration;
import com.intellij.ml.llm.agents.acp.config.AgentServerConfig;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentConfigurationListener;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentRegistryKt;
import com.intellij.ml.llm.agents.acp.registry.AgentRegistration;
import com.intellij.ml.llm.agents.acp.registry.DynamicAcpChatAgent;
import com.intellij.ml.llm.agents.acp.registry.RegistryStatistics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.EventListener;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0001J!\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u0013J,\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0002J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\b\u0010\u001b\u001a\u00020\fH\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0010\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "registeredAgents", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/ml/llm/agents/acp/registry/AgentRegistration;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentConfigurationListener;", "addListener", "", "listener", "parentDisposable", "reloadAgents", "newConfig", "Lcom/intellij/ml/llm/agents/acp/config/AcpConfiguration;", "oldConfig", "reloadAgents$intellij_ml_llm_agents_acp", "notifyListeners", "agentId", "agentName", "Lcom/intellij/ml/llm/agents/acp/config/AgentServerConfig;", "registerAgent", "config", "unregisterAgent", "unregisterAllAgents", "getStatistics", "Lcom/intellij/ml/llm/agents/acp/registry/RegistryStatistics;", "sanitizeAgentId", "name", "registerChatAgentDynamically", "agent", "Lcom/intellij/ml/llm/agents/ChatAgent;", "dispose", "Companion", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpAgentRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpAgentRegistry.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n1869#2,2:220\n1869#2,2:222\n*S KotlinDebug\n*F\n+ 1 AcpAgentRegistry.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry\n*L\n70#1:220,2\n152#1:222,2\n*E\n"})
public final class AcpAgentRegistry
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, AgentRegistration> registeredAgents = new ConcurrentHashMap();
    @NotNull
    private final EventDispatcher<AcpAgentConfigurationListener> dispatcher;

    public AcpAgentRegistry() {
        EventDispatcher eventDispatcher = EventDispatcher.create(AcpAgentConfigurationListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.dispatcher = eventDispatcher;
    }

    public final void addListener(@NotNull AcpAgentConfigurationListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.dispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public final void reloadAgents$intellij_ml_llm_agents_acp(@Nullable AcpConfiguration newConfig, @Nullable AcpConfiguration oldConfig) {
        Object object;
        Object oldAgentConfigs;
        AcpAgentRegistryKt.access$getLogger$p().info("Reloading dynamic ACP agents");
        Object object2 = oldConfig;
        if (object2 == null || (object2 = ((AcpConfiguration)object2).getAgentServers()) == null) {
            object2 = oldAgentConfigs = MapsKt.emptyMap();
        }
        if ((object = newConfig) == null || (object = ((AcpConfiguration)object).getAgentServers()) == null) {
            object = MapsKt.emptyMap();
        }
        Object newAgentConfigs = object;
        Set allAgentNames = CollectionsKt.toSet((Iterable)SetsKt.plus(oldAgentConfigs.keySet(), (Iterable)newAgentConfigs.keySet()));
        Iterable $this$forEach$iv = allAgentNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String agentName = (String)element$iv;
            boolean bl = false;
            String agentId = this.sanitizeAgentId(agentName);
            AgentServerConfig oldServerConfig = (AgentServerConfig)oldAgentConfigs.get(agentName);
            AgentServerConfig newServerConfig = (AgentServerConfig)newAgentConfigs.get(agentName);
            if (oldServerConfig == null && newServerConfig != null) {
                AcpAgentRegistryKt.access$getLogger$p().info("Agent '" + agentName + "' added");
                this.registerAgent(agentId, agentName, newServerConfig);
                this.notifyListeners(agentId, agentName, null, newServerConfig);
                continue;
            }
            if (oldServerConfig != null && newServerConfig == null) {
                AcpAgentRegistryKt.access$getLogger$p().info("Agent '" + agentName + "' removed");
                this.unregisterAgent(agentId);
                this.notifyListeners(agentId, agentName, oldServerConfig, null);
                continue;
            }
            if (oldServerConfig != null && newServerConfig != null && !Intrinsics.areEqual((Object)oldServerConfig, (Object)newServerConfig)) {
                AcpAgentRegistryKt.access$getLogger$p().info("Agent '" + agentName + "' configuration changed");
                this.unregisterAgent(agentId);
                this.registerAgent(agentId, agentName, newServerConfig);
                this.notifyListeners(agentId, agentName, oldServerConfig, newServerConfig);
                continue;
            }
            AcpAgentRegistryKt.access$getLogger$p().debug("Agent '" + agentName + "' unchanged");
        }
        AcpAgentRegistryKt.access$getLogger$p().info("Dynamic ACP agents reloaded: " + this.registeredAgents.size() + " active");
    }

    private final void notifyListeners(String agentId, String agentName, AgentServerConfig oldConfig, AgentServerConfig newConfig) {
        AcpAgentRegistryKt.access$getLogger$p().debug("Notifying listeners: agent=" + agentName + ", oldConfig=" + (oldConfig != null) + ", newConfig=" + (newConfig != null));
        ((AcpAgentConfigurationListener)this.dispatcher.getMulticaster()).agentConfigurationChanged(agentId, agentName, oldConfig, newConfig);
    }

    private final void registerAgent(String agentId, String agentName, AgentServerConfig config) {
        AcpAgentRegistryKt.access$getLogger$p().info("Registering dynamic agent: " + agentName + " (id: " + agentId + ")");
        DynamicAcpChatAgent agent2 = new DynamicAcpChatAgent(agentId, agentName, config);
        Disposable disposable = this.registerChatAgentDynamically(agent2);
        ((Map)this.registeredAgents).put(agentId, new AgentRegistration(agent2, disposable));
        AcpAgentRegistryKt.access$getLogger$p().info("Successfully registered agent: " + agentName);
    }

    private final void unregisterAgent(String agentId) {
        block0: {
            AgentRegistration agentRegistration = this.registeredAgents.remove(agentId);
            if (agentRegistration == null) break block0;
            AgentRegistration registration = agentRegistration;
            boolean bl = false;
            AcpAgentRegistryKt.access$getLogger$p().info("Unregistering agent: " + registration.getAgent().getName());
            Disposer.dispose((Disposable)registration.getDisposable());
        }
    }

    private final void unregisterAllAgents() {
        AcpAgentRegistryKt.access$getLogger$p().info("Unregistering all dynamic ACP agents (" + this.registeredAgents.size() + ")");
        Collection<AgentRegistration> collection = this.registeredAgents.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AgentRegistration registration = (AgentRegistration)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)registration.getDisposable());
        }
        this.registeredAgents.clear();
    }

    @NotNull
    public final RegistryStatistics getStatistics() {
        int n = this.registeredAgents.size();
        Set set = this.registeredAgents.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return new RegistryStatistics(n, CollectionsKt.toList((Iterable)set));
    }

    private final String sanitizeAgentId(String name) {
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        Object object = string;
        Regex regex = new Regex("[^a-z0-9]+");
        String string2 = "-";
        String string3 = regex.replace((CharSequence)object, string2);
        object = new char[1];
        object[0] = 45;
        return "acp." + StringsKt.trim((String)string3, (char[])object);
    }

    private final Disposable registerChatAgentDynamically(ChatAgent agent2) {
        Application app = ApplicationManager.getApplication();
        ExtensionsArea extensionsArea = app.getExtensionArea();
        Intrinsics.checkNotNullExpressionValue((Object)extensionsArea, (String)"getExtensionArea(...)");
        ExtensionsArea area = extensionsArea;
        ExtensionPoint ep = area.getExtensionPoint(ChatAgent.Companion.getEP_NAME());
        Disposable disposable = Disposer.newDisposable((String)("acp-agent:" + agent2.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable registration = disposable;
        ep.registerExtension((Object)agent2, registration);
        AcpAgentRegistryKt.access$getLogger$p().info("Registered ChatAgent dynamically: " + agent2.getId());
        return registration;
    }

    public void dispose() {
        this.unregisterAllAgents();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry;", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AcpAgentRegistry getInstance() {
            Object object = ApplicationManager.getApplication().getService(AcpAgentRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (AcpAgentRegistry)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

