/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.claude.code;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.agents.claude.code.ClaudeCodeLongRunningSession;
import com.intellij.ml.llm.agents.claude.code.ClaudeCodeOneShotSession;
import com.intellij.ml.llm.agents.claude.code.ClaudeCodeServiceKt;
import com.intellij.ml.llm.agents.claude.code.ClaudeCodeSession;
import com.intellij.ml.llm.agents.claude.code.settings.ClaudeCodeSettings;
import com.intellij.ml.llm.core.chat.session.ChatSessionVm;
import com.intellij.ml.llm.grazie.auth.GrazieAuthFacade;
import com.intellij.ml.llm.grazie.auth.GrazieAuthState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/agents/claude/code/ClaudeCodeService;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "chatIdToSession", "", "", "Lcom/intellij/ml/llm/agents/claude/code/ClaudeCodeSession;", "cleanupSessions", "", "getOrCreateSession", "chat", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionVm;", "Companion", "intellij.ml.llm.agents.claude.code"})
@SourceDebugExtension(value={"SMAP\nClaudeCodeService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaudeCodeService.kt\ncom/intellij/ml/llm/agents/claude/code/ClaudeCodeService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,82:1\n1869#2,2:83\n382#3,7:85\n*S KotlinDebug\n*F\n+ 1 ClaudeCodeService.kt\ncom/intellij/ml/llm/agents/claude/code/ClaudeCodeService\n*L\n52#1:83,2\n76#1:85,7\n*E\n"})
public final class ClaudeCodeService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Map<String, ClaudeCodeSession> chatIdToSession;

    public ClaudeCodeService(@NotNull Project project2, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project2;
        this.cs = cs;
        this.chatIdToSession = new ConcurrentHashMap();
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ClaudeCodeService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = GrazieAuthFacade.Companion.getInstance().getAuthState().collect(new FlowCollector(){

                            public final Object emit(GrazieAuthState it, Continuation<? super Unit> $completion) {
                                if (Registry.Companion.is("llm.chat.agent.claude.code.clear.sessions.on.auth.change")) {
                                    ClaudeCodeServiceKt.access$getLogger$p().debug("Clearing all claude sessions on grazie auth change");
                                    this$0.cleanupSessions();
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ClaudeCodeService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        boolean $i$f$service = false;
                        Class<ClaudeCodeSettings> serviceClass$iv = ClaudeCodeSettings.class;
                        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object2 == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        this.label = 1;
                        Object object3 = ((ClaudeCodeSettings)((Object)object2)).getAuthSettingsFlow().collect(new FlowCollector(){

                            public final Object emit(ClaudeCodeSettings.TokenSettings it, Continuation<? super Unit> $completion) {
                                if (Registry.Companion.is("llm.chat.agent.claude.code.clear.sessions.on.byok.token.change")) {
                                    ClaudeCodeServiceKt.access$getLogger$p().debug("Clearing all claude sessions on BYOK auth change");
                                    this$0.cleanupSessions();
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void cleanupSessions() {
        List toRemove = MapsKt.toList(this.chatIdToSession);
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String chatId = (String)pair.component1();
            ClaudeCodeSession session = (ClaudeCodeSession)pair.component2();
            if (this.chatIdToSession.remove(chatId) == null) continue;
            boolean bl2 = false;
            Disposer.dispose((Disposable)session);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClaudeCodeSession getOrCreateSession(@NotNull ChatSessionVm chat) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        CoroutineScope childScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.cs, (String)("ClaudeCodeSession[chatId=" + chat.getUid() + "]"), null, (boolean)false, (int)6, null);
        Disposer.register((Disposable)((Disposable)chat), () -> ClaudeCodeService.getOrCreateSession$lambda$0(this, chat, childScope));
        boolean isInputStreamEnabled = Registry.Companion.is("llm.chat.agent.claude.code.json.input.stream");
        Map<String, ClaudeCodeSession> map2 = this.chatIdToSession;
        String key$iv = chat.getUid();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ClaudeCodeServiceKt.access$getLogger$p().info("Creating Claude Code session for chatId: " + chat.getUid());
            ClaudeCodeSession answer$iv = isInputStreamEnabled ? (ClaudeCodeSession)new ClaudeCodeLongRunningSession(childScope, chat) : (ClaudeCodeSession)new ClaudeCodeOneShotSession(childScope, chat);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ClaudeCodeSession claudeCodeSession = (ClaudeCodeSession)object;
        return claudeCodeSession;
    }

    private static final void getOrCreateSession$lambda$0(ClaudeCodeService this$0, ChatSessionVm $chat, CoroutineScope $childScope) {
        ClaudeCodeSession claudeCodeSession = this$0.chatIdToSession.remove($chat.getUid());
        if (claudeCodeSession != null) {
            ClaudeCodeSession it = claudeCodeSession;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)$childScope, null, (int)1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/agents/claude/code/ClaudeCodeService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/agents/claude/code/ClaudeCodeService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.agents.claude.code"})
    @SourceDebugExtension(value={"SMAP\nClaudeCodeService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaudeCodeService.kt\ncom/intellij/ml/llm/agents/claude/code/ClaudeCodeService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,82:1\n30#2,2:83\n*S KotlinDebug\n*F\n+ 1 ClaudeCodeService.kt\ncom/intellij/ml/llm/agents/claude/code/ClaudeCodeService$Companion\n*L\n25#1:83,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClaudeCodeService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ClaudeCodeService> serviceClass$iv = ClaudeCodeService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ClaudeCodeService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

