/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.claude.code.monitoring;

import com.intellij.ml.llm.agents.claude.code.protocol.Usage;
import com.intellij.ml.llm.grazie.GrazieSpentQuotaFunctionsKt;
import com.intellij.openapi.components.Service;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\f\u0010\u0012\u001a\u00020\u0013*\u00020\fH\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/agents/claude/code/monitoring/TokenMonitoringService;", "", "<init>", "()V", "sessionStats", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/ml/llm/agents/claude/code/monitoring/TokenMonitoringService$TokenStats;", "updateFromUsage", "", "sessionId", "usage", "Lcom/intellij/ml/llm/agents/claude/code/protocol/Usage;", "(Ljava/lang/String;Lcom/intellij/ml/llm/agents/claude/code/protocol/Usage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getInputTokens", "", "getOutputTokens", "clear", "toQuota", "Ljava/math/BigDecimal;", "TOKEN_LOSS_RATIO", "MILLION", "QUOTA_MULTIPLIER", "SONNET_4_INPUT", "SONNET_4_INPUT_EXTENDED", "SONNET_4_INPUT_CACHE_WRITE", "SONNET_4_INPUT_CACHE_WRITE_EXTENDED", "SONNET_4_INPUT_CACHE_READ", "SONNET_4_INPUT_CACHE_READ_EXTENDED", "SONNET_4_OUTPUT", "SONNET_4_OUTPUT_EXTENDED", "TokenStats", "intellij.ml.llm.agents.claude.code"})
@SourceDebugExtension(value={"SMAP\nTokenMonitoringService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenMonitoringService.kt\ncom/intellij/ml/llm/agents/claude/code/monitoring/TokenMonitoringService\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n72#2,2:70\n1#3:72\n*S KotlinDebug\n*F\n+ 1 TokenMonitoringService.kt\ncom/intellij/ml/llm/agents/claude/code/monitoring/TokenMonitoringService\n*L\n15#1:70,2\n15#1:72\n*E\n"})
public final class TokenMonitoringService {
    @NotNull
    private final ConcurrentHashMap<String, TokenStats> sessionStats = new ConcurrentHashMap();
    @NotNull
    private final BigDecimal TOKEN_LOSS_RATIO = new BigDecimal(String.valueOf(1.46));
    @NotNull
    private final BigDecimal MILLION;
    @NotNull
    private final BigDecimal QUOTA_MULTIPLIER;
    @NotNull
    private final BigDecimal SONNET_4_INPUT;
    @NotNull
    private final BigDecimal SONNET_4_INPUT_EXTENDED;
    @NotNull
    private final BigDecimal SONNET_4_INPUT_CACHE_WRITE;
    @NotNull
    private final BigDecimal SONNET_4_INPUT_CACHE_WRITE_EXTENDED;
    @NotNull
    private final BigDecimal SONNET_4_INPUT_CACHE_READ;
    @NotNull
    private final BigDecimal SONNET_4_INPUT_CACHE_READ_EXTENDED;
    @NotNull
    private final BigDecimal SONNET_4_OUTPUT;
    @NotNull
    private final BigDecimal SONNET_4_OUTPUT_EXTENDED;

    public TokenMonitoringService() {
        BigDecimal bigDecimal = BigDecimal.valueOf(1000000);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        this.MILLION = bigDecimal;
        BigDecimal bigDecimal2 = BigDecimal.valueOf(100000);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(...)");
        this.QUOTA_MULTIPLIER = bigDecimal2;
        BigDecimal bigDecimal3 = new BigDecimal(String.valueOf(3.0)).multiply(this.QUOTA_MULTIPLIER);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"multiply(...)");
        BigDecimal bigDecimal4 = bigDecimal3.divide(this.MILLION, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"divide(...)");
        this.SONNET_4_INPUT = bigDecimal4;
        BigDecimal bigDecimal5 = new BigDecimal(String.valueOf(6.0)).multiply(this.QUOTA_MULTIPLIER);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"multiply(...)");
        BigDecimal bigDecimal6 = bigDecimal5.divide(this.MILLION, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"divide(...)");
        this.SONNET_4_INPUT_EXTENDED = bigDecimal6;
        BigDecimal bigDecimal7 = new BigDecimal(String.valueOf(3.75)).multiply(this.QUOTA_MULTIPLIER);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal7, (String)"multiply(...)");
        BigDecimal bigDecimal8 = bigDecimal7.divide(this.MILLION, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal8, (String)"divide(...)");
        this.SONNET_4_INPUT_CACHE_WRITE = bigDecimal8;
        BigDecimal bigDecimal9 = new BigDecimal(String.valueOf(7.5)).multiply(this.QUOTA_MULTIPLIER);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal9, (String)"multiply(...)");
        BigDecimal bigDecimal10 = bigDecimal9.divide(this.MILLION, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal10, (String)"divide(...)");
        this.SONNET_4_INPUT_CACHE_WRITE_EXTENDED = bigDecimal10;
        BigDecimal bigDecimal11 = new BigDecimal(String.valueOf(0.3)).multiply(this.QUOTA_MULTIPLIER);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal11, (String)"multiply(...)");
        BigDecimal bigDecimal12 = bigDecimal11.divide(this.MILLION, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal12, (String)"divide(...)");
        this.SONNET_4_INPUT_CACHE_READ = bigDecimal12;
        BigDecimal bigDecimal13 = new BigDecimal(String.valueOf(0.6)).multiply(this.QUOTA_MULTIPLIER);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal13, (String)"multiply(...)");
        BigDecimal bigDecimal14 = bigDecimal13.divide(this.MILLION, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal14, (String)"divide(...)");
        this.SONNET_4_INPUT_CACHE_READ_EXTENDED = bigDecimal14;
        BigDecimal bigDecimal15 = new BigDecimal(String.valueOf(15.0)).multiply(this.QUOTA_MULTIPLIER);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal15, (String)"multiply(...)");
        BigDecimal bigDecimal16 = bigDecimal15.divide(this.MILLION, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal16, (String)"divide(...)");
        this.SONNET_4_OUTPUT = bigDecimal16;
        BigDecimal bigDecimal17 = new BigDecimal(String.valueOf(22.5)).multiply(this.QUOTA_MULTIPLIER);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal17, (String)"multiply(...)");
        BigDecimal bigDecimal18 = bigDecimal17.divide(this.MILLION, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal18, (String)"divide(...)");
        this.SONNET_4_OUTPUT_EXTENDED = bigDecimal18;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object updateFromUsage(@NotNull String sessionId, @NotNull Usage usage, @NotNull Continuation<? super Unit> $completion) {
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = this.sessionStats;
        String key$iv = sessionId;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            TokenStats default$iv = new TokenStats(null, null, 3, null);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        TokenStats stats = (TokenStats)object;
        stats.getInputTokens().addAndGet(usage.getInput_tokens() + usage.getCache_creation_input_tokens());
        stats.getOutputTokens().addAndGet(usage.getOutput_tokens());
        Object object2 = GrazieSpentQuotaFunctionsKt.registerGrazieQuotaSpent(() -> TokenMonitoringService.updateFromUsage$lambda$1(this, usage), $completion);
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    public final int getInputTokens(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Object object = this.sessionStats.get(sessionId);
        return object != null && (object = ((TokenStats)object).getInputTokens()) != null ? ((AtomicInteger)object).get() : 0;
    }

    public final int getOutputTokens(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Object object = this.sessionStats.get(sessionId);
        return object != null && (object = ((TokenStats)object).getOutputTokens()) != null ? ((AtomicInteger)object).get() : 0;
    }

    public final void clear(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.sessionStats.remove(sessionId);
    }

    @Deprecated(message="Should be replaced with the internal grazie API by 2025.10.01")
    private final BigDecimal toQuota(Usage $this$toQuota) {
        BigDecimal bigDecimal;
        if ($this$toQuota.getInput_tokens() <= 200000) {
            BigDecimal bigDecimal2 = BigDecimal.valueOf($this$toQuota.getInput_tokens());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(...)");
            BigDecimal bigDecimal3 = bigDecimal2.multiply(this.SONNET_4_INPUT);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"multiply(...)");
            BigDecimal bigDecimal4 = BigDecimal.valueOf($this$toQuota.getCache_creation_input_tokens());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"valueOf(...)");
            BigDecimal bigDecimal5 = bigDecimal4.multiply(this.SONNET_4_INPUT_CACHE_WRITE);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"multiply(...)");
            BigDecimal bigDecimal6 = bigDecimal3.add(bigDecimal5);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"add(...)");
            BigDecimal bigDecimal7 = BigDecimal.valueOf($this$toQuota.getCache_read_input_tokens());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal7, (String)"valueOf(...)");
            BigDecimal bigDecimal8 = bigDecimal7.multiply(this.SONNET_4_INPUT_CACHE_READ);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal8, (String)"multiply(...)");
            BigDecimal bigDecimal9 = bigDecimal6.add(bigDecimal8);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal9, (String)"add(...)");
            BigDecimal bigDecimal10 = BigDecimal.valueOf($this$toQuota.getOutput_tokens());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal10, (String)"valueOf(...)");
            BigDecimal bigDecimal11 = bigDecimal10.multiply(this.SONNET_4_OUTPUT);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal11, (String)"multiply(...)");
            BigDecimal bigDecimal12 = bigDecimal9.add(bigDecimal11);
            bigDecimal = bigDecimal12;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal12, (String)"add(...)");
        } else {
            BigDecimal bigDecimal13 = BigDecimal.valueOf($this$toQuota.getInput_tokens());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal13, (String)"valueOf(...)");
            BigDecimal bigDecimal14 = bigDecimal13.multiply(this.SONNET_4_INPUT_EXTENDED);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal14, (String)"multiply(...)");
            BigDecimal bigDecimal15 = BigDecimal.valueOf($this$toQuota.getCache_creation_input_tokens());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal15, (String)"valueOf(...)");
            BigDecimal bigDecimal16 = bigDecimal15.multiply(this.SONNET_4_INPUT_CACHE_WRITE_EXTENDED);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal16, (String)"multiply(...)");
            BigDecimal bigDecimal17 = bigDecimal14.add(bigDecimal16);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal17, (String)"add(...)");
            BigDecimal bigDecimal18 = BigDecimal.valueOf($this$toQuota.getCache_read_input_tokens());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal18, (String)"valueOf(...)");
            BigDecimal bigDecimal19 = bigDecimal18.multiply(this.SONNET_4_INPUT_CACHE_READ_EXTENDED);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal19, (String)"multiply(...)");
            BigDecimal bigDecimal20 = bigDecimal17.add(bigDecimal19);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal20, (String)"add(...)");
            BigDecimal bigDecimal21 = BigDecimal.valueOf($this$toQuota.getOutput_tokens());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal21, (String)"valueOf(...)");
            BigDecimal bigDecimal22 = bigDecimal21.multiply(this.SONNET_4_OUTPUT_EXTENDED);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal22, (String)"multiply(...)");
            BigDecimal bigDecimal23 = bigDecimal20.add(bigDecimal22);
            bigDecimal = bigDecimal23;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal23, (String)"add(...)");
        }
        BigDecimal bigDecimal24 = bigDecimal.multiply(this.TOKEN_LOSS_RATIO);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal24, (String)"multiply(...)");
        return bigDecimal24;
    }

    private static final BigDecimal updateFromUsage$lambda$1(TokenMonitoringService this$0, Usage $usage) {
        return this$0.toQuota($usage);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/agents/claude/code/monitoring/TokenMonitoringService$TokenStats;", "", "inputTokens", "Ljava/util/concurrent/atomic/AtomicInteger;", "outputTokens", "<init>", "(Ljava/util/concurrent/atomic/AtomicInteger;Ljava/util/concurrent/atomic/AtomicInteger;)V", "getInputTokens", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getOutputTokens", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.agents.claude.code"})
    public static final class TokenStats {
        @NotNull
        private final AtomicInteger inputTokens;
        @NotNull
        private final AtomicInteger outputTokens;

        public TokenStats(@NotNull AtomicInteger inputTokens, @NotNull AtomicInteger outputTokens) {
            Intrinsics.checkNotNullParameter((Object)inputTokens, (String)"inputTokens");
            Intrinsics.checkNotNullParameter((Object)outputTokens, (String)"outputTokens");
            this.inputTokens = inputTokens;
            this.outputTokens = outputTokens;
        }

        public /* synthetic */ TokenStats(AtomicInteger atomicInteger, AtomicInteger atomicInteger2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                atomicInteger = new AtomicInteger(0);
            }
            if ((n & 2) != 0) {
                atomicInteger2 = new AtomicInteger(0);
            }
            this(atomicInteger, atomicInteger2);
        }

        @NotNull
        public final AtomicInteger getInputTokens() {
            return this.inputTokens;
        }

        @NotNull
        public final AtomicInteger getOutputTokens() {
            return this.outputTokens;
        }

        @NotNull
        public final AtomicInteger component1() {
            return this.inputTokens;
        }

        @NotNull
        public final AtomicInteger component2() {
            return this.outputTokens;
        }

        @NotNull
        public final TokenStats copy(@NotNull AtomicInteger inputTokens, @NotNull AtomicInteger outputTokens) {
            Intrinsics.checkNotNullParameter((Object)inputTokens, (String)"inputTokens");
            Intrinsics.checkNotNullParameter((Object)outputTokens, (String)"outputTokens");
            return new TokenStats(inputTokens, outputTokens);
        }

        public static /* synthetic */ TokenStats copy$default(TokenStats tokenStats, AtomicInteger atomicInteger, AtomicInteger atomicInteger2, int n, Object object) {
            if ((n & 1) != 0) {
                atomicInteger = tokenStats.inputTokens;
            }
            if ((n & 2) != 0) {
                atomicInteger2 = tokenStats.outputTokens;
            }
            return tokenStats.copy(atomicInteger, atomicInteger2);
        }

        @NotNull
        public String toString() {
            return "TokenStats(inputTokens=" + this.inputTokens + ", outputTokens=" + this.outputTokens + ")";
        }

        public int hashCode() {
            int result2 = this.inputTokens.hashCode();
            result2 = result2 * 31 + this.outputTokens.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenStats)) {
                return false;
            }
            TokenStats tokenStats = (TokenStats)other;
            if (!Intrinsics.areEqual((Object)this.inputTokens, (Object)tokenStats.inputTokens)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.outputTokens, (Object)tokenStats.outputTokens);
        }

        public TokenStats() {
            this(null, null, 3, null);
        }
    }
}

