/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.impl.chat.processing;

import com.intellij.ml.llm.agents.impl.chat.messages.AgentMessage;
import com.intellij.ml.llm.agents.impl.chat.processing.MessageProcessingLogGroup;
import com.intellij.ml.llm.agents.impl.chat.processing.MessageProcessingLogGroupMessagePartContainer;
import com.intellij.ml.llm.agents.impl.chat.processing.MessageProcessingLogGroupMessagePartKt;
import com.intellij.ml.llm.agents.impl.chat.processing.MessageProcessingLogGroupRestoredMessagePartContainer;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.messages.impl.RestoredMessage;
import com.intellij.ml.llm.core.chat.parts.MessagePart;
import com.intellij.ml.llm.core.chat.parts.MessagePartContext;
import com.intellij.ml.llm.core.chat.parts.MessagePartFactory;
import com.intellij.ml.llm.core.chat.parts.MessagePartFactoryKt;
import com.intellij.ml.llm.core.chat.parts.TextPart;
import com.intellij.util.Range;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/agents/impl/chat/processing/MessageProcessingLogGroupMessagePartFactory;", "Lcom/intellij/ml/llm/core/chat/parts/MessagePartFactory;", "<init>", "()V", "isApplicable", "", "context", "Lcom/intellij/ml/llm/core/chat/parts/MessagePartContext;", "getStartMarkerIndex", "Lcom/intellij/util/Range;", "", "Lcom/intellij/ml/llm/core/chat/parts/MessagePartRange;", "text", "", "getEndMarkerIndex", "currentPart", "Lcom/intellij/ml/llm/core/chat/parts/MessagePart;", "createMessagePart", "intellij.ml.llm.agents.impl"})
public final class MessageProcessingLogGroupMessagePartFactory
implements MessagePartFactory {
    public boolean isApplicable(@NotNull MessagePartContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return context2.getMessage() instanceof AgentMessage || context2.getMessage() instanceof RestoredMessage;
    }

    @NotNull
    public Range<Integer> getStartMarkerIndex(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return MessagePartFactoryKt.markerRange((String)text2, (String)"<llm-progress-log-group", (String)">");
    }

    @NotNull
    public Range<Integer> getEndMarkerIndex(@Nullable MessagePart currentPart, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return MessagePartFactoryKt.markerRange((String)text2, (String)"</llm-progress-log-group>");
    }

    @NotNull
    public MessagePart createMessagePart(@NotNull MessagePartContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ChatMessage message = context2.getMessage();
        if (message instanceof RestoredMessage) {
            return (MessagePart)new MessageProcessingLogGroupRestoredMessagePartContainer(context2.getProject(), (RestoredMessage)message);
        }
        Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type com.intellij.ml.llm.agents.impl.chat.messages.AgentMessage");
        AgentMessage agentMessage2 = (AgentMessage)message;
        MessageProcessingLogGroup messageProcessingLogGroup = agentMessage2.getActiveProgressGroup();
        if (messageProcessingLogGroup == null) {
            MessageProcessingLogGroupMessagePartFactory $this$createMessagePart_u24lambda_u240 = this;
            boolean bl = false;
            MessageProcessingLogGroupMessagePartKt.access$getLog$p().warn("No active progress group found for " + agentMessage2.getUid());
            return (MessagePart)new TextPart((MarkdownChatMessage)agentMessage2);
        }
        MessageProcessingLogGroup progressLogGroup = messageProcessingLogGroup;
        return (MessagePart)new MessageProcessingLogGroupMessagePartContainer(context2.getProject(), progressLogGroup, agentMessage2);
    }
}

