/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.impl.chat.processing.plan;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.ml.llm.agents.impl.chat.processing.ComponentsKt;
import com.intellij.ml.llm.agents.impl.chat.processing.plan.EditableHtmlPane;
import com.intellij.ml.llm.core.chat.ui.chat.TextPartViewKt;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBHtmlPaneConfiguration;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import com.intellij.util.ui.JBFont;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u0019J\u0006\u0010 \u001a\u00020\u0019J\u0006\u0010!\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/agents/impl/chat/processing/plan/EditableHtmlPane;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "initialText", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "editing", "", "isEditing", "()Z", "currentText", "htmlPane", "Lcom/intellij/ui/components/JBHtmlPane;", "markdownField", "Lcom/intellij/ui/LanguageTextField;", "getMarkdownField", "()Lcom/intellij/ui/LanguageTextField;", "markdownField$delegate", "Lkotlin/Lazy;", "text", "getText", "()Ljava/lang/String;", "setCenterComponent", "", "comp", "Ljava/awt/Component;", "applyScheme", "ed", "Lcom/intellij/openapi/editor/ex/EditorEx;", "edit", "save", "revert", "intellij.ml.llm.agents.impl"})
@SourceDebugExtension(value={"SMAP\nEditableHtmlPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditableHtmlPane.kt\ncom/intellij/ml/llm/agents/impl/chat/processing/plan/EditableHtmlPane\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,117:1\n42#2,3:118\n*S KotlinDebug\n*F\n+ 1 EditableHtmlPane.kt\ncom/intellij/ml/llm/agents/impl/chat/processing/plan/EditableHtmlPane\n*L\n43#1:118,3\n*E\n"})
public final class EditableHtmlPane
extends JPanel {
    @NotNull
    private final Project project;
    private boolean editing;
    @NotNull
    private String currentText;
    @NotNull
    private final JBHtmlPane htmlPane;
    @NotNull
    private final Lazy markdownField$delegate;

    /*
     * WARNING - void declaration
     */
    public EditableHtmlPane(@NotNull Project project2, @NotNull String initialText) {
        void $this$htmlPane_u24lambda_u241;
        JBHtmlPane jBHtmlPane;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        super(new BorderLayout());
        this.project = project2;
        this.currentText = initialText;
        JBHtmlPane jBHtmlPane2 = jBHtmlPane = new JBHtmlPane(new JBHtmlPaneStyleConfiguration(), new JBHtmlPaneConfiguration(EditableHtmlPane::htmlPane$lambda$0));
        EditableHtmlPane editableHtmlPane = this;
        boolean bl = false;
        JBFont jBFont = JBFont.label();
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"label(...)");
        JBFont defaultFont = jBFont;
        boolean $i$f$service = false;
        Class<LLMSettingsManager> serviceClass$iv = LLMSettingsManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        float scaledFontSize = ComponentsKt.getOriginalScale() * ((LLMSettingsManager)object).getToolwindowFontScale() * 13.0f;
        $this$htmlPane_u24lambda_u241.setFont((Font)defaultFont.deriveFont(scaledFontSize));
        $this$htmlPane_u24lambda_u241.setCaretColor($this$htmlPane_u24lambda_u241.getForeground());
        $this$htmlPane_u24lambda_u241.setEditable(false);
        $this$htmlPane_u24lambda_u241.setFocusable(true);
        $this$htmlPane_u24lambda_u241.setOpaque(false);
        $this$htmlPane_u24lambda_u241.setText(TextPartViewKt.markdownToChatHtml((String)initialText, null, null));
        editableHtmlPane.htmlPane = jBHtmlPane;
        this.markdownField$delegate = LazyKt.lazy(() -> EditableHtmlPane.markdownField_delegate$lambda$0(this));
        this.setCenterComponent((Component)this.htmlPane);
    }

    public final boolean isEditing() {
        return this.editing;
    }

    private final LanguageTextField getMarkdownField() {
        Lazy lazy = this.markdownField$delegate;
        return (LanguageTextField)lazy.getValue();
    }

    @NotNull
    public final String getText() {
        return this.currentText;
    }

    private final void setCenterComponent(Component comp) {
        ApplicationManager.getApplication().invokeLater(() -> EditableHtmlPane.setCenterComponent$lambda$0(this, comp));
    }

    private final void applyScheme(EditorEx ed) {
        JComponent jComponent;
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        ed.setColorsScheme(scheme);
        ed.setBackgroundColor(scheme.getDefaultBackground());
        ed.getGutterComponentEx().setBackground(scheme.getDefaultBackground());
        JComponent $this$applyScheme_u24lambda_u240 = jComponent = ed.getContentComponent();
        boolean bl = false;
        $this$applyScheme_u24lambda_u240.setOpaque(true);
        $this$applyScheme_u24lambda_u240.setBackground(scheme.getDefaultBackground());
    }

    public final void edit() {
        this.setCenterComponent((Component)this.getMarkdownField());
        this.editing = true;
    }

    public final void save() {
        ApplicationManager.getApplication().invokeLater(() -> EditableHtmlPane.save$lambda$0(this));
    }

    public final void revert() {
        ApplicationManager.getApplication().invokeLater(() -> EditableHtmlPane.revert$lambda$0(this));
    }

    private static final Unit htmlPane$lambda$0(JBHtmlPaneConfiguration.Builder $this$JBHtmlPaneConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$JBHtmlPaneConfiguration, (String)"$this$JBHtmlPaneConfiguration");
        $this$JBHtmlPaneConfiguration.customStyleSheet(StringsKt.trimIndent((String)("\n          code { background-color: " + ComponentsKt.getCODE_BACKGROUND() + "; font-weight: normal; text-decoration: none; }\n          a { text-decoration: none; }\n        ")));
        return Unit.INSTANCE;
    }

    private static final markdownField.2.1 markdownField_delegate$lambda$0(EditableHtmlPane this$0) {
        Language language = MarkdownFileType.INSTANCE.getLanguage();
        Project project2 = this$0.project;
        String string = this$0.currentText;
        return new LanguageTextField(this$0, language, project2, string){
            final /* synthetic */ EditableHtmlPane this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, false);
            }

            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
                EditorEx ed = editorEx;
                ed.getSettings().setUseSoftWraps(true);
                ed.getSettings().setAdditionalPageAtBottom(false);
                EditorHighlighterFactory editorHighlighterFactory = EditorHighlighterFactory.Companion.getInstance();
                Project project2 = this.getProject();
                MarkdownFileType markdownFileType = MarkdownFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)markdownFileType, (String)"INSTANCE");
                ed.setHighlighter(editorHighlighterFactory.createEditorHighlighter(project2, (FileType)markdownFileType));
                EditableHtmlPane.access$applyScheme(this.this$0, ed);
                return ed;
            }
        };
    }

    private static final void setCenterComponent$lambda$0(EditableHtmlPane this$0, Component $comp) {
        this$0.removeAll();
        this$0.add($comp, "Center");
        this$0.revalidate();
        this$0.repaint();
    }

    private static final void save$lambda$0(EditableHtmlPane this$0) {
        String string = this$0.getMarkdownField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String newValue = string;
        if (!Intrinsics.areEqual((Object)newValue, (Object)this$0.currentText)) {
            this$0.currentText = newValue;
            this$0.htmlPane.setText(TextPartViewKt.markdownToChatHtml((String)newValue, null, null));
        }
        this$0.setCenterComponent((Component)this$0.htmlPane);
        this$0.editing = false;
    }

    private static final void revert$lambda$0(EditableHtmlPane this$0) {
        this$0.getMarkdownField().setText(this$0.currentText);
        this$0.setCenterComponent((Component)this$0.htmlPane);
        this$0.editing = false;
    }

    public static final /* synthetic */ void access$applyScheme(EditableHtmlPane $this, EditorEx ed) {
        $this.applyScheme(ed);
    }
}

