/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chatInputLanguage;

import com.intellij.lang.Language;
import com.intellij.ml.llm.chatInputLanguage.ChatInputLanguage;
import com.intellij.ml.llm.chatInputLanguage.ChatInputLexerAdapter;
import com.intellij.ml.llm.chatInputLanguage.extensions.ChatInputReferenceExtension;
import com.intellij.ml.llm.chatInputLanguage.psi.ChatInputTypes;
import com.intellij.ml.llm.core.chat.ui.chat.UserMessageTextToHtmlConvertor;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.util.XmlStringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0002J\u001c\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0002J\u0014\u0010\u0011\u001a\u00020\n2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0002J\u001c\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/ChatInputUserMessageTextToHtmlConvertor;", "Lcom/intellij/ml/llm/core/chat/ui/chat/UserMessageTextToHtmlConvertor;", "<init>", "()V", "convert", "", "messageText", "language", "Lcom/intellij/lang/Language;", "renderChatInputCommand", "", "lexer", "Lcom/intellij/ml/llm/chatInputLanguage/ChatInputLexerAdapter;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "renderChatInputReference", "renderChatInputNewLine", "renderChatInputCodeSpan", "intellij.ml.llm.chatInputLanguage"})
@SourceDebugExtension(value={"SMAP\nChatInputUserMessageTextToHtmlConvertor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatInputUserMessageTextToHtmlConvertor.kt\ncom/intellij/ml/llm/chatInputLanguage/ChatInputUserMessageTextToHtmlConvertor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class ChatInputUserMessageTextToHtmlConvertor
implements UserMessageTextToHtmlConvertor {
    @Nullable
    public String convert(@NotNull String messageText, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!Intrinsics.areEqual((Object)language, (Object)((Object)ChatInputLanguage.INSTANCE))) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ChatInputLexerAdapter lexer = new ChatInputLexerAdapter();
        lexer.start(messageText);
        while (lexer.getTokenStart() < lexer.getBufferEnd()) {
            IElementType iElementType = lexer.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)ChatInputTypes.REFERENCE_START)) {
                this.renderChatInputReference(lexer, stringBuilder);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)ChatInputTypes.COMMAND)) {
                this.renderChatInputCommand(lexer, stringBuilder);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)ChatInputTypes.NEWLINE)) {
                this.renderChatInputNewLine(stringBuilder);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)ChatInputTypes.CODE_SPAN)) {
                this.renderChatInputCodeSpan(lexer, stringBuilder);
            } else {
                String xmlEscapedTokenText = XmlStringUtil.escapeString((String)lexer.getTokenText());
                stringBuilder.append(xmlEscapedTokenText);
            }
            lexer.advance();
        }
        return stringBuilder.toString();
    }

    private final void renderChatInputCommand(ChatInputLexerAdapter lexer, StringBuilder builder) {
        builder.append("<code>");
        builder.append(lexer.getTokenText());
        builder.append("</code>");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void renderChatInputReference(ChatInputLexerAdapter lexer, StringBuilder builder) {
        builder.append("<code>");
        position = null;
        type = null;
        text = new StringBuilder();
        do {
            Intrinsics.checkNotNullExpressionValue((Object)lexer.getCurrentPosition(), (String)"getCurrentPosition(...)");
            if (Intrinsics.areEqual((Object)lexer.getTokenType(), (Object)ChatInputTypes.REFERENCE_TYPE)) {
                type = lexer.getTokenText();
            }
            text.append(lexer.getTokenText());
            lexer.advance();
        } while (Intrinsics.areEqual((Object)lexer.getTokenType(), (Object)ChatInputTypes.REFERENCE_TYPE) || Intrinsics.areEqual((Object)lexer.getTokenType(), (Object)ChatInputTypes.REFERENCE_SEPARATOR) || Intrinsics.areEqual((Object)lexer.getTokenType(), (Object)ChatInputTypes.REFERENCE_VALUE_DELIMITER) || Intrinsics.areEqual((Object)lexer.getTokenType(), (Object)ChatInputTypes.REFERENCE_VALUE));
        v0 = type;
        if (v0 == null) ** GOTO lbl-1000
        it = v0;
        $i$a$-let-ChatInputUserMessageTextToHtmlConvertor$renderChatInputReference$presentation$1 = false;
        v1 = ChatInputReferenceExtension.Companion.forType(it);
        v0 = v1;
        if (v1 != null) {
            v2 = text.toString();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toString(...)");
            v3 /* !! */  = v0.getChatPresentation(v2);
        } else lbl-1000:
        // 2 sources

        {
            v3 /* !! */  = null;
        }
        if ((v4 = (presentation = v3 /* !! */ )) == null) {
            v4 = text;
        }
        builder.append((CharSequence)v4);
        builder.append("</code>");
        lexer.restore(position);
    }

    private final void renderChatInputNewLine(StringBuilder builder) {
        builder.append("<br>");
    }

    private final void renderChatInputCodeSpan(ChatInputLexerAdapter lexer, StringBuilder builder) {
        String string = lexer.getTokenText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
        char[] cArray = new char[]{'`'};
        String string2 = StringsKt.trimStart((String)string, (char[])cArray);
        cArray = new char[]{'`'};
        String text2 = XmlStringUtil.escapeString((String)StringsKt.trimEnd((String)string2, (char[])cArray));
        builder.append("<code>");
        builder.append(text2);
        builder.append("</code>");
    }
}

