/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chatInputLanguage.commands;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.chatInputLanguage.commands.ChatInputCommandProvider;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantInputCompiler;
import com.intellij.ml.llm.core.models.LlmProfileService;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.qa.endpoint.DocumentationQAEndpointKt;
import com.intellij.ml.llm.qa.sources.DocumentationSource;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/commands/SearchDocsChatInputCommandProvider;", "Lcom/intellij/ml/llm/chatInputLanguage/commands/ChatInputCommandProvider;", "<init>", "()V", "namePSString", "Lcom/intellij/ml/llm/privacy/PSString;", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "enabled", "", "getEnabled", "()Z", "compile", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInputCompiler$CompiledCommand;", "project", "Lcom/intellij/openapi/project/Project;", "output", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInputCompiler$Output;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInputCompiler$Output;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.chatInputLanguage"})
@SourceDebugExtension(value={"SMAP\nSearchDocsChatInputCommandProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchDocsChatInputCommandProvider.kt\ncom/intellij/ml/llm/chatInputLanguage/commands/SearchDocsChatInputCommandProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,47:1\n42#2,3:48\n*S KotlinDebug\n*F\n+ 1 SearchDocsChatInputCommandProvider.kt\ncom/intellij/ml/llm/chatInputLanguage/commands/SearchDocsChatInputCommandProvider\n*L\n23#1:48,3\n*E\n"})
public final class SearchDocsChatInputCommandProvider
implements ChatInputCommandProvider {
    @NotNull
    private final PSString namePSString = DocumentationQAEndpointKt.getDOC_SEARCH_COMMAND();
    @NotNull
    private final String name = (String)this.namePSString.unwrap();
    @NotNull
    private final String description = LLMBundle.message((String)"ai.assistant.command.docs.description", (Object[])new Object[0]);

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getEnabled() {
        if (!Registry.Companion.is("llm.smartChat.endpointEnabled.DocumentationQAEndpoint")) return false;
        if (((Collection)DocumentationSource.Companion.getSources()).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        boolean $i$f$service = false;
        Class<LlmProfileService> serviceClass$iv = LlmProfileService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        if (!((LlmProfileService)object).isSmartChatSupportedIfLoaded()) return false;
        return true;
    }

    @Override
    @Nullable
    public Object compile(@NotNull Project project2, @NotNull AIAssistantInputCompiler.Output output, @NotNull Continuation<? super AIAssistantInputCompiler.CompiledCommand> $completion) {
        PSString internalText = this.getDescription();
        String string = this.getName();
        TextRange textRange = TextRange.EMPTY_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
        return new AIAssistantInputCompiler.CompiledCommand(string, internalText, textRange, null, false, 24, null);
    }

    private final PSString getDescription() {
        PSString sources = PSStringKt.joinToString$default((Iterable)DocumentationSource.Companion.getSources(), (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)", ")), null, null, (int)0, null, SearchDocsChatInputCommandProvider::getDescription$lambda$0, (int)30, null);
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{this.namePSString, DocumentationQAEndpointKt.getDOCUMENTATION_QA_FUNCTION_NAME(), sources, DocumentationQAEndpointKt.getDOCUMENTATION_QA_FUNCTION_NAME(), DocumentationQAEndpointKt.getDOCS_COMMAND_EXAMPLE_TAG()};
        return ConstantsKt.getPrivacyConst((String)"\n      /%s command description:\n      Enforce internal function %s for user's query (in current or in a previous message). Searchable documentation sources: %s\n      \n      If the user has not provided any query, tell them the purpose of this command (but without mentioning %s) and add this tag at the end of your message: <%s/>\n      If user query is irrelevant to available documentation sources, you should tell user that.\n    ").trimIndent().format(pSStringConvertibleArray);
    }

    private static final PrivacySafe getDescription$lambda$0(DocumentationSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (PrivacySafe)it.getPresentableName();
    }
}

