/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.lightAgent.context;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.codeGeneration.AICodeGenerationFeatures;
import com.intellij.ml.llm.codeGeneration.lightAgent.context.entities.PathContext;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00050\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002J\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/codeGeneration/lightAgent/context/ProjectStructureContextProvider;", "", "<init>", "()V", "createProjectStructureContext", "", "Lcom/intellij/ml/llm/codeGeneration/lightAgent/context/entities/PathContext;", "project", "Lcom/intellij/openapi/project/Project;", "getProjectStructure", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "isExcluded", "", "file", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "excludedUrls", "isUrlExcluded", "url", "intellij.ml.llm.codeGeneration"})
@ApiStatus.Experimental
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nProjectStructureContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStructureContext.kt\ncom/intellij/ml/llm/codeGeneration/lightAgent/context/ProjectStructureContextProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,123:1\n1563#2:124\n1634#2,3:125\n774#2:128\n865#2,2:129\n1869#2:132\n1869#2,2:133\n1870#2:135\n1761#2,3:137\n1321#3:131\n1322#3:136\n*S KotlinDebug\n*F\n+ 1 ProjectStructureContext.kt\ncom/intellij/ml/llm/codeGeneration/lightAgent/context/ProjectStructureContextProvider\n*L\n33#1:124\n33#1:125,3\n38#1:128\n38#1:129,2\n55#1:132\n57#1:133,2\n55#1:135\n99#1:137,3\n53#1:131\n53#1:136\n*E\n"})
public final class ProjectStructureContextProvider {
    @NotNull
    public static final ProjectStructureContextProvider INSTANCE = new ProjectStructureContextProvider();
    public static final int $stable;

    private ProjectStructureContextProvider() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<PathContext> createProjectStructureContext(@NotNull Project project2) {
        void $this$filterTo$iv$iv;
        PathContext it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!AICodeGenerationFeatures.INSTANCE.isLightAgentProjectStructureContextEnabled()) {
            return null;
        }
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)project2);
        String projectDirName = (virtualFile2 != null ? virtualFile2.getPath() : null) + "/";
        List virtualFiles2 = CollectionsKt.flatten((Iterable)this.getProjectStructure(project2).values());
        Iterable $this$map$iv = virtualFiles2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            VirtualFile virtualFile3 = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PSString relativePath = ExtensionsKtKt.getPrivacySafe((VirtualFile)it).getPath().removePrefix(projectDirName);
            collection.add(new PathContext(relativePath, it.isDirectory()));
        }
        List pathContexts = (List)destination$iv$iv;
        Iterable $this$filter$iv = pathContexts;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PathContext)element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Map<String, List<VirtualFile>> getProjectStructure(Project project2) {
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project2);
        ImmutableEntityStorage entityStorage = workspaceModel.getCurrentSnapshot();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager virtualFileManager2 = virtualFileManager;
        Map sourceRootsWithFiles = new LinkedHashMap();
        List excludedUrls = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)entityStorage.entities(ExcludeUrlEntity.class), ProjectStructureContextProvider::getProjectStructure$lambda$0));
        Sequence $this$forEach$iv = entityStorage.entities(ModuleEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleEntity moduleEntity = (ModuleEntity)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = moduleEntity.getContentRoots();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ContentRootEntity contentRootEntity = (ContentRootEntity)element$iv2;
                boolean bl2 = false;
                Iterable $this$forEach$iv3 = contentRootEntity.getSourceRoots();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    String rootPath;
                    VirtualFile rootVirtualFile;
                    SourceRootEntity sourceRootEntity = (SourceRootEntity)element$iv3;
                    boolean bl3 = false;
                    String rootUrl = sourceRootEntity.getUrl().getUrl();
                    Intrinsics.checkNotNull((Object)rootUrl);
                    if (INSTANCE.isUrlExcluded(rootUrl, excludedUrls) || (rootVirtualFile = virtualFileManager2.findFileByUrl(rootUrl)) == null || !rootVirtualFile.isValid() || !rootVirtualFile.isDirectory()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)rootVirtualFile.getPath(), (String)"getPath(...)");
                    List files = new ArrayList();
                    fileIndex.iterateContentUnderDirectory(rootVirtualFile, arg_0 -> ProjectStructureContextProvider.getProjectStructure$lambda$1$0$0$0(fileIndex, excludedUrls, files, arg_0));
                    sourceRootsWithFiles.put(rootPath, files);
                }
            }
        }
        return sourceRootsWithFiles;
    }

    private final boolean isExcluded(VirtualFile file, ProjectFileIndex fileIndex, List<String> excludedUrls) {
        if (((Boolean)ActionsKt.runReadAction(() -> ProjectStructureContextProvider.isExcluded$lambda$0(fileIndex, file))).booleanValue()) {
            return true;
        }
        String string = file.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        return this.isUrlExcluded(string, excludedUrls);
    }

    private final boolean isUrlExcluded(String url, List<String> excludedUrls) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = excludedUrls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)url, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String getProjectStructure$lambda$0(ExcludeUrlEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUrl().getUrl();
    }

    private static final boolean getProjectStructure$lambda$1$0$0$0(ProjectFileIndex $fileIndex, List $excludedUrls, List $files, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!INSTANCE.isExcluded(file, $fileIndex, $excludedUrls)) {
            $files.add(file);
        }
        return true;
    }

    private static final boolean isExcluded$lambda$0(ProjectFileIndex $fileIndex, VirtualFile $file) {
        return $fileIndex.isExcluded($file);
    }
}

