/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.multifile.core;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0016J\u0019\u0010\u000f\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\u000bH\u0016J \u0010\u001c\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\"\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\"\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0005H\u0016J\b\u0010,\u001a\u00020\rH\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/ml/llm/codeGeneration/multifile/core/InMemoryChangesVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "timestamp", "", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "<init>", "(Lcom/intellij/openapi/vcs/FilePath;JLcom/intellij/openapi/vfs/VirtualFileSystem;)V", "content", "", "isValid", "", "getParent", "getChildren", "", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "getFileSystem", "getUrl", "isWritable", "exists", "setFilePath", "", "getPath", "contentsToByteArray", "setBinaryContent", "newModificationStamp", "newTimeStamp", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "", "getLength", "refresh", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "getInputStream", "Ljava/io/InputStream;", "getTimeStamp", "isDirectory", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getModificationStamp", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
public final class InMemoryChangesVirtualFile
extends VirtualFile {
    @NotNull
    private FilePath filePath;
    private final long timestamp;
    @NotNull
    private final VirtualFileSystem fileSystem;
    @Nullable
    private byte[] content;
    public static final int $stable = 8;

    public InMemoryChangesVirtualFile(@NotNull FilePath filePath, long timestamp, @NotNull VirtualFileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.filePath = filePath;
        this.timestamp = timestamp;
        this.fileSystem = fileSystem;
    }

    public /* synthetic */ InMemoryChangesVirtualFile(FilePath filePath, long l2, VirtualFileSystem virtualFileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            virtualFileSystem = (VirtualFileSystem)localFileSystem;
        }
        this(filePath, l2, virtualFileSystem);
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.filePath.getVirtualFileParent();
    }

    @Nullable
    public VirtualFile[] getChildren() {
        return null;
    }

    @NotNull
    public String getName() {
        String string = this.filePath.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @NotNull
    public String getUrl() {
        String string = VirtualFileManager.constructUrl((String)this.fileSystem.getProtocol(), (String)this.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrl(...)");
        return string;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean exists() {
        return false;
    }

    public final void setFilePath(@NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.filePath = filePath;
    }

    @NotNull
    public String getPath() {
        String string = this.filePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = this.content;
        if (this.content == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public void setBinaryContent(@NotNull byte[] content2, long newModificationStamp, long newTimeStamp) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.content = content2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            byte[] byArray = this.content;
            if (this.content == null) {
                byArray = new byte[]{};
            }
            it.write(byArray);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        OutputStream outputStream2 = VfsUtilCore.outputStreamAddingBOM((OutputStream)outputStream, (VirtualFile)this);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"outputStreamAddingBOM(...)");
        return outputStream2;
    }

    public long getLength() {
        return this.content != null ? (long)this.content.length : 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    @NotNull
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.contentsToByteArray());
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public boolean isDirectory() {
        return false;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType2 = this.filePath.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
        return fileType2;
    }

    public long getModificationStamp() {
        return this.timestamp;
    }
}

