/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.popup;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/codeGeneration/popup/ActionButtonWithTextAndShortcutComponent;", "Lcom/intellij/openapi/actionSystem/impl/ActionButtonWithText;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "minimumSize", "Ljava/awt/Dimension;", "<init>", "(Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/Presentation;Ljava/lang/String;Ljava/awt/Dimension;)V", "getPreferredSize", "paintComponent", "", "g", "Ljava/awt/Graphics;", "getShortcutFont", "Ljava/awt/Font;", "getShortcutWidth", "", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
public final class ActionButtonWithTextAndShortcutComponent
extends ActionButtonWithText {
    public static final int $stable = 8;

    public ActionButtonWithTextAndShortcutComponent(@NotNull AnAction action2, @Nullable Presentation presentation2, @NotNull String place, @NotNull Dimension minimumSize) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)minimumSize, (String)"minimumSize");
        super(action2, presentation2, place, minimumSize);
        this.setHorizontalTextAlignment(2);
    }

    @Nullable
    public Dimension getPreferredSize() {
        Dimension result2 = super.getPreferredSize();
        return new Dimension(result2.width + this.getShortcutWidth(), result2.height);
    }

    public void paintComponent(@Nullable Graphics g) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        UISettings.Companion.setupAntialiasing(g);
        Icon icon2 = this.getIcon();
        String shortcut = this.getShortcutText();
        ActionButtonLook look = this.getButtonLook();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle viewRect = this.getButtonRect();
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)this.getInsets());
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)this.getMargins());
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        SwingUtilities.layoutCompoundLabel((JComponent)((Object)this), fm, this.getText(), icon2, 0, this.horizontalTextAlignment(), 0, this.horizontalTextPosition(), viewRect, iconRect, textRect, this.iconTextSpace());
        look.paintBackground(g, (JComponent)((Object)this));
        look.paintIcon(g, (ActionButtonComponent)this, icon2, iconRect.x, iconRect.y);
        look.paintBorder(g, (JComponent)((Object)this));
        ((Graphics2D)g).setColor(this.isEnabled() ? this.getForeground() : this.getInactiveTextColor());
        UIUtilities.drawStringUnderlineCharAt((JComponent)((JComponent)((Object)this)), (Graphics)g, (String)this.getText(), (int)this.getMnemonicCharIndex(this.getText()), (int)textRect.x, (int)(textRect.y + fm.getAscent()));
        CharSequence charSequence = shortcut;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        int shortcutX = Math.max(iconRect.x + iconRect.width, textRect.x + textRect.width) + JBUIScale.scale((int)4);
        ((Graphics2D)g).setFont(this.getShortcutFont());
        ((Graphics2D)g).setColor(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        ((Graphics2D)g).drawString(shortcut, shortcutX, textRect.y + fm.getAscent());
    }

    private final Font getShortcutFont() {
        Font font = ComponentPanelBuilder.getCommentFont((Font)this.getFont());
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getCommentFont(...)");
        return font;
    }

    private final int getShortcutWidth() {
        String shortcut = this.getShortcutText();
        CharSequence charSequence = shortcut;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return 0;
        }
        return JBUIScale.scale((int)4) + this.getFontMetrics(this.getShortcutFont()).stringWidth(shortcut);
    }
}

