/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.airules.context;

import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.context.airules.AiRulesLLMBundle;
import com.intellij.ml.llm.context.airules.context.AiRuleChatAttachment;
import com.intellij.ml.llm.context.airules.context.AiRuleContextAttachmentKt;
import com.intellij.ml.llm.context.airules.context.AiRuleContextSource;
import com.intellij.ml.llm.context.airules.metadata.AiRuleType;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentKind;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ProjectFileContextEntity;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010*\u001a\u0004\u0018\u00010+H\u0096@\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\n\u00106\u001a\u0004\u0018\u00010\u0006H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0014\u0010!\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0019R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u00101\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001e\u00a8\u00067"}, d2={"Lcom/intellij/ml/llm/context/airules/context/AiRuleContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ProjectFileContextEntity;", "project", "Lcom/intellij/openapi/project/Project;", "aiRuleFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "Lcom/intellij/ml/llm/privacy/PSString;", "ruleType", "Lcom/intellij/ml/llm/context/airules/metadata/AiRuleType;", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/context/airules/metadata/AiRuleType;Lcom/intellij/ml/llm/context/ContextEntitySource;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRuleType", "()Lcom/intellij/ml/llm/context/airules/metadata/AiRuleType;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "name", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "", "getName", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "hint", "getHint", "tooltipText", "getTooltipText", "()Ljava/lang/String;", "popupHintText", "getPopupHintText", "popupPresentationText", "getPopupPresentationText", "icon", "Ljavax/swing/Icon;", "getIcon", "kind", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentKind;", "getKind", "()Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentKind;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "text", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "id", "getId", "virtualFile", "intellij.ml.llm.context.airules"})
public final class AiRuleContextAttachment
extends ContextAttachmentBase
implements ProjectFileContextEntity {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile aiRuleFile;
    @NotNull
    private final PSString content;
    @NotNull
    private final AiRuleType ruleType;
    @NotNull
    private final ContextEntitySource attachedBy;
    @NotNull
    private final ObservableProperty<String> name;
    @Nullable
    private final ObservableProperty<String> hint;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String popupHintText;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final ObservableProperty<Icon> icon;
    @NotNull
    private final ContextAttachmentKind kind;
    @NotNull
    private final PSString text;
    @NotNull
    private final String id;

    public AiRuleContextAttachment(@NotNull Project project2, @NotNull VirtualFile aiRuleFile, @NotNull PSString content2, @NotNull AiRuleType ruleType2, @NotNull ContextEntitySource attachedBy) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)aiRuleFile, (String)"aiRuleFile");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)ruleType2), (String)"ruleType");
        Intrinsics.checkNotNullParameter((Object)attachedBy, (String)"attachedBy");
        this.project = project2;
        this.aiRuleFile = aiRuleFile;
        this.content = content2;
        this.ruleType = ruleType2;
        this.attachedBy = attachedBy;
        this.name = (ObservableProperty)new AtomicProperty((Object)this.aiRuleFile.getName());
        this.hint = (ObservableProperty)new AtomicProperty((Object)AiRulesLLMBundle.message("ai.rule.attachment.hint", new Object[0]));
        this.tooltipText = AiRuleContextAttachmentKt.removeProjectPrefix(this.getProject(), this.aiRuleFile);
        this.popupHintText = AiRuleContextAttachmentKt.removeProjectPrefix(this.getProject(), this.aiRuleFile);
        String string = this.aiRuleFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.popupPresentationText = string;
        this.icon = (ObservableProperty)new AtomicProperty((Object)VirtualFilePresentation.getIcon((VirtualFile)this.aiRuleFile));
        this.kind = ContextAttachmentKind.RULE;
        this.text = this.content;
        String string2 = this.aiRuleFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        this.id = string2;
    }

    public /* synthetic */ AiRuleContextAttachment(Project project2, VirtualFile virtualFile2, PSString pSString, AiRuleType aiRuleType, ContextEntitySource contextEntitySource, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            contextEntitySource = (ContextEntitySource)((Object)new AiRuleContextSource(aiRuleType.retrieverType()));
        }
        this(project2, virtualFile2, pSString, aiRuleType, contextEntitySource);
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final AiRuleType getRuleType() {
        return this.ruleType;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @NotNull
    public ObservableProperty<String> getName() {
        return this.name;
    }

    @Nullable
    public ObservableProperty<String> getHint() {
        return this.hint;
    }

    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @NotNull
    public String getPopupHintText() {
        return this.popupHintText;
    }

    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @NotNull
    public ObservableProperty<Icon> getIcon() {
        return this.icon;
    }

    @NotNull
    public ContextAttachmentKind getKind() {
        return this.kind;
    }

    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new AiRuleChatAttachment(this.getProject(), this.aiRuleFile, this.content, this.ruleType);
    }

    public void performAction(boolean isInMessage) {
        VirtualFile virtualFile2 = this.virtualFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file = virtualFile2;
        if (file.isValid()) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(file, true);
        }
    }

    @NotNull
    public PSString getText() {
        return this.text;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public VirtualFile virtualFile() {
        return this.aiRuleFile;
    }
}

